/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import org.glassfish.admin.cli.resources.BindableResourcesHelper;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="custom-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.custom.resource")
public class CustomResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CustomResourceManager.class);
    private static final String DESCRIPTION = "description";
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;
    private String resType = null;
    private String factoryClass = null;
    private String enabled = null;
    private String enabledValueForTarget = null;
    private String description = null;
    private String jndiName = null;

    public String getResourceType() {
        return "custom-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return CustomResourceManager.this.createResource(param, properties);
                }
            }, resources);
            this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.custom.resource.fail", "Unable to create custom resource {0}.", this.jndiName) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
        String msg = localStrings.getLocalString("create.custom.resource.success", "Custom Resource {0} created.", this.jndiName);
        return new ResourceStatus(0, msg, true);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        ResourceStatus status = new ResourceStatus(0, "Validation Successful");
        if (this.resType == null) {
            String msg = localStrings.getLocalString("create.custom.resource.noResType", "No type defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.factoryClass == null) {
            String msg = localStrings.getLocalString("create.custom.resource.noFactoryClassName", "No Factory class name defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, CustomResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        return status;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.resType = (String)attributes.get("res-type");
        this.factoryClass = (String)attributes.get("factory-class");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.description = (String)attributes.get(DESCRIPTION);
    }

    private Object createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private CustomResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = param.createChild(CustomResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFactoryClass(this.factoryClass);
        newResource.setResType(this.resType);
        newResource.setEnabled(this.enabled);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = null;
        status = !validate ? new ResourceStatus(0, "") : this.isValid(resources, false, null);
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }
}

