/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_list-resources")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class ListResources
implements AdminCommand {
    @Inject
    private Applications applications;
    @Param(optional=false, name="appname")
    private String appName;
    @Param(optional=true, name="modulename")
    private String moduleName;

    @Override
    public void execute(AdminCommandContext context) {
        Application application;
        Resources appScopedResources;
        if (this.appName != null && this.moduleName != null) {
            Application application2 = this.applications.getApplication(this.appName);
            Module module = application2.getModule(this.moduleName);
            Resources moduleScopedResources = module.getResources();
            if (moduleScopedResources != null) {
                ActionReport report = context.getActionReport();
                ActionReport.MessagePart messagePart = report.getTopMessagePart();
                this.generateResourcesList(messagePart, moduleScopedResources.getResources());
            }
        } else if (this.appName != null && (appScopedResources = (application = this.applications.getApplication(this.appName)).getResources()) != null) {
            ActionReport report = context.getActionReport();
            ActionReport.MessagePart messagePart = report.getTopMessagePart();
            this.generateResourcesList(messagePart, appScopedResources.getResources());
        }
    }

    private void generateResourcesList(ActionReport.MessagePart part, List<Resource> resources) {
        HashMap<String, List<String>> list = new HashMap<String, List<String>>();
        for (Resource resource : resources) {
            String type2;
            List<String> typedResources;
            String name;
            if (resource instanceof BindableResource) {
                name = ((BindableResource)resource).getJndiName();
                String type22 = "";
                if (resource instanceof JdbcResource) {
                    type22 = "<JdbcResource>";
                } else if (resource instanceof ConnectorResource) {
                    type22 = "<ConnectorResource>";
                } else if (resource instanceof ExternalJndiResource) {
                    type22 = "<ExternalJndiResource>";
                } else if (resource instanceof CustomResource) {
                    type22 = "<CustomResource>";
                } else if (resource instanceof AdminObjectResource) {
                    type22 = "<AdminObjectResource>";
                } else if (resource instanceof MailResource) {
                    type22 = "<MailResource>";
                }
                typedResources = this.getResourcesByType(list, type22);
                typedResources.add(name);
                continue;
            }
            if (resource instanceof ResourcePool) {
                name = ((ResourcePool)resource).getName();
                type2 = "";
                if (resource instanceof JdbcConnectionPool) {
                    type2 = "<JdbcConnectionPool>";
                } else if (resource instanceof ConnectorConnectionPool) {
                    type2 = "<ConnectorConnectionPool>";
                }
                typedResources = this.getResourcesByType(list, type2);
                typedResources.add(name);
                continue;
            }
            if (resource instanceof ResourceAdapterConfig) {
                name = ((ResourceAdapterConfig)resource).getResourceAdapterName();
                type2 = "<ResourceAdapterConfig>";
                typedResources = this.getResourcesByType(list, type2);
                typedResources.add(name);
                continue;
            }
            if (!(resource instanceof WorkSecurityMap)) continue;
            name = ((WorkSecurityMap)resource).getName();
            type2 = "<WorkSecurityMap>";
            typedResources = this.getResourcesByType(list, type2);
            typedResources.add(name);
        }
        for (Map.Entry entry : list.entrySet()) {
            String type3 = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                ActionReport.MessagePart child = part.addChild();
                child.setMessage("  " + value + "\t" + type3);
            }
        }
    }

    private List<String> getResourcesByType(Map<String, List<String>> list, String type2) {
        List<String> typedResources = list.get(type2);
        if (typedResources == null) {
            typedResources = new ArrayList<String>();
            list.put(type2, typedResources);
        }
        return typedResources;
    }
}

