/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_get-deployment-configurations")
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class GetDeploymentConfigurationsCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetDeploymentConfigurationsCommand.class);
    @Param(primary=true)
    private String appname = null;
    @Inject
    ApplicationRegistry appRegistry;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        ApplicationInfo appInfo = this.appRegistry.get(this.appname);
        if (appInfo == null) {
            return;
        }
        try {
            if (appInfo.getEngineRefs().size() > 0) {
                for (EngineRef ref : appInfo.getEngineRefs()) {
                    Sniffer appSniffer = ref.getContainerInfo().getSniffer();
                    this.addToResultDDList("", appSniffer.getDeploymentConfigurations(appInfo.getSource()), part);
                }
                for (ModuleInfo moduleInfo : appInfo.getModuleInfos()) {
                    for (Sniffer moduleSniffer : moduleInfo.getSniffers()) {
                        ReadableArchive moduleArchive = appInfo.getSource().getSubArchive(moduleInfo.getName());
                        this.addToResultDDList(moduleInfo.getName(), moduleSniffer.getDeploymentConfigurations(moduleArchive), part);
                    }
                }
            } else {
                for (Sniffer sniffer : appInfo.getSniffers()) {
                    this.addToResultDDList(this.appname, sniffer.getDeploymentConfigurations(appInfo.getSource()), part);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addToResultDDList(String moduleName, Map<String, String> snifferConfigs, ActionReport.MessagePart part) {
        for (String pathKey : snifferConfigs.keySet()) {
            ActionReport.MessagePart childPart = part.addChild();
            childPart.addProperty("module-name", moduleName);
            childPart.addProperty("dd-path", pathKey);
            childPart.addProperty("dd-content", snifferConfigs.get(pathKey));
        }
    }
}

