/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.logging.LogDomains;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artifacts {
    private static final Logger logger = LogDomains.getLogger(Artifacts.class, "javax.enterprise.system.tools.deployment");
    private final Set<FullAndPartURIs> artifacts = new HashSet<FullAndPartURIs>();
    private final String keyPrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Artifacts get(DeploymentContext dc, String keyPrefix) {
        String key = Artifacts.transientAppMetadataKey(keyPrefix);
        DeploymentContext deploymentContext = dc;
        synchronized (deploymentContext) {
            Artifacts result = dc.getTransientAppMetaData(Artifacts.transientAppMetadataKey(keyPrefix), Artifacts.class);
            if (result == null) {
                result = new Artifacts(keyPrefix);
                dc.addTransientAppMetaData(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(DeploymentContext dc) {
        DeploymentContext deploymentContext = dc;
        synchronized (deploymentContext) {
            dc.addTransientAppMetaData(this.transientAppMetadataKey(), this);
        }
    }

    public static Artifacts get(Properties props, String keyPrefix) {
        Artifacts result = new Artifacts(keyPrefix);
        for (String propName : props.stringPropertyNames()) {
            String propNamePrefix;
            if (!propName.startsWith(propNamePrefix = Artifacts.propNamePrefix(keyPrefix))) continue;
            URI fullURI = URI.create(props.getProperty(propName));
            result.addArtifact(fullURI, propName.substring(propNamePrefix.length()));
        }
        return result;
    }

    private Artifacts(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    private static String propNamePrefix(String keyPrefix) {
        return keyPrefix + "Artifact.";
    }

    private String propNamePrefix() {
        return Artifacts.propNamePrefix(this.keyPrefix);
    }

    public synchronized void addArtifact(URI full, URI part) {
        FullAndPartURIs fullAndPart = new FullAndPartURIs(full, part);
        this.artifacts.add(fullAndPart);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Added {1} artifact: {0}", new Object[]{fullAndPart, this.keyPrefix});
        }
    }

    public synchronized void addArtifact(URI full, String part) {
        this.addArtifact(full, URI.create(part));
    }

    public synchronized void addArtifacts(Collection<FullAndPartURIs> urisCollection) {
        this.artifacts.addAll(urisCollection);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Added downloadable artifacts: {0}", urisCollection);
        }
    }

    private static String transientAppMetadataKey(String prefix) {
        return prefix + "Artifacts";
    }

    private String transientAppMetadataKey() {
        return Artifacts.transientAppMetadataKey(this.keyPrefix);
    }

    private String propName(URI partURI) {
        return this.propNamePrefix() + partURI.toASCIIString();
    }

    private String propValue(URI fullURI) {
        return fullURI.toASCIIString();
    }

    public synchronized Set<FullAndPartURIs> getArtifacts() {
        return this.artifacts;
    }

    public synchronized void record(Properties props) throws URISyntaxException {
        for (FullAndPartURIs artifactInfo : this.artifacts) {
            props.setProperty(this.propName(artifactInfo.getPart()), this.propValue(artifactInfo.getFull()));
        }
    }

    public synchronized void clearArtifacts() {
        this.artifacts.clear();
    }

    public static class FullAndPartURIs {
        private URI full;
        private URI part;

        public FullAndPartURIs(URI full, URI part) {
            this.full = full;
            this.part = part;
        }

        public FullAndPartURIs(URI full, String part) {
            this.full = full;
            this.part = URI.create(part);
        }

        public URI getFull() {
            return this.full;
        }

        public URI getPart() {
            return this.part;
        }

        private void setFull(URI full) {
            this.full = full;
        }

        private void setPart(URI part) {
            this.part = part;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FullAndPartURIs other = (FullAndPartURIs)obj;
            if (!(this.full == other.full || this.full != null && this.full.equals(other.full))) {
                return false;
            }
            return this.part == other.part || this.part != null && this.part.equals(other.part);
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + (this.full != null ? this.full.hashCode() : 0);
            hash = 29 * hash + (this.part != null ? this.part.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "full URI=" + this.full + "; part URI=" + this.part;
        }
    }
}

