/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable.archive;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.embeddable.archive.Assembler;

public class ScatteredArchive {
    String name;
    Type type;
    File rootDirectory;
    List<File> classpaths = new ArrayList<File>();
    Map<String, File> metadatas = new HashMap<String, File>();
    String metadataEntryPrefix;

    public ScatteredArchive(String name, Type type2) {
        if (name == null) {
            throw new NullPointerException("name must not be null.");
        }
        if (type2 == null) {
            throw new NullPointerException("type must not be null.");
        }
        this.name = name;
        this.type = type2;
        this.metadataEntryPrefix = type2 == Type.WAR ? "WEB-INF/" : "META-INF/";
    }

    public ScatteredArchive(String name, Type type2, File rootDirectory) throws IOException {
        this(name, type2);
        if (rootDirectory == null) {
            throw new NullPointerException("rootDirectory must not be null.");
        }
        if (!rootDirectory.exists()) {
            throw new IOException(rootDirectory + " does not exist.");
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException(rootDirectory + " is not a directory.");
        }
        this.rootDirectory = rootDirectory;
    }

    public void addClassPath(File classpath) throws IOException {
        if (classpath == null) {
            throw new NullPointerException("classpath must not be null.");
        }
        if (!classpath.exists()) {
            throw new IOException(classpath + " does not exist.");
        }
        this.classpaths.add(classpath);
    }

    public void addMetadata(File metadata) throws IOException {
        this.addMetadata(metadata, null);
    }

    public void addMetadata(File metadata, String name) throws IOException {
        if (metadata == null) {
            throw new NullPointerException("metadata must not be null.");
        }
        if (!metadata.exists()) {
            throw new IOException(metadata + " does not exist.");
        }
        if (metadata.isDirectory()) {
            throw new IllegalArgumentException(metadata + " is a directory.");
        }
        if (name == null) {
            name = this.metadataEntryPrefix + metadata.getName();
        }
        this.metadatas.put(name, metadata);
    }

    public URI toURI() throws IOException {
        return new Assembler().assemble(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JAR,
        WAR,
        RAR;

    }
}

