/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.helper.LbConfigHelper;
import org.glassfish.loadbalancer.admin.cli.reader.api.LoadbalancerReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.LoadbalancerReaderImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="export-http-lb-config")
@Scoped(value=PerLookup.class)
@I18n(value="export.http.lb.config")
public class ExportHttpLbConfig
implements AdminCommand {
    @Param(name="lbtargets", separator=44, optional=true)
    List<String> target;
    @Param(name="config", optional=true)
    String lbConfigName;
    @Param(name="lbname", optional=true)
    String lbName;
    @Param(name="retrievefile", optional=true, defaultValue="false")
    boolean retrieveFile;
    @Param(name="file_name", optional=true, primary=true)
    String fileName;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Inject
    Domain domain;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    ServerEnvironment env;
    private static final String DEFAULT_LB_XML_FILE_NAME = "loadbalancer.xml";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            String msg = this.process(context);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(msg);
        }
        catch (Throwable t) {
            String msg = LbLogUtil.getStringManager().getString("ExportHttpLbConfigFailed", t.getMessage());
            LbLogUtil.getLogger().log(Level.WARNING, msg);
            if (LbLogUtil.getLogger().isLoggable(Level.FINE)) {
                LbLogUtil.getLogger().log(Level.FINE, "Exception when exporting http lb config", t);
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(t.getMessage());
            report.setFailureCause(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(AdminCommandContext context) throws Exception {
        String string;
        block16: {
            File lbXmlFile;
            LoadbalancerReader lbr = null;
            if (this.lbName != null && this.lbConfigName == null && this.target == null) {
                LoadBalancer lb = LbConfigHelper.getLoadBalancer(this.domain, this.lbName);
                lbr = LbConfigHelper.getLbReader(this.domain, this.appRegistry, lb.getLbConfigName());
            } else if (this.lbConfigName != null && this.lbName == null && this.target == null) {
                lbr = LbConfigHelper.getLbReader(this.domain, this.appRegistry, this.lbConfigName);
            } else if (this.target != null && this.lbName == null && this.lbConfigName == null) {
                HashSet<String> clusters = new HashSet<String>();
                clusters.addAll(this.target);
                lbr = new LoadbalancerReaderImpl(this.domain, this.appRegistry, clusters, this.properties);
            } else {
                String msg = LbLogUtil.getStringManager().getString("ExportHttpLbConfigInvalidArgs");
                throw new Exception(msg);
            }
            if (this.fileName == null) {
                String configName = lbr.getName();
                this.fileName = configName != null ? "loadbalancer.xml." + configName : DEFAULT_LB_XML_FILE_NAME;
            }
            if (!(lbXmlFile = new File(this.fileName)).isAbsolute() && !this.retrieveFile) {
                File loadbalancerDir = new File(this.env.getInstanceRoot(), "load-balancer");
                if (!loadbalancerDir.exists()) {
                    loadbalancerDir.mkdir();
                }
                lbXmlFile = new File(loadbalancerDir, this.fileName);
            }
            File tmpLbXmlFile = null;
            if (this.retrieveFile) {
                tmpLbXmlFile = File.createTempFile("load-balancer", ".xml");
                tmpLbXmlFile.deleteOnExit();
            } else {
                if (lbXmlFile.exists()) {
                    String msg = LbLogUtil.getStringManager().getString("FileExists", lbXmlFile.getPath());
                    throw new Exception(msg);
                }
                if (!lbXmlFile.getParentFile().exists()) {
                    String msg = LbLogUtil.getStringManager().getString("ParentFileMissing", lbXmlFile.getParent());
                    throw new Exception(msg);
                }
                tmpLbXmlFile = lbXmlFile;
            }
            FileOutputStream fo = null;
            try {
                String msg;
                fo = new FileOutputStream(tmpLbXmlFile);
                LbConfigHelper.exportXml(lbr, fo);
                if (this.retrieveFile) {
                    this.retrieveLbXml(context, lbXmlFile, tmpLbXmlFile);
                }
                string = msg = LbLogUtil.getStringManager().getString("GeneratedFileLocation", lbXmlFile.toString());
                Object var9_11 = null;
                if (fo == null) break block16;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var9_12 = null;
                    if (fo == null) break block17;
                    fo.close();
                    fo = null;
                }
                throw throwable;
            }
            fo.close();
            fo = null;
        }
        return string;
    }

    private void retrieveLbXml(AdminCommandContext context, File lbXmlFile, File tmpLbXmlFile) throws Exception {
        File localFile = lbXmlFile;
        Properties props = new Properties();
        File parent = localFile.getParentFile();
        if (parent == null) {
            parent = localFile;
        }
        props.setProperty("file-xfer-root", parent.getPath().replace('\\', '/'));
        URI parentURI = parent.toURI();
        try {
            context.getOutboundPayload().attachFile("text/xml", parentURI.relativize(localFile.toURI()), "sync-load-balancer-xml", props, tmpLbXmlFile);
        }
        catch (IOException ex) {
            String msg = LbLogUtil.getStringManager().getString("RetrieveFailed", lbXmlFile.getAbsolutePath());
            throw new Exception(msg, ex);
        }
    }
}

