/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.connection;

import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.internal.api.Globals;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.connection.SSLHostNameVerifier;
import org.jvnet.hk2.component.Habitat;

public class ConnectionManager {
    public static final String HTTPS_PROTOCOL = "https";
    public static final String HTTP_PROTOCOL = "http";
    public static final String SSL = "SSL";
    private String _lbHost = null;
    private String _lbPort = null;
    private String _lbProxyHost = null;
    private String _lbProxyPort = null;
    private String _lbName = null;
    private boolean _isSecure = true;

    public ConnectionManager(String lbHost, String lbPort, String lbProxyHost, String lbProxyPort, String lbName, boolean isSecure) {
        this._lbHost = lbHost;
        this._lbPort = lbPort;
        this._lbProxyHost = lbProxyHost;
        this._lbProxyPort = lbProxyPort;
        this._lbName = lbName;
        this._isSecure = isSecure;
    }

    public HttpURLConnection getConnection(String contextRoot) throws IOException {
        if (this._isSecure) {
            return this.getSecureConnection(contextRoot);
        }
        return this.getNonSecureConnection(contextRoot);
    }

    private HttpURLConnection getNonSecureConnection(String contextRoot) throws IOException {
        if (this._lbHost == null || this._lbPort == null) {
            String msg = LbLogUtil.getStringManager().getString("LbDeviceNotConfigured", this._lbName);
            throw new IOException(msg);
        }
        HttpURLConnection conn = null;
        URL url = null;
        try {
            url = new URL(HTTP_PROTOCOL, this._lbHost, Integer.parseInt(this._lbPort), contextRoot);
            if (this._lbProxyHost != null && this._lbProxyPort != null) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._lbProxyHost, Integer.parseInt(this._lbProxyPort)));
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        return conn;
    }

    private HttpsURLConnection getSecureConnection(String contextRoot) throws IOException {
        if (this._lbHost == null || this._lbPort == null) {
            String msg = LbLogUtil.getStringManager().getString("LbDeviceNotConfigured", this._lbName);
            throw new IOException(msg);
        }
        HttpsURLConnection conn = null;
        URL url = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance(SSL);
            Habitat habitat = Globals.getDefaultHabitat();
            SSLUtils sslUtils = habitat.getComponent(SSLUtils.class);
            sc.init(sslUtils.getKeyManagers(), trustAllCerts, new SecureRandom());
            url = new URL(HTTPS_PROTOCOL, this._lbHost, Integer.parseInt(this._lbPort), contextRoot);
            if (this._lbProxyHost != null && this._lbProxyPort != null) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._lbProxyHost, Integer.parseInt(this._lbProxyPort)));
                conn = (HttpsURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpsURLConnection)url.openConnection();
            }
            conn.setSSLSocketFactory(sc.getSocketFactory());
            SSLHostNameVerifier hnv = new SSLHostNameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(hnv);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        return conn;
    }
}

