/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.Ref;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.reader.api.ClusterReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.LbReaderException;
import org.glassfish.loadbalancer.admin.cli.reader.api.LoadbalancerReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.PropertyReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.ClusterReaderImpl;
import org.glassfish.loadbalancer.admin.cli.reader.impl.PropertyReaderImpl;
import org.glassfish.loadbalancer.admin.cli.reader.impl.StandAloneClusterReaderImpl;
import org.glassfish.loadbalancer.admin.cli.transform.LoadbalancerVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadbalancerReaderImpl
implements LoadbalancerReader {
    private LbConfig _lbConfig = null;
    private Domain _domain = null;
    private ApplicationRegistry _appRegistry = null;
    private Set<String> _clusters = null;
    private Properties _properties = null;

    public LoadbalancerReaderImpl(Domain domain, ApplicationRegistry appRegistry, Set<String> clusters, Properties properties) {
        this._domain = domain;
        this._appRegistry = appRegistry;
        this._clusters = clusters;
        this._properties = properties;
    }

    public LoadbalancerReaderImpl(Domain domain, ApplicationRegistry appRegistry, LbConfig lbConfig) {
        this._domain = domain;
        this._appRegistry = appRegistry;
        this._lbConfig = lbConfig;
    }

    @Override
    public PropertyReader[] getProperties() throws LbReaderException {
        if (this._lbConfig != null) {
            return PropertyReaderImpl.getPropertyReaders(this._lbConfig);
        }
        return PropertyReaderImpl.getPropertyReaders(this._properties);
    }

    @Override
    public ClusterReader[] getClusters() throws LbReaderException {
        if (this._lbConfig != null) {
            return this.getClustersDataFromLBConfig();
        }
        if (this._clusters != null) {
            return this.getClustersData();
        }
        String msg = LbLogUtil.getStringManager().getString("NoConfigOrCluster");
        throw new LbReaderException(msg);
    }

    public ClusterReader[] getClustersData() throws LbReaderException {
        ClusterReader[] cls = new ClusterReader[this._clusters.size()];
        Iterator<String> iter = this._clusters.iterator();
        int i = 0;
        boolean isFirstServer = false;
        while (iter.hasNext()) {
            String name = iter.next();
            boolean isServer = this._domain.isServer(name);
            if (i == 0) {
                isFirstServer = isServer;
            } else if (isFirstServer ^ isServer) {
                String msg = LbLogUtil.getStringManager().getString("MixofServerAndClusterNotSupported");
                throw new LbReaderException(msg);
            }
            if (isServer) {
                Server server = this._domain.getServerNamed(name);
                if (server.getCluster() != null) {
                    String msg = LbLogUtil.getStringManager().getString("ServerPartofClusterNotSupported", name);
                    throw new LbReaderException(msg);
                }
                cls[i++] = new StandAloneClusterReaderImpl(this._domain, this._appRegistry, server);
                continue;
            }
            Cluster cluster = this._domain.getClusterNamed(name);
            if (cluster == null) {
                String msg = LbLogUtil.getStringManager().getString("ClusterorInstanceNotFound", name);
                throw new LbReaderException(msg);
            }
            cls[i++] = new ClusterReaderImpl(this._domain, this._appRegistry, cluster);
        }
        return cls;
    }

    public ClusterReader[] getClustersDataFromLBConfig() throws LbReaderException {
        List<Ref> serverOrClusters = this._lbConfig.getClusterRefOrServerRef();
        ClusterReader[] cls = new ClusterReader[serverOrClusters.size()];
        Iterator<Ref> iter = serverOrClusters.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Ref ref = iter.next();
            if (ref instanceof ServerRef) {
                cls[i++] = new StandAloneClusterReaderImpl(this._domain, this._appRegistry, (ServerRef)ref);
                continue;
            }
            if (ref instanceof ClusterRef) {
                cls[i++] = new ClusterReaderImpl(this._domain, this._appRegistry, (ClusterRef)ref);
                continue;
            }
            String msg = LbLogUtil.getStringManager().getString("UnableToDetermineType", ref.getRef());
            throw new LbReaderException(msg);
        }
        return cls;
    }

    @Override
    public String getName() throws LbReaderException {
        if (this._lbConfig != null) {
            return this._lbConfig.getName();
        }
        return null;
    }

    @Override
    public void accept(Visitor v) throws Exception {
        LoadbalancerVisitor cv = (LoadbalancerVisitor)v;
        cv.visit(this);
    }
}

