/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgicdi.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import org.glassfish.osgicdi.OSGiService;
import org.glassfish.osgicdi.ServiceUnavailableException;
import org.glassfish.osgicdi.impl.OSGiServiceFactory;

public class OSGiServiceExtension
implements Extension {
    private HashMap<Type, Set<InjectionPoint>> servicesToBeInjected = new HashMap();
    private static final boolean DEBUG_ENABLED = false;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bdd) {
        this.debug("beforeBeanDiscovery" + bdd);
        bdd.addQualifier(OSGiService.class);
    }

    void afterProcessInjectionTarget(@Observes ProcessInjectionTarget<?> pb) {
        this.debug("AfterProcessInjectionTarget" + pb.getAnnotatedType().getBaseType());
        Set<InjectionPoint> ips = pb.getInjectionTarget().getInjectionPoints();
        this.discoverServiceInjectionPoints(ips);
    }

    void afterProcessBean(@Observes ProcessBean pb) {
        this.debug("afterProcessBean - " + pb.getAnnotated().getBaseType());
        Set<InjectionPoint> ips = pb.getBean().getInjectionPoints();
        this.discoverServiceInjectionPoints(ips);
    }

    private void discoverServiceInjectionPoints(Set<InjectionPoint> ips) {
        for (InjectionPoint injectionPoint : ips) {
            Set<Annotation> qualifs = injectionPoint.getQualifiers();
            for (Annotation annotation : qualifs) {
                if (!annotation.annotationType().equals(OSGiService.class)) continue;
                this.printDebugForInjectionPoint(injectionPoint);
                System.out.println("---- Injection requested for framework service type " + injectionPoint.getType() + " and annotated with dynamic=" + injectionPoint.getAnnotated().getAnnotation(OSGiService.class).dynamic() + ", serviceCriteria=" + injectionPoint.getAnnotated().getAnnotation(OSGiService.class).serviceCriteria());
                this.addServiceInjectionInfo(injectionPoint);
                this.debug("number of injection points for " + injectionPoint.getType() + "=" + this.servicesToBeInjected.size());
            }
        }
    }

    private void addServiceInjectionInfo(InjectionPoint injectionPoint) {
        Type key = injectionPoint.getType();
        if (!this.servicesToBeInjected.containsKey(key)) {
            this.servicesToBeInjected.put(key, new CopyOnWriteArraySet());
        }
        this.servicesToBeInjected.get(key).add(injectionPoint);
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        this.debug("After Bean Discovery");
        for (Type type2 : this.servicesToBeInjected.keySet()) {
            if (!(type2 instanceof Class)) {
                System.out.println("Unknown type:" + type2);
                abd.addDefinitionError(new UnsupportedOperationException("Injection target type " + type2 + "not supported"));
                break;
            }
            this.addBean(abd, type2, this.servicesToBeInjected.get(type2));
        }
    }

    private void addBean(AfterBeanDiscovery abd, Type type2, Set<InjectionPoint> injectionPoints) {
        ArrayList<OSGiService> registeredBeans = new ArrayList<OSGiService>();
        for (InjectionPoint svcInjectionPoint : injectionPoints) {
            if (!registeredBeans.contains(svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class))) {
                this.debug(" --- Adding an OSGi service BEAN " + type2 + " for " + svcInjectionPoint);
                abd.addBean(new OSGiServiceBean(svcInjectionPoint));
                registeredBeans.add(svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class));
                continue;
            }
            this.debug(" --- NOT Adding an OSGi service BEAN " + type2 + " for " + svcInjectionPoint + "as there has already been one registered for" + svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class));
        }
    }

    private void debug(String string) {
    }

    private void printDebugForInjectionPoint(InjectionPoint injectionPoint) {
    }

    private final class OSGiServiceQualifierType
    extends AnnotationLiteral<OSGiService>
    implements OSGiService {
        private String serviceCriteria = "";
        private boolean dynamic = false;
        private int waitTimeout = -1;

        public OSGiServiceQualifierType(OSGiService os) {
            this.serviceCriteria = os.serviceCriteria();
            this.dynamic = os.dynamic();
            this.waitTimeout = os.waitTimeout();
        }

        @Override
        public String serviceCriteria() {
            return this.serviceCriteria;
        }

        @Override
        public boolean dynamic() {
            return this.dynamic;
        }

        @Override
        public int waitTimeout() {
            return this.waitTimeout;
        }
    }

    private final class OSGiServiceBean
    implements Bean {
        private final Type type;
        private final InjectionPoint svcInjectionPoint;
        private final OSGiService os;

        private OSGiServiceBean(InjectionPoint injectionPoint) {
            this.svcInjectionPoint = injectionPoint;
            this.type = this.svcInjectionPoint.getType();
            this.os = this.svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        }

        @Override
        public Object create(CreationalContext ctx) {
            OSGiServiceExtension.this.debug("create::" + this.type);
            try {
                return OSGiServiceFactory.getService(this.svcInjectionPoint);
            }
            catch (ServiceUnavailableException e) {
                e.printStackTrace();
                throw new CreationException((Throwable)((Object)e));
            }
        }

        @Override
        public void destroy(Object instance, CreationalContext creationalContext) {
            OSGiServiceFactory.ungetService(instance, this.svcInjectionPoint);
        }

        public Class getBeanClass() {
            return (Class)this.type;
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        @Override
        public String getName() {
            return this.type + this.getServiceMetadata();
        }

        private String getServiceMetadata() {
            return "_dynamic_" + this.os.dynamic() + "_criteria_" + this.os.serviceCriteria() + "_waitTimeout" + this.os.waitTimeout();
        }

        @Override
        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> s = new HashSet<Annotation>();
            s.add(new AnnotationLiteral<Default>(){});
            s.add(new AnnotationLiteral<Any>(){});
            s.add(new OSGiServiceQualifierType(this.os));
            return s;
        }

        @Override
        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        @Override
        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        @Override
        public Set<Type> getTypes() {
            HashSet<Type> s = new HashSet<Type>();
            s.add(this.type);
            s.add((Type)((Object)Object.class));
            return s;
        }

        @Override
        public boolean isAlternative() {
            return false;
        }

        @Override
        public boolean isNullable() {
            return false;
        }
    }
}

