/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgicdi.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.InjectionPoint;
import org.glassfish.osgicdi.OSGiService;
import org.glassfish.osgicdi.ServiceUnavailableException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class OSGiServiceFactory {
    private static final boolean DEBUG_ENABLED = true;

    OSGiServiceFactory() {
    }

    public static Object getService(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        OSGiService os = svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        OSGiServiceFactory.debug("getService " + svcInjectionPoint.getType() + " OS:" + os);
        Object instance = OSGiServiceFactory.createServiceProxy(svcInjectionPoint);
        return instance;
    }

    private static Object createServiceProxy(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        Type serviceType = svcInjectionPoint.getType();
        OSGiService os = svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        InvocationHandler proxyInvHndlr = os.dynamic() ? new DynamicInvocationHandler(os, svcInjectionPoint) : new StaticInvocationHandler(os, svcInjectionPoint);
        Object instance = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{(Class)serviceType}, proxyInvHndlr);
        return instance;
    }

    private static Object lookupService(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        Type serviceType = svcInjectionPoint.getType();
        OSGiService os = svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        OSGiServiceFactory.debug("lookup service" + serviceType);
        Class<?> annotatedElt = svcInjectionPoint.getMember().getDeclaringClass();
        BundleContext bc = ((BundleReference)BundleReference.class.cast(annotatedElt.getClassLoader())).getBundle().getBundleContext();
        OSGiServiceFactory.debug("creating service tracker for " + ((Class)serviceType).getName() + " using bundle-context:" + bc);
        ServiceTracker st = null;
        try {
            st = new ServiceTracker(bc, ((Class)serviceType).getName(), null);
            st.open();
            Object service = os.waitTimeout() == -1 ? st.getService() : st.waitForService((long)os.waitTimeout());
            OSGiServiceFactory.debug("service obtained from tracker" + service);
            if (service == null) {
                throw new ServiceUnavailableException("Service " + ((Class)serviceType).getName() + " Unavailable", 4, null);
            }
            Object object = service;
            return object;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new ServiceUnavailableException("Service " + ((Class)serviceType).getName() + " Unavailable", 4, e);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public static void ungetService(Object serviceInstance, InjectionPoint svcInjectionPoint) {
    }

    private static void debug(String string) {
        System.out.println("OSGiServiceFactory:: " + string);
    }

    private static class StaticInvocationHandler
    implements InvocationHandler {
        private final OSGiService os;
        private final InjectionPoint svcInjectionPoint;
        private ServiceReference svcReference = null;
        private BundleContext bundleContext = null;

        public StaticInvocationHandler(OSGiService os, InjectionPoint svcInjectionPoint) {
            OSGiServiceFactory.debug("In StaticInvocationHandler");
            this.os = os;
            this.svcInjectionPoint = svcInjectionPoint;
            this.bundleContext = this.getBundleContext(svcInjectionPoint);
            this.getServiceReference(svcInjectionPoint);
        }

        private BundleContext getBundleContext(InjectionPoint svcInjectionPoint) {
            Class<?> annotatedElt = svcInjectionPoint.getMember().getDeclaringClass();
            BundleContext bc = ((BundleReference)BundleReference.class.cast(annotatedElt.getClassLoader())).getBundle().getBundleContext();
            return bc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getServiceReference(InjectionPoint svcInjectionPoint) {
            Type serviceType = svcInjectionPoint.getType();
            OSGiServiceFactory.debug("lookup service" + serviceType);
            OSGiServiceFactory.debug("creating service tracker for " + ((Class)serviceType).getName() + " using bundle-context:" + this.bundleContext);
            ServiceTracker st = null;
            try {
                st = new ServiceTracker(this.bundleContext, ((Class)serviceType).getName(), null);
                st.open();
                if (this.os.waitTimeout() != -1) {
                    st.waitForService((long)this.os.waitTimeout());
                }
                this.svcReference = st.getServiceReference();
                if (this.svcReference == null) {
                    OSGiServiceFactory.debug("ServiceReference obtained from ServiceTracker is null. No matching services available at this point");
                    this.throwServiceUnavailable();
                }
                OSGiServiceFactory.debug("ServiceReference obtained from tracker:" + this.svcReference);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.throwServiceUnavailable();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.svcReference != null) {
                Object instanceToUse = this.bundleContext.getService(this.svcReference);
                if (instanceToUse == null) {
                    this.svcReference = null;
                    this.throwServiceUnavailable();
                }
                OSGiServiceFactory.debug("Using the service that was looked up earlier as this is set to DYNAMIC=false");
                OSGiServiceFactory.debug("Calling Method " + method + " on Proxy");
                return method.invoke(instanceToUse, args);
            }
            this.throwServiceUnavailable();
            return null;
        }

        private void throwServiceUnavailable() {
            Type serviceType = this.svcInjectionPoint.getType();
            throw new ServiceUnavailableException("Service " + ((Class)serviceType).getName() + " Unavailable", 4, null);
        }
    }

    private static class DynamicInvocationHandler
    implements InvocationHandler {
        private final OSGiService os;
        private final InjectionPoint svcInjectionPoint;

        public DynamicInvocationHandler(OSGiService os, InjectionPoint svcInjectionPoint) {
            OSGiServiceFactory.debug("In DynamicInvocationHandler");
            this.os = os;
            this.svcInjectionPoint = svcInjectionPoint;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            OSGiServiceFactory.debug("looking a service as this is set to DYNAMIC=true");
            Object instanceToUse = OSGiServiceFactory.lookupService(this.svcInjectionPoint);
            OSGiServiceFactory.debug("calling Method " + method + " on proxy");
            return method.invoke(instanceToUse, args);
        }
    }
}

