/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jsp-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container JSP Statistics")
public class JspStatsProvider {
    private static final Logger logger = LogDomains.getLogger(JspStatsProvider.class, "javax.enterprise.system.container.web");
    private static final String JSP_COUNT_DESCRIPTION = "Number of active JSP pages";
    private static final String TOTAL_JSP_COUNT_DESCRIPTION = "Total number of JSP pages ever loaded";
    private static final String JSP_RELOADED_COUNT_DESCRIPTION = "Total number of JSP pages that were reloaded";
    private static final String JSP_ERROR_COUNT_DESCRIPTION = "Total number of errors triggered by JSP page invocations";
    private String moduleName;
    private String vsName;
    private RangeStatisticImpl jspCount;
    private CountStatisticImpl totalJspCount;
    private CountStatisticImpl jspReloadedCount;
    private CountStatisticImpl jspErrorCount;

    public JspStatsProvider(String moduleName, String vsName) {
        this.moduleName = moduleName;
        this.vsName = vsName;
        long curTime = System.currentTimeMillis();
        this.jspCount = new RangeStatisticImpl(0L, 0L, 0L, "JspCount", "count", JSP_COUNT_DESCRIPTION, curTime, curTime);
        this.totalJspCount = new CountStatisticImpl("TotalJspCount", "count", TOTAL_JSP_COUNT_DESCRIPTION);
        this.jspReloadedCount = new CountStatisticImpl("JspReloadedCount", "count", JSP_RELOADED_COUNT_DESCRIPTION);
        this.jspErrorCount = new CountStatisticImpl("JspErrorCount", "count", JSP_ERROR_COUNT_DESCRIPTION);
    }

    @ManagedAttribute(id="jspcount")
    @Description(value="Number of active JSP pages")
    public RangeStatistic getJspCount() {
        return this.jspCount;
    }

    @ManagedAttribute(id="totaljspcount")
    @Description(value="Total number of JSP pages ever loaded")
    public CountStatistic getTotalJspCount() {
        return this.totalJspCount;
    }

    @ManagedAttribute(id="jspreloadedcount")
    @Description(value="Total number of JSP pages that were reloaded")
    public CountStatistic getJspReloadedCount() {
        return this.jspReloadedCount;
    }

    @ManagedAttribute(id="jsperrorcount")
    @Description(value="Total number of errors triggered by JSP page invocations")
    public CountStatistic getJspErrorCount() {
        return this.jspErrorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:web:jsp:jspLoadedEvent")
    public void jspLoadedEvent(@ProbeParam(value="jspUri") String jspUri, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(appName, hostName)) {
            RangeStatisticImpl rangeStatisticImpl = this.jspCount;
            synchronized (rangeStatisticImpl) {
                this.jspCount.setCurrent(this.jspCount.getCurrent() + 1L);
            }
            this.totalJspCount.increment();
        }
    }

    @ProbeListener(value="glassfish:web:jsp:jspReloadedEvent")
    public void jspReloadedEvent(@ProbeParam(value="jspUri") String jspUri, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(appName, hostName)) {
            this.jspReloadedCount.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:web:jsp:jspDestroyedEvent")
    public void jspDestroyedEvent(@ProbeParam(value="jspUri") String jspUri, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(appName, hostName)) {
            RangeStatisticImpl rangeStatisticImpl = this.jspCount;
            synchronized (rangeStatisticImpl) {
                this.jspCount.setCurrent(this.jspCount.getCurrent() - 1L);
            }
        }
    }

    @ProbeListener(value="glassfish:web:jsp:jspErrorEvent")
    public void jspErrorEvent(@ProbeParam(value="jspUri") String jspUri, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(appName, hostName)) {
            this.jspErrorCount.increment();
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    private void resetStats() {
        this.jspCount.setCurrent(0L);
        this.jspCount.setLowWaterMark(0L);
        this.jspCount.setHighWaterMark(0L);
        this.totalJspCount.setCount(0L);
        this.jspReloadedCount.setCount(0L);
        this.jspErrorCount.setCount(0L);
    }
}

