/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.ValidationException;
import org.hibernate.validator.engine.groups.Group;
import org.hibernate.validator.engine.groups.GroupChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupChainGenerator {
    private final Map<Class<?>, List<Group>> resolvedSequences = new HashMap();

    public GroupChain getGroupChainFor(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("At least one groups has to be specified.");
        }
        for (Class<?> clazz : groups) {
            if (clazz.isInterface()) continue;
            throw new ValidationException("A group has to be an interface. " + clazz.getName() + " is not.");
        }
        GroupChain chain = new GroupChain();
        for (Class<?> clazz : groups) {
            if (this.isGroupSequence(clazz)) {
                this.insertSequence(clazz, chain);
                continue;
            }
            Group group2 = new Group(clazz);
            chain.insertGroup(group2);
            this.insertInheritedGroups(clazz, chain);
        }
        return chain;
    }

    private boolean isGroupSequence(Class<?> clazz) {
        return clazz.getAnnotation(GroupSequence.class) != null;
    }

    private void insertInheritedGroups(Class<?> clazz, GroupChain chain) {
        for (Class<?> inheritedGroup : clazz.getInterfaces()) {
            Group group2 = new Group(inheritedGroup);
            chain.insertGroup(group2);
            this.insertInheritedGroups(inheritedGroup, chain);
        }
    }

    private void insertSequence(Class<?> clazz, GroupChain chain) {
        List<Group> sequence;
        if (this.resolvedSequences.containsKey(clazz)) {
            sequence = this.resolvedSequences.get(clazz);
        } else {
            sequence = this.resolveSequence(clazz, new ArrayList());
            sequence = this.expandInhertitedGroups(sequence);
        }
        chain.insertSequence(sequence);
    }

    private List<Group> expandInhertitedGroups(List<Group> sequence) {
        ArrayList<Group> expandedGroup = new ArrayList<Group>();
        for (Group group2 : sequence) {
            expandedGroup.add(group2);
            this.addInheritedGroups(group2, expandedGroup);
        }
        return expandedGroup;
    }

    private void addInheritedGroups(Group group2, List<Group> expandedGroups) {
        for (Class<?> inheritedGroup : group2.getGroup().getInterfaces()) {
            if (this.isGroupSequence(inheritedGroup)) {
                throw new GroupDefinitionException("Sequence definitions are not allowed as composing parts of a sequence.");
            }
            Group g = new Group(inheritedGroup, group2.getSequence());
            expandedGroups.add(g);
            this.addInheritedGroups(g, expandedGroups);
        }
    }

    private List<Group> resolveSequence(Class<?> group2, List<Class<?>> processedSequences) {
        Class<?>[] sequenceArray;
        if (processedSequences.contains(group2)) {
            throw new GroupDefinitionException("Cyclic dependency in groups definition");
        }
        processedSequences.add(group2);
        ArrayList<Group> resolvedGroupSequence = new ArrayList<Group>();
        GroupSequence sequenceAnnotation = group2.getAnnotation(GroupSequence.class);
        for (Class<?> clazz : sequenceArray = sequenceAnnotation.value()) {
            if (this.isGroupSequence(clazz)) {
                List<Group> tmpSequence = this.resolveSequence(clazz, processedSequences);
                this.addGroups(resolvedGroupSequence, tmpSequence);
                continue;
            }
            ArrayList<Group> list = new ArrayList<Group>();
            list.add(new Group(clazz, group2));
            this.addGroups(resolvedGroupSequence, list);
        }
        this.resolvedSequences.put(group2, resolvedGroupSequence);
        return resolvedGroupSequence;
    }

    private void addGroups(List<Group> resolvedGroupSequence, List<Group> groups) {
        for (Group tmpGroup : groups) {
            if (resolvedGroupSequence.contains(tmpGroup) && resolvedGroupSequence.indexOf(tmpGroup) < resolvedGroupSequence.size() - 1) {
                throw new GroupDefinitionException("Unable to expand group sequence.");
            }
            resolvedGroupSequence.add(tmpGroup);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GroupChainGenerator");
        sb.append("{resolvedSequences=").append(this.resolvedSequences);
        sb.append('}');
        return sb.toString();
    }
}

