/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jboss.weld.Container;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.NonexistentConversationException;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.logging.messages.JsfMessage;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.JSF);

    @Override
    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.activateConversations(phaseEvent.getFacesContext());
        }
    }

    @Override
    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.deactivateConversations(phaseEvent.getFacesContext(), PhaseId.RENDER_RESPONSE);
        } else if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.deactivateConversations(phaseEvent.getFacesContext(), phaseEvent.getPhaseId());
        }
    }

    private void activateConversations(FacesContext facesContext) {
        ConversationContext conversationContext = (ConversationContext)WeldPhaseListener.instance().select(HttpConversationContext.class, new Annotation[0]).get();
        String cid = WeldPhaseListener.getConversationId(facesContext, conversationContext);
        log.debug(JsfMessage.RESUMING_CONVERSATION, cid);
        if (cid != null && conversationContext.getConversation(cid) == null) {
            throw new NonexistentConversationException(ConversationMessage.NO_CONVERSATION_FOUND_TO_RESTORE, cid);
        }
        conversationContext.activate(cid);
    }

    private void deactivateConversations(FacesContext facesContext, PhaseId phaseId) {
        ConversationContext conversationContext = (ConversationContext)WeldPhaseListener.instance().select(HttpConversationContext.class, new Annotation[0]).get();
        if (log.isTraceEnabled()) {
            if (conversationContext.getCurrentConversation().isTransient()) {
                log.trace(ConversationMessage.CLEANING_UP_TRANSIENT_CONVERSATION, phaseId);
            } else {
                log.trace(JsfMessage.CLEANING_UP_CONVERSATION, conversationContext.getCurrentConversation().getId(), phaseId);
            }
        }
        conversationContext.invalidate();
        conversationContext.deactivate();
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private static Instance<Context> instance() {
        return Container.instance().deploymentManager().instance().select(Context.class, new Annotation[0]);
    }

    public static String getConversationId(FacesContext facesContext, ConversationContext conversationContext) {
        String cidName = conversationContext.getParameterName();
        String cid = facesContext.getExternalContext().getRequestParameterMap().get(cidName);
        log.trace(JsfMessage.FOUND_CONVERSATION_FROM_REQUEST, cid);
        return cid;
    }
}

