/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.util.reflection.instantiation.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionFactoryInstantiator
implements Instantiator {
    private static final String REFLECTION_CLASS_NAME = "sun.reflect.ReflectionFactory";
    private Method generator = null;
    private Object reflectionFactoryInstance = null;

    public ReflectionFactoryInstantiator() {
        try {
            Class<?> reflectionFactory = Class.forName(REFLECTION_CLASS_NAME);
            Method accessor = reflectionFactory.getMethod("getReflectionFactory", new Class[0]);
            this.reflectionFactoryInstance = accessor.invoke(null, new Object[0]);
            this.generator = reflectionFactory.getMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public <T> T instantiate(Class<T> clazz) {
        T instance = null;
        try {
            Constructor instanceConstructor = (Constructor)this.generator.invoke(this.reflectionFactoryInstance, clazz, Object.class.getDeclaredConstructor(new Class[0]));
            instance = instanceConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new WeldException(ReflectionMessage.REFLECTIONFACTORY_INSTANTIATION_FAILED, (Throwable)e, clazz);
        }
        return instance;
    }

    @Override
    public boolean isAvailable() {
        return this.generator != null && this.reflectionFactoryInstance != null;
    }
}

