/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.ClassLoaderHolder;
import com.sun.hk2.component.EventPublishingInhabitant;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.Inhabitants;
import java.util.logging.Level;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Creators;
import org.jvnet.hk2.component.DescriptorImpl;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;

public class LazyInhabitant<T>
extends EventPublishingInhabitant<T>
implements ClassLoaderHolder {
    private final Holder<ClassLoader> classLoader;
    protected final Habitat habitat;
    private final Inhabitant<?> lead;

    public LazyInhabitant(Habitat habitat, Holder<ClassLoader> cl, String typeName, MultiMap<String, String> metadata) {
        this(habitat, cl, typeName, metadata, null);
    }

    public LazyInhabitant(Habitat habitat, Holder<ClassLoader> cl, String typeName, MultiMap<String, String> metadata, Inhabitant<?> lead) {
        super(new DescriptorImpl(null, typeName, metadata, null));
        assert (metadata != null);
        this.habitat = habitat;
        this.classLoader = cl;
        this.lead = lead;
    }

    @Override
    public Inhabitant<?> lead() {
        return this.lead;
    }

    @Override
    public String typeName() {
        return this.getDescriptor().getTypeName();
    }

    @Override
    public Class<? extends T> type() {
        Inhabitant real = this.real;
        if (null != real) {
            return real.type();
        }
        return this.loadClass();
    }

    @Override
    public MultiMap<String, String> metadata() {
        return (MultiMap)this.getDescriptor().getMetadata();
    }

    @Override
    protected synchronized void fetch() {
        if (null == this.real) {
            Class<T> c = this.loadClass();
            this.real = Inhabitants.wrapByScope(c, this.createCreator(c), this.habitat);
        }
    }

    @Override
    public final ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    protected Class<T> loadClass() {
        String typeName = this.typeName();
        logger.log(Level.FINER, "loading class for: {0}", typeName);
        ClassLoader cl = this.getClassLoader();
        try {
            Class<?> c = cl.loadClass(typeName);
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new ComponentException("Failed to load " + typeName + " from " + cl, e);
        }
    }

    @Override
    public synchronized void release() {
        super.release();
        this.real = null;
    }

    protected Creator<T> createCreator(Class<T> c) {
        MultiMap<String, String> metadata = this.metadata();
        return Creators.create(c, this.habitat, metadata);
    }
}

