/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.ScopedInhabitant;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.ContractLocator;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Scope;
import org.glassfish.hk2.TypeLiteral;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.SimpleServiceLocator;
import org.jvnet.tiger_types.Types;

public class ContractLocatorImpl<T>
implements ContractLocator<T> {
    private static final Logger logger = Logger.getLogger(ContractLocatorImpl.class.getName());
    private final SimpleServiceLocator habitat;
    private String name;
    private Type type = null;
    private String typeName = null;
    private Collection<Class<? extends Annotation>> qualifiers = new ArrayList<Class<? extends Annotation>>();
    private Scope scope;
    private final boolean byContract;

    public ContractLocatorImpl(SimpleServiceLocator habitat, Type clazz, boolean byContract) {
        this.habitat = habitat;
        this.byContract = byContract;
        this.type = clazz;
    }

    ContractLocatorImpl(SimpleServiceLocator habitat, String clazzName, boolean byContract) {
        this.habitat = habitat;
        this.byContract = byContract;
        this.typeName = clazzName;
    }

    private void warnOnUsage() {
        logger.log(Level.WARNING, "name and scope are currently only appropriate for byContract usage; (name: {0}; type: {1})", new Object[]{this.name, this.getTypeName()});
    }

    public String getTypeName() {
        if (null == this.type) {
            return this.typeName;
        }
        return TypeLiteral.getRawType((Type)this.type).getName();
    }

    public ContractLocator<T> named(String name) {
        this.name = name;
        if (null != name && !name.isEmpty() && !this.byContract) {
            this.warnOnUsage();
        }
        return this;
    }

    public ContractLocator<T> in(Scope scope) {
        this.scope = scope;
        return this;
    }

    public ContractLocator<T> annotatedWith(Class<? extends Annotation> annotation) {
        this.qualifiers.add(annotation);
        return this;
    }

    public T get() {
        Provider<T> provider = this.getProvider();
        return (T)(provider == null ? null : provider.get());
    }

    public <U> U getByType(Class<U> type) {
        Provider<T> provider = this.getProvider();
        return (U)(provider == null ? null : (type == null ? provider.get() : provider.getByType(Types.erasure(type))));
    }

    public Provider<T> getProvider() {
        Collection<Provider<T>> providers = this.all(true);
        return providers.isEmpty() ? null : providers.iterator().next();
    }

    public Collection<Provider<T>> all() {
        return this.all(false);
    }

    public Collection<Provider<T>> all(boolean stopAtFirstMatch) {
        HashSet<Provider<T>> providers = new HashSet<Provider<T>>();
        if (this.qualifiers.isEmpty()) {
            return this.getNonQualifiedInhabitants(stopAtFirstMatch);
        }
        ArrayList<String> tmpQualifiers = new ArrayList<String>();
        for (Class<? extends Annotation> clazz : this.qualifiers) {
            tmpQualifiers.add(clazz.getName());
        }
        for (Inhabitant inhabitant : this.inhabitants()) {
            List<String> declaredQualifiers = inhabitant.metadata().get("qualifier");
            for (String declaredQualifier : declaredQualifiers) {
                tmpQualifiers.remove(declaredQualifier);
            }
            if (!tmpQualifiers.isEmpty()) continue;
            if (this.scope == null) {
                providers.add((Provider<T>)inhabitant);
            } else if (inhabitant instanceof ScopedInhabitant && ((ScopedInhabitant)inhabitant).getScope().equals(this.scope)) {
                providers.add((Provider<T>)inhabitant);
            }
            if (providers.isEmpty() || !stopAtFirstMatch) continue;
            return providers;
        }
        return providers;
    }

    private Inhabitant<T> getNonQualifiedInhabitant() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.provider();
        }
        Inhabitant<T> inh = this.provider();
        if (inh == null) {
            return null;
        }
        if (inh.metadata().get("qualifier").isEmpty()) {
            return inh;
        }
        for (Inhabitant<T> inhabitant : this.inhabitants()) {
            if (!inhabitant.metadata().get("qualifier").isEmpty()) continue;
            return inhabitant;
        }
        return null;
    }

    private Collection<Provider<T>> getNonQualifiedInhabitants(boolean stopOnFirst) {
        Inhabitant<T> inh;
        Inhabitant<T> provider;
        HashSet<Provider<T>> inhabitants = new HashSet<Provider<T>>();
        if (this.name != null && !this.name.isEmpty() && (provider = this.provider()) != null) {
            inhabitants.add((Provider<T>)provider);
            if (stopOnFirst) {
                return inhabitants;
            }
        }
        if ((inh = this.provider()) == null) {
            return inhabitants;
        }
        if (inh.metadata().get("qualifier").isEmpty()) {
            inhabitants.add((Provider<T>)inh);
            if (stopOnFirst) {
                return inhabitants;
            }
        }
        for (Inhabitant<T> inhabitant : this.inhabitants()) {
            if (!inhabitant.metadata().get("qualifier").isEmpty() || !inhabitant.getDescriptor().getNames().isEmpty()) continue;
            inhabitants.add((Provider<T>)inhabitant);
            if (!stopOnFirst) continue;
            return inhabitants;
        }
        return inhabitants;
    }

    private Inhabitant<T> provider() {
        if (this.type != null) {
            return this.habitat.getProvider(this.type, this.name);
        }
        return this.habitat.getProvider(this.typeName, this.name);
    }

    private Collection<Inhabitant<T>> inhabitants() {
        if (this.type != null) {
            if (this.byContract) {
                return this.habitat.getInhabitantsByContract(this.type);
            }
            Class classType = Types.erasure(this.type);
            return this.habitat.getInhabitantsByType(classType);
        }
        if (this.byContract) {
            return this.habitat.getInhabitantsByContract(this.typeName);
        }
        return this.habitat.getInhabitantsByType(this.typeName);
    }
}

