/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Contract;

public class ReflectionHelper {
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'{', '}', '[', ']', ':', ';', '='};

    public static Class<?> getRawClass(Type type) {
        Type rawType;
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private static String getNamedName(Named named, Class<?> implClass) {
        String name = named.value();
        if (name != null && !name.equals("")) {
            return name;
        }
        String cn = implClass.getName();
        int index = cn.lastIndexOf(".");
        if (index < 0) {
            return cn;
        }
        return cn.substring(index + 1);
    }

    public static String getName(Class<?> implClass) {
        String namedName;
        Named named = implClass.getAnnotation(Named.class);
        String string = namedName = named != null ? ReflectionHelper.getNamedName(named, implClass) : null;
        if (namedName != null) {
            return namedName;
        }
        return null;
    }

    public static Set<Type> getAdvertisedTypesFromObject(Object t) {
        Type[] genericInterfaces;
        LinkedHashSet<Type> retVal = new LinkedHashSet<Type>();
        if (t == null) {
            return retVal;
        }
        retVal.add(t.getClass());
        for (Type genericInterface : genericInterfaces = t.getClass().getGenericInterfaces()) {
            Class<?> rawClass = ReflectionHelper.getRawClass(genericInterface);
            if (rawClass == null || !rawClass.isAnnotationPresent(Contract.class)) continue;
            retVal.add(genericInterface);
        }
        return retVal;
    }

    public static Set<String> getContractsFromClass(Class<?> clazz) {
        Class<?>[] interfaces;
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        if (clazz == null) {
            return retVal;
        }
        retVal.add(clazz.getName());
        for (Class<?> iFace : interfaces = clazz.getInterfaces()) {
            if (!iFace.isAnnotationPresent(Contract.class)) continue;
            retVal.add(iFace.getName());
        }
        return retVal;
    }

    public static Class<? extends Annotation> getScopeFromObject(Object t) {
        if (t == null) {
            return PerLookup.class;
        }
        return ReflectionHelper.getScopeFromClass(t.getClass());
    }

    public static Class<? extends Annotation> getScopeFromClass(Class<?> clazz) {
        if (clazz == null) {
            return PerLookup.class;
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (!annoClass.isAnnotationPresent(Scope.class)) continue;
            return annoClass;
        }
        return PerLookup.class;
    }

    public static Set<Annotation> getQualifiersFromObject(Object t) {
        LinkedHashSet<Annotation> retVal = new LinkedHashSet<Annotation>();
        if (t == null) {
            return retVal;
        }
        Class<?> oClass = t.getClass();
        for (Annotation annotation : oClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (!annoClass.isAnnotationPresent(Qualifier.class)) continue;
            retVal.add(annotation);
        }
        return retVal;
    }

    public static Set<String> getQualifiersFromClass(Class<?> clazz) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        if (clazz == null) {
            return retVal;
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (!annoClass.isAnnotationPresent(Qualifier.class)) continue;
            retVal.add(annotation.annotationType().getName());
        }
        return retVal;
    }

    public static String writeSet(Set<?> set) {
        if (set == null) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer("{");
        boolean first = true;
        for (Object writeMe : set) {
            if (first) {
                first = false;
                sb.append(writeMe.toString());
                continue;
            }
            sb.append("," + writeMe.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static void readSet(String line, Collection<String> addToMe) throws IOException {
        int startIndex = line.indexOf(123);
        if (startIndex < 0) {
            throw new IOException("Unknown set format, no initial { character : " + line);
        }
        int finishIndex = line.indexOf(125, startIndex);
        if (finishIndex < 0) {
            throw new IOException("Unknown set format, no trailing } character : " + line);
        }
        String csl = line.substring(startIndex + 1, finishIndex);
        StringTokenizer st = new StringTokenizer(csl, ",");
        while (st.hasMoreTokens()) {
            addToMe.add(st.nextToken());
        }
    }

    private static void readKeyStringListLine(String line, Map<String, List<String>> addToMe) throws IOException {
        int equalsIndex = line.indexOf(61);
        if (equalsIndex < 0) {
            throw new IOException("Uknown key-string list format, no equals: " + line);
        }
        String key = line.substring(0, equalsIndex);
        String listValue = line.substring(equalsIndex + 1);
        if (listValue.length() <= 0) {
            return;
        }
        LinkedList<String> listValues = new LinkedList<String>();
        ReflectionHelper.readSet(listValue, listValues);
        if (!listValues.isEmpty()) {
            addToMe.put(key, listValues);
        }
    }

    public static void readMetadataMap(String line, Map<String, List<String>> addToMe) throws IOException {
        int startIndex = line.indexOf(91);
        if (startIndex < 0) {
            throw new IOException("Unknown metadata format, no initial [ character : " + line);
        }
        int endIndex = line.indexOf(93, startIndex);
        if (endIndex < 0) {
            throw new IOException("Unknown set format, no trailing ] character : " + line);
        }
        String csl = line.substring(startIndex + 1, endIndex);
        StringTokenizer tokenizer = new StringTokenizer(csl, ":");
        while (tokenizer.hasMoreTokens()) {
            ReflectionHelper.readKeyStringListLine(tokenizer.nextToken(), addToMe);
        }
    }

    private static String writeList(List<String> list) {
        StringBuffer sb = new StringBuffer("{");
        boolean first = true;
        for (String writeMe : list) {
            if (first) {
                first = false;
                sb.append(writeMe.toString());
                continue;
            }
            sb.append("," + writeMe.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static String writeMetadata(Map<String, List<String>> metadata) {
        StringBuffer sb = new StringBuffer("[");
        boolean first = true;
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            if (first) {
                first = false;
                sb.append(entry.getKey() + "=");
            } else {
                sb.append(":" + entry.getKey() + "=");
            }
            sb.append(ReflectionHelper.writeList(entry.getValue()));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String prettyPrintDescriptor(Descriptor d) {
        StringBuffer sb = new StringBuffer("Descriptor(");
        sb.append("\n\timplementation=" + d.getImplementation());
        if (d.getName() != null) {
            sb.append("\n\tname=" + d.getName());
        }
        sb.append("\n\tcontracts=");
        sb.append(ReflectionHelper.writeSet(d.getAdvertisedContracts()));
        sb.append("\n\tscope=" + d.getScope());
        sb.append("\n\tqualifiers=");
        sb.append(ReflectionHelper.writeSet(d.getQualifiers()));
        sb.append("\n\tdescriptorType=" + (Object)((Object)d.getDescriptorType()));
        sb.append("\n\tmetadata=");
        sb.append(ReflectionHelper.writeMetadata(d.getMetadata()));
        sb.append("\n\tloader=" + d.getLoader());
        sb.append("\n\tid=" + d.getServiceId());
        sb.append("\n\tlocatorId=" + d.getServiceId());
        sb.append("\n\tidentityHashCode=" + System.identityHashCode(d));
        sb.append(")");
        return sb.toString();
    }

    public static void addMetadata(Map<String, List<String>> metadatas, String key, String value) {
        if (key == null || value == null) {
            return;
        }
        List<String> inner = metadatas.get(key);
        if (inner == null) {
            inner = new LinkedList<String>();
            metadatas.put(key, inner);
        }
        inner.add(value);
    }

    public static boolean removeMetadata(Map<String, List<String>> metadatas, String key, String value) {
        if (key == null || value == null) {
            return false;
        }
        List<String> inner = metadatas.get(key);
        if (inner == null) {
            return false;
        }
        boolean retVal = inner.remove(value);
        if (inner.size() <= 0) {
            metadatas.remove(key);
        }
        return retVal;
    }

    public static boolean removeAllMetadata(Map<String, List<String>> metadatas, String key) {
        List<String> values = metadatas.remove(key);
        return values != null && values.size() > 0;
    }

    public static Map<String, List<String>> deepCopyMetadata(Map<String, List<String>> copyMe) {
        if (copyMe == null) {
            return null;
        }
        LinkedHashMap<String, List<String>> retVal = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : copyMe.entrySet()) {
            String key = entry.getKey();
            ReflectionHelper.checkCharacters(key);
            List<String> values = entry.getValue();
            LinkedList<String> valuesCopy = new LinkedList<String>();
            for (String value : values) {
                ReflectionHelper.checkCharacters(value);
                valuesCopy.add(value);
            }
            retVal.put(key, valuesCopy);
        }
        return retVal;
    }

    public static void checkCharacters(String ... checkMes) {
        if (checkMes == null) {
            return;
        }
        for (String checkMe : checkMes) {
            if (checkMe == null) continue;
            for (char c : ILLEGAL_CHARACTERS) {
                if (checkMe.indexOf(c) < 0) continue;
                throw new IllegalArgumentException("value \"" + checkMe + "\" may not contain the characters \"{}[],:;=\"");
            }
        }
    }
}

