/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.spring.bridge.api;

import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class SpringScopeImpl
implements Scope {
    private final ReentrantLock lock = new ReentrantLock();
    private ServiceLocator locator;

    public void setServiceLocator(ServiceLocator locator) {
        this.lock.lock();
        try {
            this.locator = locator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setServiceLocatorName(String name) {
        this.lock.lock();
        try {
            this.locator = ServiceLocatorFactory.getInstance().create(name);
        }
        finally {
            this.lock.unlock();
        }
    }

    public ServiceLocator getServiceLocator() {
        this.lock.lock();
        try {
            ServiceLocator serviceLocator = this.locator;
            return serviceLocator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceHandle<?> getServiceFromName(String id) {
        this.lock.lock();
        try {
            if (this.locator == null) {
                throw new IllegalStateException("ServiceLocator must be set");
            }
            ActiveDescriptor best = this.locator.getBestDescriptor((Filter)BuilderHelper.createTokenizedFilter((String)id));
            if (best == null) {
                ServiceHandle<?> serviceHandle = null;
                return serviceHandle;
            }
            ServiceHandle serviceHandle = this.locator.getServiceHandle(best);
            return serviceHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Object get(String contractName, ObjectFactory<?> factory) {
        ServiceHandle<?> serviceHandle = this.getServiceFromName(contractName);
        if (serviceHandle == null) {
            return factory.getObject();
        }
        return serviceHandle.getService();
    }

    public String getConversationId() {
        return null;
    }

    public void registerDestructionCallback(String arg0, Runnable arg1) {
    }

    public Object remove(String arg0) {
        ServiceHandle<?> handle = this.getServiceFromName(arg0);
        if (handle == null) {
            return null;
        }
        handle.destroy();
        return null;
    }

    public Object resolveContextualObject(String arg0) {
        return null;
    }
}

