/*
 * Copyright (c) 2014, 2019 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.jersey.ext.cdi1x.hk2ban;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

import org.glassfish.jersey.ext.cdi1x.spi.Hk2CustomBoundTypesProvider;

/**
 * Utility class that effectively disables any attempts of Jersey/CDI integration layer
 * to delegate injection from CDI to HK2.
 *
 * @author Jakub Podlesak
 */
public final class EmptyHk2CustomInjectionTypeProvider implements Hk2CustomBoundTypesProvider {

    @Override
    public Set<Type> getHk2Types() {
        return Collections.emptySet();
    }
}
