/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.weld.se;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.jersey.ext.cdi1x.internal.JerseyVetoed;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spi.ExternalRequestContext;
import org.glassfish.jersey.server.spi.ExternalRequestScope;
import org.jboss.weld.context.bound.BoundRequestContext;

@ApplicationScoped
@JerseyVetoed
public class WeldRequestScope
implements ExternalRequestScope<Map<String, Object>> {
    @Inject
    private BoundRequestContext context;
    private final ThreadLocal<Map<String, Object>> actualMap = new ThreadLocal();
    public static final ThreadLocal<InjectionManager> actualInjectorManager = new ThreadLocal();

    public ExternalRequestContext<Map<String, Object>> open(InjectionManager injectionManager) {
        ConcurrentHashMap newMap = new ConcurrentHashMap();
        this.actualMap.set(newMap);
        this.context.associate(newMap);
        this.context.activate();
        actualInjectorManager.set(injectionManager);
        return new ExternalRequestContext(newMap);
    }

    public void resume(ExternalRequestContext<Map<String, Object>> ctx, InjectionManager injectionManager) {
        Map newMap = (Map)ctx.getContext();
        actualInjectorManager.set(injectionManager);
        this.actualMap.set(newMap);
        this.context.associate((Object)newMap);
        this.context.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(ExternalRequestContext<Map<String, Object>> ctx, InjectionManager injectionManager) {
        try {
            Map<String, Object> contextMap = this.actualMap.get();
            if (contextMap != null) {
                this.context.deactivate();
                this.context.dissociate(contextMap);
            }
        }
        finally {
            this.actualMap.remove();
            actualInjectorManager.remove();
        }
    }

    public void close() {
        try {
            Map<String, Object> contextMap = this.actualMap.get();
            if (contextMap != null) {
                this.context.invalidate();
                this.context.deactivate();
                this.context.dissociate(contextMap);
            } else {
                this.context.deactivate();
            }
        }
        finally {
            this.actualMap.remove();
            actualInjectorManager.remove();
        }
    }
}

