/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import jakarta.ws.rs.core.Link;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import org.glassfish.jersey.Beta;
import org.glassfish.jersey.linking.Binding;

@Target(value={ElementType.FIELD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Beta
public @interface InjectLink {
    public Style style() default Style.ABSOLUTE_PATH;

    public String value() default "";

    public Class<?> resource() default Class.class;

    public String method() default "";

    public Binding[] bindings() default {};

    public String condition() default "";

    public String rel() default "";

    public String rev() default "";

    public String type() default "";

    public String title() default "";

    public String anchor() default "";

    public String media() default "";

    public String hreflang() default "";

    public Extension[] extensions() default {};

    public static class Util {
        public static Link buildLinkFromUri(URI uri, InjectLink link) {
            Link.Builder builder = Link.fromUri((URI)uri);
            if (!link.rel().isEmpty()) {
                builder = builder.rel(link.rel());
            }
            if (!link.rev().isEmpty()) {
                builder = builder.param("rev", link.rev());
            }
            if (!link.type().isEmpty()) {
                builder = builder.type(link.type());
            }
            if (!link.title().isEmpty()) {
                builder = builder.param("title", link.title());
            }
            if (!link.anchor().isEmpty()) {
                builder = builder.param("anchor", link.anchor());
            }
            if (!link.media().isEmpty()) {
                builder = builder.param("media", link.media());
            }
            if (!link.hreflang().isEmpty()) {
                builder = builder.param("hreflang", link.hreflang());
            }
            for (Extension ext : link.extensions()) {
                builder = builder.param(ext.name(), ext.value());
            }
            return builder.build(new Object[0]);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Extension {
        public String name();

        public String value();
    }

    public static enum Style {
        ABSOLUTE,
        ABSOLUTE_PATH,
        RELATIVE_PATH;

    }
}

