/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import jakarta.ws.rs.core.Link;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.linking.FieldDescriptor;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkFieldDescriptor;
import org.glassfish.jersey.linking.InjectLinks;

class InjectLinksFieldDescriptor
extends FieldDescriptor {
    private final InjectLinks link;
    private final Class<?> type;

    InjectLinksFieldDescriptor(Field f, InjectLinks l, Class<?> t) {
        super(f);
        this.link = l;
        this.type = t;
    }

    public void setPropertyValue(Object instance, List<Link> list) {
        InjectLinksFieldDescriptor.setAccessibleField(this.field);
        try {
            Object[] value;
            Object[] merged = this.mergeWithExistingField(instance, list);
            if (Objects.equals(List.class, this.type)) {
                value = merged;
            } else if (this.type.isArray()) {
                value = merged.toArray((Object[])Array.newInstance(this.type.getComponentType(), merged.size()));
            } else {
                throw new IllegalArgumentException("Field type " + this.type + " not one of supported List<Link> or Link[]");
            }
            this.field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Logger.getLogger(InjectLinksFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private List<Link> mergeWithExistingField(Object instance, List<Link> list) throws IllegalAccessException {
        Object existing = this.field.get(instance);
        if (existing != null) {
            if (Collection.class.isAssignableFrom(existing.getClass()) && !((Collection)existing).isEmpty()) {
                ArrayList<Link> merged = new ArrayList<Link>(list);
                merged.addAll((Collection)existing);
                return merged;
            }
            if (existing.getClass().isArray() && existing.getClass().isAssignableFrom(Link[].class)) {
                ArrayList<Link> merged = new ArrayList<Link>(list);
                merged.addAll(Arrays.asList((Link[])existing));
                return merged;
            }
        }
        return list;
    }

    InjectLinkFieldDescriptor[] getLinksToInject() {
        InjectLink[] listOfLinks = this.link.value();
        InjectLinkFieldDescriptor[] fields = new InjectLinkFieldDescriptor[listOfLinks.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new InjectLinkFieldDescriptor(this.field, listOfLinks[i], Link.class);
        }
        return fields;
    }
}

