
package org.glassfish.jersey.microprofile.restclient.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.microprofile.restclient.internal.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableERR_INVALID_PROXY_PORT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("err.invalid.proxy.port", arg0);
    }

    /**
     * Invalid proxy port: {0}.
     * 
     */
    public static String ERR_INVALID_PROXY_PORT(Object arg0) {
        return LOCALIZER.localize(localizableERR_INVALID_PROXY_PORT(arg0));
    }

    public static Localizable localizableERR_INVALID_PROXY_URI(Object arg0) {
        return MESSAGE_FACTORY.getMessage("err.invalid.proxy.uri", arg0);
    }

    /**
     * Invalid proxy URI: {0}.
     * 
     */
    public static String ERR_INVALID_PROXY_URI(Object arg0) {
        return LOCALIZER.localize(localizableERR_INVALID_PROXY_URI(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
