/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.LazyUid;
import org.glassfish.jersey.process.internal.RequestContext;

public final class CdiRequestContext
implements RequestContext {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(CdiRequestContext.class.getName()), Level.FINEST);
    private final LazyUid id = new LazyUid();
    private final AtomicInteger referenceCounter;
    private final Map<String, Object> store = new HashMap<String, Object>();

    CdiRequestContext() {
        this.referenceCounter = new AtomicInteger(1);
    }

    Map<String, Object> getStore() {
        return this.store;
    }

    public RequestContext getReference() {
        this.referenceCounter.incrementAndGet();
        return this;
    }

    public void release() {
        if (this.referenceCounter.decrementAndGet() < 1) {
            try {
                this.store.clear();
            }
            catch (Throwable throwable) {
                logger.debugLog("Released scope instance {0}", new Object[]{this});
                throw throwable;
            }
            logger.debugLog("Released scope instance {0}", new Object[]{this});
        }
    }

    public String toString() {
        return "Instance{id=" + this.id + ", referenceCounter=" + this.referenceCounter + ", store size=" + this.store.size() + '}';
    }
}

