/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.spi.CreationalContext;
import org.glassfish.jersey.inject.cdi.se.ParameterizedTypeImpl;
import org.glassfish.jersey.inject.cdi.se.bean.JerseyBean;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;

class SupplierInstanceBean<T>
extends JerseyBean<Supplier<T>> {
    private final Set<Type> contracts = new HashSet<Type>();
    private final Supplier<T> supplier;

    SupplierInstanceBean(SupplierInstanceBinding<T> binding) {
        super(binding);
        this.supplier = binding.getSupplier();
        for (Type contract : binding.getContracts()) {
            this.contracts.add(new ParameterizedTypeImpl((Type)((Object)Supplier.class), contract));
            if (!DisposableSupplier.class.isAssignableFrom(binding.getSupplier().getClass())) continue;
            this.contracts.add(new ParameterizedTypeImpl((Type)((Object)DisposableSupplier.class), contract));
        }
    }

    @Override
    public Set<Type> getTypes() {
        return this.contracts;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return DEFAULT_QUALIFIERS;
    }

    public Supplier<T> create(CreationalContext<Supplier<T>> context) {
        return this.supplier;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.supplier.getClass();
    }
}

