/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.injector;

import jakarta.ws.rs.core.Application;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.glassfish.jersey.internal.inject.Injectee;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.process.internal.RequestScoped;

public class JerseyProxyResolver {
    private final ConcurrentHashMap<AnnotatedElement, Object> cachedProxies = new ConcurrentHashMap();
    private static final List<Class<?>> IGNORED_CLASSES = Collections.singletonList(Application.class);

    public boolean isPrixiable(Injectee injectee) {
        return !this.ignoredClass(injectee.getRequiredType()) && this.isPrixiable(injectee.getParentClassScope());
    }

    public boolean isPrixiable(Class<? extends Annotation> scopeAnnotation) {
        return this.ignoreProxy().stream().noneMatch(ignoredAnnotation -> ignoredAnnotation == scopeAnnotation);
    }

    public Object proxy(Injectee injectee, InjectionResolver resolver) {
        return this.cachedProxies.computeIfAbsent(injectee.getParent(), type -> this.createProxy(injectee, resolver));
    }

    public Object noCachedProxy(Injectee injectee, Supplier<Object> supplier) {
        return this.createProxy(this.getClass(injectee.getRequiredType()), supplier);
    }

    private Object createProxy(Injectee injectee, InjectionResolver resolver) {
        return this.createProxy(this.getClass(injectee.getRequiredType()), () -> resolver.resolve(injectee));
    }

    private Object createProxy(Class<?> requiredClass, Supplier<Object> supplier) {
        return Proxy.newProxyInstance(requiredClass.getClassLoader(), new Class[]{requiredClass}, (InvocationHandler)new JerseyInvocationHandler(supplier));
    }

    private Class<?> getClass(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            return (Class)paramType.getRawType();
        }
        return (Class)type;
    }

    private Collection<Class<? extends Annotation>> ignoreProxy() {
        return Arrays.asList(jakarta.enterprise.context.RequestScoped.class, RequestScoped.class);
    }

    private boolean ignoredClass(Type type) {
        Class clazz;
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            clazz = (Class)paramType.getRawType();
        } else {
            clazz = (Class)type;
        }
        return IGNORED_CLASSES.contains(clazz);
    }

    private static class JerseyInvocationHandler
    implements InvocationHandler {
        private final Supplier<Object> supplier;

        private JerseyInvocationHandler(Supplier<Object> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object target = this.supplier.get();
            return method.invoke(target, args);
        }
    }
}

