/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.bean;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.glassfish.jersey.inject.cdi.se.bean.JerseyBean;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;

class SupplierInstanceBeanBridge<T>
extends JerseyBean<Object> {
    private final Supplier<T> supplier;
    private final Class<? extends Annotation> scope;

    SupplierInstanceBeanBridge(SupplierInstanceBinding binding) {
        super(binding);
        SupplierInstanceBinding casted = binding;
        this.supplier = casted.getSupplier();
        this.scope = casted.getScope();
    }

    public Object create(CreationalContext creationalContext) {
        return this.supplier.get();
    }

    @Override
    public void destroy(Object instance, CreationalContext<Object> context) {
        if (DisposableSupplier.class.isAssignableFrom(this.supplier.getClass())) {
            ((DisposableSupplier)this.supplier).dispose(instance);
        }
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope == null ? Dependent.class : SupplierInstanceBeanBridge.transformScope(this.scope);
    }
}

