/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gson.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.glassfish.jersey.gson.LocalizationMessages;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.glassfish.jersey.message.internal.EntityInputStream;
import org.glassfish.jersey.message.internal.ReaderWriter;

@Provider
@Produces(value={"application/json", "text/json", "*/*"})
@Consumes(value={"application/json", "text/json", "*/*"})
public class JsonGsonProvider
extends AbstractMessageReaderWriterProvider<Object> {
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    private Providers providers;

    @Inject
    public JsonGsonProvider(@Context Providers providers) {
        this.providers = providers;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonGsonProvider.supportsMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        EntityInputStream entityInputStream = new EntityInputStream(entityStream);
        entityStream = entityInputStream;
        if (entityInputStream.isEmpty()) {
            throw new NoContentException(LocalizationMessages.ERROR_GSON_EMPTYSTREAM());
        }
        Gson gson = this.getGson(type);
        try {
            return gson.fromJson((Reader)new InputStreamReader((InputStream)entityInputStream, ReaderWriter.getCharset((MediaType)mediaType)), genericType);
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_GSON_DESERIALIZATION(), (Throwable)e);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonGsonProvider.supportsMediaType(mediaType);
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Gson gson = this.getGson(type);
        try {
            entityStream.write(gson.toJson(o).getBytes(ReaderWriter.getCharset((MediaType)mediaType)));
            entityStream.flush();
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_GSON_SERIALIZATION(), (Throwable)e);
        }
    }

    private Gson getGson(Class<?> type) {
        ContextResolver contextResolver = this.providers.getContextResolver(Gson.class, MediaType.APPLICATION_JSON_TYPE);
        if (contextResolver != null) {
            return (Gson)contextResolver.getContext(type);
        }
        return GsonSingleton.INSTANCE.getInstance();
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    private static enum GsonSingleton {
        INSTANCE;

        private Gson gsonInstance = new GsonBuilder().create();

        Gson getInstance() {
            return this.gsonInstance;
        }
    }
}

