/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth1;

import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.logging.Logger;
import org.glassfish.jersey.client.oauth1.AccessToken;
import org.glassfish.jersey.client.oauth1.OAuth1AuthorizationFlow;
import org.glassfish.jersey.client.oauth1.OAuth1Builder;
import org.glassfish.jersey.client.oauth1.OAuth1BuilderImpl;
import org.glassfish.jersey.client.oauth1.OAuth1ClientFeature;
import org.glassfish.jersey.client.oauth1.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.oauth1.signature.OAuth1Parameters;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;

class OAuth1AuthorizationFlowImpl
implements OAuth1AuthorizationFlow {
    private static final Logger LOGGER = Logger.getLogger(OAuth1AuthorizationFlowImpl.class.getName());
    private final OAuth1Parameters parameters;
    private final OAuth1Secrets secrets;
    private final String requestTokenUri;
    private final String accessTokenUri;
    private final String authorizationUri;
    private final Client client;
    private volatile AccessToken accessToken;
    private final Value<Feature> oAuth1ClientFilterFeature = new Value<Feature>(){

        public Feature get() {
            return new OAuth1BuilderImpl(OAuth1AuthorizationFlowImpl.this.parameters, OAuth1AuthorizationFlowImpl.this.secrets).feature().accessToken(OAuth1AuthorizationFlowImpl.this.accessToken).build();
        }
    };

    private OAuth1AuthorizationFlowImpl(OAuth1Parameters params, OAuth1Secrets secrets, String requestTokenUri, String accessTokenUri, String authorizationUri, String callbackUri, Client client, boolean enableLogging) {
        this.parameters = params;
        this.secrets = secrets;
        this.requestTokenUri = requestTokenUri;
        this.accessTokenUri = accessTokenUri;
        this.authorizationUri = authorizationUri;
        this.client = client != null ? client : ClientBuilder.newBuilder().build();
        Configuration config = this.client.getConfiguration();
        if (enableLogging && !config.isRegistered(LoggingFeature.class)) {
            this.client.register((Object)new LoggingFeature(LOGGER, LoggingFeature.Verbosity.PAYLOAD_ANY));
        }
        if (!config.isRegistered(OAuth1ClientFeature.class)) {
            this.client.register((Object)new OAuth1ClientFeature(params, secrets));
        }
        if (callbackUri != null) {
            this.parameters.callback(callbackUri);
        }
        if (secrets.getConsumerSecret() == null || this.parameters.getConsumerKey() == null) {
            throw new IllegalStateException(LocalizationMessages.ERROR_CONFIGURATION_MISSING_CONSUMER());
        }
    }

    private Invocation.Builder addProperties(Invocation.Builder invocationBuilder) {
        return invocationBuilder.property("jersey.config.client.oauth1.parameters", (Object)this.parameters).property("jersey.config.client.oauth1.secrets", (Object)this.secrets);
    }

    @Override
    public String start() {
        Response response = this.addProperties(this.client.target(this.requestTokenUri).request()).header("Content-Type", (Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(null);
        if (response.getStatus() != 200) {
            throw new RuntimeException(LocalizationMessages.ERROR_REQUEST_REQUEST_TOKEN(response.getStatus()));
        }
        MultivaluedMap formParams = ((Form)response.readEntity(Form.class)).asMap();
        this.parameters.token((String)formParams.getFirst((Object)"oauth_token"));
        this.secrets.tokenSecret((String)formParams.getFirst((Object)"oauth_token_secret"));
        return UriBuilder.fromUri((String)this.authorizationUri).queryParam("oauth_token", new Object[]{this.parameters.getToken()}).build(new Object[0]).toString();
    }

    @Override
    public AccessToken finish() {
        return this.finish(null);
    }

    @Override
    public AccessToken finish(String verifier) {
        AccessToken resultToken;
        this.parameters.setVerifier(verifier);
        Response response = this.addProperties(this.client.target(this.accessTokenUri).request()).header("Content-Type", (Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(null);
        if (response.getStatus() >= 400) {
            throw new RuntimeException(LocalizationMessages.ERROR_REQUEST_ACCESS_TOKEN(response.getStatus()));
        }
        Form form = (Form)response.readEntity(Form.class);
        String accessToken = (String)form.asMap().getFirst((Object)"oauth_token");
        String accessTokenSecret = (String)form.asMap().getFirst((Object)"oauth_token_secret");
        if (accessToken == null) {
            throw new NotAuthorizedException((Object)LocalizationMessages.ERROR_REQUEST_ACCESS_TOKEN_NULL(), new Object[0]);
        }
        this.parameters.token(accessToken);
        this.secrets.tokenSecret(accessTokenSecret);
        this.accessToken = resultToken = new AccessToken(this.parameters.getToken(), this.secrets.getTokenSecret());
        return resultToken;
    }

    @Override
    public Client getAuthorizedClient() {
        return (Client)ClientBuilder.newClient().register((Object)this.getOAuth1Feature());
    }

    @Override
    public Feature getOAuth1Feature() {
        if (this.accessToken == null) {
            throw new IllegalStateException(LocalizationMessages.ERROR_FLOW_NOT_FINISHED());
        }
        return (Feature)this.oAuth1ClientFilterFeature.get();
    }

    static class Builder
    implements OAuth1Builder.FlowBuilder {
        private final OAuth1Parameters params;
        private final OAuth1Secrets secrets;
        private String requestTokenUri;
        private String accessTokenUri;
        private String authorizationUri;
        private Client client;
        private String callbackUri;
        private boolean enableLogging;

        public Builder(OAuth1Parameters params, OAuth1Secrets secrets, String requestTokenUri, String accessTokenUri, String authorizationUri) {
            this.params = params;
            this.secrets = secrets;
            this.requestTokenUri = requestTokenUri;
            this.accessTokenUri = accessTokenUri;
            this.authorizationUri = authorizationUri;
        }

        @Override
        public OAuth1Builder.FlowBuilder callbackUri(String callbackUri) {
            this.callbackUri = callbackUri;
            return this;
        }

        @Override
        public OAuth1Builder.FlowBuilder client(Client client) {
            this.client = client;
            return this;
        }

        @Override
        public OAuth1Builder.FlowBuilder enableLogging() {
            this.enableLogging = true;
            return this;
        }

        @Override
        public OAuth1AuthorizationFlowImpl build() {
            return new OAuth1AuthorizationFlowImpl(this.params, this.secrets, this.requestTokenUri, this.accessTokenUri, this.authorizationUri, this.callbackUri, this.client, this.enableLogging);
        }
    }
}

