/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.oauth1.signature.OAuth1Parameters;
import org.glassfish.jersey.oauth1.signature.OAuth1Request;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;
import org.glassfish.jersey.oauth1.signature.OAuth1Signature;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureException;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.oauth1.NonceManager;
import org.glassfish.jersey.server.oauth1.OAuth1Consumer;
import org.glassfish.jersey.server.oauth1.OAuth1Exception;
import org.glassfish.jersey.server.oauth1.OAuth1Provider;
import org.glassfish.jersey.server.oauth1.OAuth1SecurityContext;
import org.glassfish.jersey.server.oauth1.OAuth1ServerProperties;
import org.glassfish.jersey.server.oauth1.OAuth1Token;
import org.glassfish.jersey.server.oauth1.TokenResource;
import org.glassfish.jersey.server.oauth1.internal.OAuthServerRequest;

@Priority(value=1000)
class OAuth1ServerFilter
implements ContainerRequestFilter {
    @Inject
    private OAuth1Provider provider;
    private final NonceManager nonces;
    private final String wwwAuthenticateHeader;
    private final Set<String> versions;
    private final Pattern ignorePathPattern;
    @Inject
    private OAuth1Signature oAuth1Signature;
    @Inject
    private Provider<ExtendedUriInfo> uriInfo;
    private final boolean optional;

    @Inject
    public OAuth1ServerFilter(Configuration rc) {
        HashSet<String> v = new HashSet<String>();
        v.add(null);
        v.add("1.0");
        this.versions = Collections.unmodifiableSet(v);
        String realm = OAuth1ServerProperties.getValue(rc.getProperties(), "jersey.config.server.oauth1.realm", "default", String.class);
        int maxAge = OAuth1ServerProperties.getValue(rc.getProperties(), "jersey.config.server.oauth1.maxAge", 300000);
        int gcPeriod = OAuth1ServerProperties.getValue(rc.getProperties(), "jersey.config.server.oauth1.gcPeriod", 100);
        this.ignorePathPattern = OAuth1ServerFilter.pattern(OAuth1ServerProperties.getValue(rc.getProperties(), "jersey.config.server.oauth1.ignorePathPattern", null, String.class));
        this.optional = PropertiesHelper.isProperty((Map)rc.getProperties(), (String)"jersey.config.server.oauth1.noFail");
        String timeUnitStr = (String)((Object)OAuth1ServerProperties.getValue(rc.getProperties(), "jersey.config.server.oauth1.timestamp.unit", String.class));
        TimeUnit timeUnit = timeUnitStr != null ? TimeUnit.valueOf(timeUnitStr) : TimeUnit.SECONDS;
        int maxCacheSize = OAuth1ServerProperties.getValue(rc.getProperties(), "jersey.config.server.oauth1.max.nonce.size", 2000000);
        this.nonces = new NonceManager(maxAge, gcPeriod, timeUnit, maxCacheSize);
        this.wwwAuthenticateHeader = "OAuth realm=\"" + realm + "\"";
    }

    public void filter(ContainerRequestContext request) throws IOException {
        OAuth1SecurityContext sc;
        String authHeader = request.getHeaderString("Authorization");
        if (authHeader == null || !authHeader.toUpperCase().startsWith("OAuth".toUpperCase())) {
            return;
        }
        Method handlingMethod = ((ExtendedUriInfo)this.uriInfo.get()).getMatchedResourceMethod().getInvocable().getHandlingMethod();
        if (handlingMethod.isAnnotationPresent(TokenResource.class) || handlingMethod.getDeclaringClass().isAnnotationPresent(TokenResource.class)) {
            return;
        }
        if (OAuth1ServerFilter.match(this.ignorePathPattern, request.getUriInfo().getPath())) {
            return;
        }
        try {
            sc = this.getSecurityContext(request);
        }
        catch (OAuth1Exception e) {
            if (this.optional) {
                return;
            }
            throw e;
        }
        request.setSecurityContext((SecurityContext)sc);
    }

    private OAuth1SecurityContext getSecurityContext(ContainerRequestContext request) throws OAuth1Exception {
        OAuth1SecurityContext sc;
        String nonceKey;
        OAuthServerRequest osr = new OAuthServerRequest(request);
        OAuth1Parameters params = new OAuth1Parameters().readRequest((OAuth1Request)osr);
        if (params.size() == 0) {
            throw this.newUnauthorizedException();
        }
        String consumerKey = OAuth1ServerFilter.requiredOAuthParam(params.getConsumerKey());
        String token = params.getToken();
        String timestamp = OAuth1ServerFilter.requiredOAuthParam(params.getTimestamp());
        String nonce = OAuth1ServerFilter.requiredOAuthParam(params.getNonce());
        OAuth1ServerFilter.requiredOAuthParam(params.getSignature());
        OAuth1ServerFilter.supportedOAuthParam(params.getVersion(), this.versions);
        OAuth1Consumer consumer = this.provider.getConsumer(consumerKey);
        if (consumer == null) {
            throw this.newUnauthorizedException();
        }
        OAuth1Secrets secrets = new OAuth1Secrets().consumerSecret(consumer.getSecret());
        if (token == null) {
            if (consumer.getPrincipal() == null) {
                throw this.newUnauthorizedException();
            }
            nonceKey = "c:" + consumerKey;
            sc = new OAuth1SecurityContext(consumer, request.getSecurityContext().isSecure());
        } else {
            OAuth1Token accessToken = this.provider.getAccessToken(token);
            if (accessToken == null) {
                throw this.newUnauthorizedException();
            }
            OAuth1Consumer atConsumer = accessToken.getConsumer();
            if (atConsumer == null || !consumerKey.equals(atConsumer.getKey())) {
                throw this.newUnauthorizedException();
            }
            nonceKey = "t:" + token;
            secrets.tokenSecret(accessToken.getSecret());
            sc = new OAuth1SecurityContext(accessToken, request.getSecurityContext().isSecure());
        }
        if (!this.verifySignature(osr, params, secrets)) {
            throw this.newUnauthorizedException();
        }
        if (!this.nonces.verify(nonceKey, timestamp, nonce)) {
            throw this.newUnauthorizedException();
        }
        return sc;
    }

    private static String requiredOAuthParam(String value) throws OAuth1Exception {
        if (value == null) {
            throw OAuth1ServerFilter.newBadRequestException();
        }
        return value;
    }

    private static String supportedOAuthParam(String value, Set<String> set) throws OAuth1Exception {
        if (!set.contains(value)) {
            throw OAuth1ServerFilter.newBadRequestException();
        }
        return value;
    }

    private static Pattern pattern(String p) {
        if (p == null) {
            return null;
        }
        return Pattern.compile(p);
    }

    private static boolean match(Pattern pattern, String value) {
        return pattern != null && value != null && pattern.matcher(value).matches();
    }

    private boolean verifySignature(OAuthServerRequest osr, OAuth1Parameters params, OAuth1Secrets secrets) {
        try {
            return this.oAuth1Signature.verify((OAuth1Request)osr, params, secrets);
        }
        catch (OAuth1SignatureException ose) {
            throw OAuth1ServerFilter.newBadRequestException();
        }
    }

    private static OAuth1Exception newBadRequestException() throws OAuth1Exception {
        return new OAuth1Exception(Response.Status.BAD_REQUEST, null);
    }

    private OAuth1Exception newUnauthorizedException() throws OAuth1Exception {
        return new OAuth1Exception(Response.Status.UNAUTHORIZED, this.wwwAuthenticateHeader);
    }
}

