/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.oauth1.signature;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.oauth1.signature.Base64;
import org.glassfish.jersey.oauth1.signature.InvalidSecretException;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureMethod;
import org.glassfish.jersey.oauth1.signature.internal.LocalizationMessages;

public final class RsaSha1Method
implements OAuth1SignatureMethod {
    private static final Logger LOGGER = Logger.getLogger(RsaSha1Method.class.getName());
    public static final String NAME = "RSA-SHA1";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String KEY_TYPE = "RSA";
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String sign(String baseString, OAuth1Secrets secrets) throws InvalidSecretException {
        byte[] rsasha1;
        RSAPrivateKey rsaPrivateKey;
        KeyFactory keyFactory;
        byte[] decodedPrivateKey;
        Signature signature;
        try {
            signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        try {
            decodedPrivateKey = Base64.decode(secrets.getConsumerSecret());
        }
        catch (IOException ioe) {
            throw new InvalidSecretException(LocalizationMessages.ERROR_INVALID_CONSUMER_SECRET(ioe));
        }
        try {
            keyFactory = KeyFactory.getInstance(KEY_TYPE);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedPrivateKey);
        try {
            rsaPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new IllegalStateException(ikse);
        }
        try {
            signature.initSign(rsaPrivateKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        try {
            signature.update(baseString.getBytes());
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
        try {
            rsasha1 = signature.sign();
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
        return Base64.encode(rsasha1);
    }

    @Override
    public boolean verify(String elements, OAuth1Secrets secrets, String signature) throws InvalidSecretException {
        byte[] decodedSignature;
        Signature sig;
        try {
            sig = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        RSAPublicKey rsaPubKey = null;
        String tmpkey = secrets.getConsumerSecret();
        if (tmpkey.startsWith(BEGIN_CERT)) {
            try {
                Certificate cert = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(tmpkey.getBytes());
                BufferedInputStream bis = new BufferedInputStream(bais);
                CertificateFactory certfac = CertificateFactory.getInstance("X.509");
                while (bis.available() > 0) {
                    cert = certfac.generateCertificate(bis);
                }
                rsaPubKey = (RSAPublicKey)cert.getPublicKey();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_CANNOT_OBTAIN_PUBLIC_KEY(), ex);
                return false;
            }
        }
        try {
            decodedSignature = Base64.decode(signature);
        }
        catch (IOException e) {
            return false;
        }
        try {
            sig.initVerify(rsaPubKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        try {
            sig.update(elements.getBytes());
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
        try {
            return sig.verify(decodedSignature);
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
    }
}

