/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.auth;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class OAuth2SaslClient
implements SaslClient {
    private CallbackHandler cbh;
    private boolean complete = false;

    public OAuth2SaslClient(Map<String, ?> props, CallbackHandler cbh) {
        this.cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return "XOAUTH2";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.complete) {
            return new byte[0];
        }
        NameCallback ncb = new NameCallback("User name:");
        PasswordCallback pcb = new PasswordCallback("OAuth token:", false);
        try {
            this.cbh.handle(new Callback[]{ncb, pcb});
        }
        catch (UnsupportedCallbackException ex) {
            throw new SaslException("Unsupported callback", ex);
        }
        catch (IOException ex) {
            throw new SaslException("Callback handler failed", ex);
        }
        String user = ncb.getName();
        String token = new String(pcb.getPassword());
        pcb.clearPassword();
        CallSite resp = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"user=\u0001\u0002\u0001\u0002", "\u0001auth=Bearer ", "\u0001\u0001"}, (String)user, token);
        byte[] response = ((String)((Object)resp)).getBytes(StandardCharsets.UTF_8);
        this.complete = true;
        return response;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("OAUTH2 unwrap not supported");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("OAUTH2 wrap not supported");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw new IllegalStateException("OAUTH2 getNegotiatedProperty");
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

