/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.glassfish.pfl.tf.spi.EnhancedClassDataBase;
import org.glassfish.pfl.tf.spi.TimingPointType;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.spi.annotation.TFEnhanced;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EnhancedClassDataASMImpl
extends EnhancedClassDataBase {
    private final ClassNode currentClass;
    private static final String TFENHANCED_ANNO_NAME = Type.getInternalName(TFEnhanced.class);

    private void processClassAnnotations() {
        List classAnnotations = this.currentClass.visibleAnnotations;
        if (classAnnotations != null) {
            for (AnnotationNode an : classAnnotations) {
                String aname = Type.getType((String)an.desc).getInternalName();
                if (!this.annotationNames.contains(aname)) continue;
                this.annoNamesForClass.add(aname);
            }
            ArrayList acnames = new ArrayList(this.annoNamesForClass);
            Collections.sort(acnames);
            int ctr = 0;
            for (String aname : acnames) {
                this.annoToHolderName.put(aname, "__$mm$__" + ctr);
                ++ctr;
            }
            if (this.util.getDebug()) {
                this.util.msg("Enhancing class " + this.currentClass.name);
                this.util.msg("\tannoNamesForClass = " + String.valueOf(this.annoNamesForClass));
                this.util.msg("\tannoToHolderName = " + String.valueOf(this.annoToHolderName));
            }
        }
    }

    private Object getAttribute(AnnotationNode an, String name) {
        if (an.values != null) {
            Iterator iter = an.values.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = iter.next();
                if (!(key instanceof String)) {
                    return null;
                }
                if (!key.equals(name)) continue;
                return value;
            }
        }
        return null;
    }

    private void scanMethods() {
        List methods = this.currentClass.methods;
        HashMap<String, Object> mmnToDescriptions = new HashMap<String, Object>();
        HashMap<String, TimingPointType> mmnToTPT = new HashMap<String, TimingPointType>();
        HashMap<String, String> mmnToTPN = new HashMap<String, String>();
        HashMap<String, String> mmnToAnnotationName = new HashMap<String, String>();
        for (MethodNode mn : methods) {
            String mname = mn.name;
            String mdesc = this.util.getFullMethodDescriptor(mn);
            String monitoredMethodMMAnno = null;
            String shortClassName = this.className;
            int index = shortClassName.lastIndexOf(47);
            if (index >= 0) {
                shortClassName = this.className.substring(index + 1);
            }
            Object description = "Timer for method " + mname + " in class " + shortClassName;
            TimingPointType tpt = TimingPointType.BOTH;
            String tpName = mname;
            boolean hasMethodInfoAnno = false;
            List annotations = mn.visibleAnnotations;
            if (annotations == null) continue;
            for (AnnotationNode an : annotations) {
                Object value;
                String aname = Type.getType((String)an.desc).getInternalName();
                if (aname.equals(DESCRIPTION_NAME)) {
                    value = this.getAttribute(an, "value");
                    if (value == null || !(value instanceof String)) continue;
                    description = (String)value;
                    continue;
                }
                if (aname.equals(INFO_METHOD_NAME)) {
                    String[] enumData;
                    tpt = TimingPointType.NONE;
                    if (!this.util.hasAccess(mn.access, 2)) {
                        this.util.error("Method " + mdesc + " for Class " + this.currentClass.name + " is a non-private @InfoMethod, which is not allowed");
                    }
                    hasMethodInfoAnno = true;
                    value = this.getAttribute(an, "tpType");
                    if (value != null && value instanceof String[] && (enumData = (String[])value).length == 2) {
                        tpt = TimingPointType.valueOf(enumData[1]);
                    }
                    Object value2 = this.getAttribute(an, "tpName");
                    String tpn = "";
                    if (value2 != null && value2 instanceof String) {
                        tpn = (String)value2;
                    }
                    if (tpt == TimingPointType.NONE) continue;
                    if (tpn.length() == 0) {
                        this.util.error("Method " + mdesc + " for Class " + this.currentClass.name + " is an info method with timing point type " + String.valueOf((Object)tpt) + " but no tpName was specified");
                        continue;
                    }
                    tpName = tpn;
                    continue;
                }
                if (this.annoNamesForClass.contains(aname)) {
                    if (monitoredMethodMMAnno == null) {
                        monitoredMethodMMAnno = aname;
                        continue;
                    }
                    this.util.error("Method " + mdesc + " for Class " + this.currentClass.name + "has multiple MM annotations");
                    continue;
                }
                if (!this.annotationNames.contains(aname)) continue;
                this.util.error("Method " + mdesc + " for Class " + this.currentClass.name + " has an MM annotation which is not on its class");
            }
            if (hasMethodInfoAnno && monitoredMethodMMAnno != null) {
                this.util.error("Method " + mdesc + " for Class " + this.currentClass.name + " has both @InfoMethod annotation and a MM annotation");
            }
            boolean isStatic = this.util.hasAccess(mn.access, 8);
            if (hasMethodInfoAnno && isStatic) {
                this.util.error("Method " + mdesc + " for Class " + this.currentClass.name + " is a static method, but must not be");
            }
            if (mname.equals("<init>")) {
                if (hasMethodInfoAnno) {
                    this.util.error("Constructors must not have an @InfoMethod annotations");
                } else if (monitoredMethodMMAnno != null) {
                    this.util.error("Constructors must not have an MM annotation");
                }
            }
            mmnToAnnotationName.put(mname, monitoredMethodMMAnno);
            if (!hasMethodInfoAnno && monitoredMethodMMAnno == null) continue;
            this.methodNames.add(mname);
            mmnToDescriptions.put(mname, description);
            mmnToTPT.put(mname, tpt);
            mmnToTPN.put(mname, tpName);
            if (hasMethodInfoAnno) {
                this.infoMethodDescs.add(mdesc);
                continue;
            }
            this.mmMethodDescs.add(mdesc);
            this.methodToAnno.put(mdesc, monitoredMethodMMAnno);
        }
        Collections.sort(this.methodNames);
        for (String str : this.methodNames) {
            this.methodDescriptions.add((String)mmnToDescriptions.get(str));
            this.methodTPTs.add((TimingPointType)((Object)mmnToTPT.get(str)));
            this.methodAnnoList.add((String)mmnToAnnotationName.get(str));
            this.methodTPNames.add((String)mmnToTPN.get(str));
        }
        if (this.util.getDebug()) {
            this.util.msg("\tinfoMethodDescs = " + String.valueOf(this.infoMethodDescs));
            this.util.msg("\tmmMethodDescs = " + String.valueOf(this.mmMethodDescs));
            this.util.msg("\tmethodNames = " + String.valueOf(this.methodNames));
            this.util.msg("\tmethodToAnno = " + String.valueOf(this.methodToAnno));
            this.util.msg("\tmethodDescriptions = " + String.valueOf(this.methodDescriptions));
            this.util.msg("\tmethodTPTs = " + String.valueOf(this.methodTPTs));
            this.util.msg("\tmethodTPNs = " + String.valueOf(this.methodTPNames));
        }
    }

    public EnhancedClassDataASMImpl(Util util, Set<String> mmAnnotations, ClassNode cn) {
        super(util, mmAnnotations);
        this.currentClass = cn;
        this.className = cn.name;
        this.processClassAnnotations();
        this.scanMethods();
    }
}

