/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.impl;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Stack;
import org.glassfish.pfl.tf.timer.impl.LogEventHandlerIterator;
import org.glassfish.pfl.tf.timer.spi.LogEventHandler;
import org.glassfish.pfl.tf.timer.spi.NamedBase;
import org.glassfish.pfl.tf.timer.spi.TimerEvent;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;

public class LogEventHandlerImpl
extends NamedBase
implements LogEventHandler {
    private static final int DEFAULT_SIZE = 1000;
    private static final int DEFAULT_INCREMENT = 1000;
    private long[] data;
    private int size;
    private int increment;
    private int nextFree;
    private static final String ENTER_REP = ">> ";
    private static final String EXIT_REP = "<< ";

    LogEventHandlerImpl(TimerFactory factory, String name) {
        super(factory, name);
        this.initData(1000, 1000);
    }

    @Override
    public synchronized Iterator<TimerEvent> iterator() {
        return new LogEventHandlerIterator(this.factory(), this.data, this.nextFree);
    }

    private void initData(int size, int increment) {
        this.size = 2 * size;
        this.increment = 2 * increment;
        this.data = new long[this.size];
        this.nextFree = 0;
    }

    @Override
    public void notify(TimerEvent event) {
        int id = 2 * event.timer().id() + (event.type() == TimerEvent.TimerEventType.ENTER ? 0 : 1);
        this.log(id, event.time());
    }

    private synchronized void log(int id, long time) {
        if (this.data.length - this.nextFree < 2) {
            int newSize = this.data.length + 2 * this.increment;
            long[] newData = new long[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        int index = this.nextFree;
        this.nextFree += 2;
        this.data[index] = id;
        this.data[index + 1] = time;
    }

    @Override
    public synchronized void clear() {
        this.initData(this.size, this.increment);
    }

    @Override
    public void display(PrintStream arg, String msg) {
        arg.println("Displaying contents of " + String.valueOf(this) + ": " + msg);
        Stack<TimerEvent> stack = new Stack<TimerEvent>();
        long startTime = -1L;
        Indent indent = new Indent(ENTER_REP.length());
        for (TimerEvent te : this) {
            boolean isEnter;
            if (startTime == -1L) {
                startTime = te.time();
            }
            long relativeTime = (te.time() - startTime) / 1000L;
            boolean bl = isEnter = te.type() == TimerEvent.TimerEventType.ENTER;
            if (isEnter) {
                arg.printf("%8d: %s%s%s\n", relativeTime, indent, isEnter ? ENTER_REP : EXIT_REP, te.timer().name());
                stack.push(new TimerEvent(te));
                indent.in();
                continue;
            }
            TimerEvent enterEvent = (TimerEvent)stack.pop();
            indent.out();
            Object duration = null;
            duration = enterEvent.timer().equals(te.timer()) ? Long.toString((te.time() - enterEvent.time()) / 1000L) : "BAD NESTED EVENT: ENTER was " + enterEvent.timer().name();
            arg.printf("%8d: %s%s%s[%s]\n", relativeTime, indent, isEnter ? ENTER_REP : EXIT_REP, te.timer().name(), duration);
        }
    }

    private static class Indent {
        private final int width;
        private int level;
        private String rep;

        public Indent(int width) {
            this.width = width;
            this.level = 0;
            this.rep = "";
        }

        private void update() {
            int size = this.level * this.width;
            char[] content = new char[size];
            for (int ctr = 0; ctr < size; ++ctr) {
                content[ctr] = 32;
            }
            this.rep = new String(content);
        }

        public void in() {
            ++this.level;
            this.update();
        }

        public void out() {
            --this.level;
            this.update();
        }

        public String toString() {
            return this.rep;
        }
    }
}

