/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.PropertyOwner;
import com.sun.messaging.ReadOnlyPropertyException;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;
import jakarta.jms.JMSException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;

public abstract class AdministeredObject
implements Serializable {
    private static final long serialVersionUID = -7724163123027976185L;
    public static final String VERSION = "3.0";
    public static final String AO_PROPERTY_TYPE_STRING = "java.lang.String";
    public static final String AO_PROPERTY_TYPE_INTEGER = "java.lang.Integer";
    public static final String AO_PROPERTY_TYPE_LONG = "java.lang.Long";
    public static final String AO_PROPERTY_TYPE_BOOLEAN = "java.lang.Boolean";
    public static final String AO_PROPERTY_TYPE_PROPERTYOWNER = "com.sun.messaging.PropertyOwner";
    public static final String AO_PROPERTY_TYPE_LIST = "List";
    private boolean readOnly;
    public String storedVersion;
    protected Properties configuration;
    protected Properties configurationTypes;
    protected Properties configurationLabels;
    private static final String AO_TYPES = "_types";
    private static final String AO_LABELS = "_labels";
    private static final String AO_DEFAULTS = "_defaults";
    private static final String AO_PROP_EXT = ".properties";
    private static final String AO_PROPERTY_LIST_PROPERTY = ".property";
    private static final String AO_PROPERTY_LIST_SEPARATOR = "|";
    private static final String AO_PROPERTY_LIST_VALUES = ".List";
    private static final String AO_PROPERTY_LIST_OTHER_NAME = ".....property";
    private static final String AO_PROPERTY_ADMIN_GROUPLIST = "GroupList";
    private static final String AO_PROPERTY_ADMIN_GROUP = "Group.";
    private static final String AO_PROPERTY_ADMIN_GROUPLABEL = ".Label";
    public static final transient ClientResources cr = ClientResources.getResources();
    private static transient Hashtable deprecatedSysProperties = new Hashtable(6);
    private static transient Hashtable deprecatedProperties = new Hashtable(6);
    protected static final Map<String, Properties[]> cachedConfigurationMap;

    private AdministeredObject() {
    }

    public AdministeredObject(String defaultsBase) {
        this.initialiseConfiguration(defaultsBase);
        this.readOnly = false;
        this.storedVersion = VERSION;
        this.initOwnedProperties();
    }

    private void initialiseConfiguration(String defaultsBase) {
        Properties[] configurations = cachedConfigurationMap.get(defaultsBase);
        if (configurations == null) {
            try {
                InputStream is1 = this.getClass().getResourceAsStream(defaultsBase + AO_DEFAULTS + AO_PROP_EXT);
                InputStream is2 = this.getClass().getResourceAsStream(defaultsBase + AO_TYPES + AO_PROP_EXT);
                InputStream is3 = this.getClass().getResourceAsStream(defaultsBase + AO_LABELS + AO_PROP_EXT);
                if (is1 != null && is2 != null && is3 != null) {
                    this.configuration = new Properties();
                    this.configuration.load(is1);
                    is1.close();
                    this.configurationTypes = new Properties();
                    this.configurationTypes.load(is2);
                    is2.close();
                    this.configurationLabels = new Properties();
                    this.configurationLabels.load(is3);
                } else {
                    this.setDefaultConfiguration();
                }
            }
            catch (Exception e) {
                this.setDefaultConfiguration();
            }
            configurations = new Properties[]{(Properties)this.configuration.clone(), (Properties)this.configurationTypes.clone(), (Properties)this.configurationLabels.clone()};
            cachedConfigurationMap.put(defaultsBase, configurations);
        } else {
            this.configuration = (Properties)configurations[0].clone();
            this.configurationTypes = (Properties)configurations[1].clone();
            this.configurationLabels = (Properties)configurations[2].clone();
        }
    }

    public abstract void setDefaultConfiguration();

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final String getStoredVersion() {
        return this.storedVersion;
    }

    public final boolean isStoredVersionCompatible() {
        return VERSION.equals(this.storedVersion);
    }

    public final void setReadOnly() {
        this.readOnly = true;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public String getPropertyGroups() {
        return (String)this.configurationTypes.get(AO_PROPERTY_ADMIN_GROUPLIST);
    }

    public String getPropertiesForGroup(String group) {
        return (String)this.configurationTypes.get(AO_PROPERTY_ADMIN_GROUP + group);
    }

    public String getLabelForGroup(String group) {
        String lbl = "";
        try {
            lbl = (String)this.configurationTypes.get(AO_PROPERTY_ADMIN_GROUP + group + AO_PROPERTY_ADMIN_GROUPLABEL);
            lbl = cr.getString(lbl);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return lbl;
    }

    public String getPropertyListValues(String propname) {
        return (String)this.configurationTypes.get(propname + AO_PROPERTY_LIST_VALUES);
    }

    public String getPropertyForListValue(String listpropname, String listvalue) {
        return (String)this.configurationTypes.get(listpropname + "." + listvalue + AO_PROPERTY_LIST_PROPERTY);
    }

    public String getPropertyValueForListValue(String listpropname, String listvalue, String propname) {
        return (String)this.configurationTypes.get(listpropname + "." + listvalue + "." + propname);
    }

    public String getPropertyListOtherName(String propname) {
        return (String)this.configurationTypes.get(propname + AO_PROPERTY_LIST_OTHER_NAME);
    }

    public Enumeration enumeratePropertyNames() {
        return this.configuration.keys();
    }

    public String setProperty(String propname, String propval) throws JMSException {
        if (!this.readOnly) {
            if (propname == null) {
                throw new InvalidPropertyException(propname);
            }
            if (propname.length() > 3 && propname.startsWith("JMQ")) {
                propname = "imq" + propname.substring(3);
            }
            if (deprecatedProperties.containsKey(propname)) {
                propname = (String)deprecatedProperties.get(propname);
            }
            if (!this.configuration.containsKey(propname)) {
                throw new InvalidPropertyException(propname);
            }
            if ("imqConnectionType".equals(propname) && "SSL".equals(propval)) {
                propval = "TLS";
            }
            if ("imqJMSDeliveryMode".equals(propname)) {
                if ("1".equals(propval)) {
                    propval = "NON_PERSISTENT";
                }
                if ("2".equals(propval)) {
                    propval = "PERSISTENT";
                }
            }
            if (this.isPropertyValid(propname, propval, this.configurationTypes)) {
                String oldprop = (String)this.configuration.put(propname, propval);
                String proptype = this.getPropertyType(propname);
                if (AO_PROPERTY_TYPE_LIST.equals(proptype)) {
                    String lpropname = this.getPropertyForListValue(propname, propval);
                    String lproptype = this.getPropertyType(lpropname);
                    String lpropvalue = this.getPropertyValueForListValue(propname, propval, lpropname);
                    this.configuration.put(lpropname, lpropvalue);
                    if (AO_PROPERTY_TYPE_PROPERTYOWNER.equals(lproptype)) {
                        this.addOwnedProperties(lpropvalue);
                    }
                } else if (AO_PROPERTY_TYPE_PROPERTYOWNER.equals(proptype)) {
                    this.addOwnedProperties(propval);
                }
                return oldprop;
            }
            throw new InvalidPropertyValueException(propname, propval);
        }
        throw new ReadOnlyPropertyException(propname);
    }

    public String getProperty(String propname) throws JMSException {
        String propval;
        if (propname == null) {
            throw new InvalidPropertyException(propname);
        }
        if (propname.length() > 3 && propname.startsWith("JMQ")) {
            propname = "imq" + propname.substring(3);
        }
        if (deprecatedProperties.containsKey(propname)) {
            propname = (String)deprecatedProperties.get(propname);
        }
        if ((propval = (String)this.configuration.get(propname)) == null) {
            throw new InvalidPropertyException(propname);
        }
        return propval;
    }

    public String getPropertyType(String propname) throws JMSException {
        if (propname != null && propname.length() > 3 && propname.startsWith("JMQ")) {
            propname = "imq" + propname.substring(3);
        }
        if (!this.configuration.containsKey(propname)) {
            throw new InvalidPropertyException(propname);
        }
        return (String)this.configurationTypes.get(propname);
    }

    public String getPropertyLabel(String propname) throws JMSException {
        if (propname != null && propname.length() > 3 && propname.startsWith("JMQ")) {
            propname = "imq" + propname.substring(3);
        }
        if (!this.configuration.containsKey(propname)) {
            throw new InvalidPropertyException(propname);
        }
        String lbl = "";
        try {
            lbl = (String)this.configurationLabels.get(propname);
            lbl = cr.getString(lbl);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return lbl;
    }

    public boolean isPropertyHidden(String propname) throws JMSException {
        if (propname != null && propname.length() > 3 && propname.startsWith("JMQ")) {
            propname = "imq" + propname.substring(3);
        }
        if (!this.configuration.containsKey(propname)) {
            throw new InvalidPropertyException(propname);
        }
        return this.configurationTypes.containsKey(propname + ".hidden");
    }

    public boolean isPropertyDeprecated(String propname) throws JMSException {
        if (propname != null && propname.length() > 3 && propname.startsWith("JMQ")) {
            propname = "imq" + propname.substring(3);
        }
        if (!this.configuration.containsKey(propname)) {
            throw new InvalidPropertyException(propname);
        }
        return this.configurationTypes.containsKey(propname + ".deprecated");
    }

    public String toString() {
        return "\nClass:\t\t\t" + this.getClass().getName() + "\ngetVERSION():\t\t" + VERSION + "\nisReadonly():\t\t" + this.readOnly + "\ngetProperties():\t" + this.configuration.toString();
    }

    public String dump() {
        return this.toString() + "\n\ngetLabels():\t" + this.configurationLabels.toString() + "\n\ngetTypes():\t" + this.configurationTypes.toString();
    }

    public static final String getVERSION() {
        return VERSION;
    }

    public Properties getCurrentConfiguration() {
        Properties currentConfiguration = null;
        boolean cloned = false;
        if (this.readOnly) {
            return this.configuration;
        }
        Enumeration<Object> e = this.configuration.keys();
        while (e.hasMoreElements()) {
            String propkey = (String)e.nextElement();
            String syspropval = this._sysPropVal(propkey);
            if (syspropval == null) continue;
            if (!cloned) {
                try {
                    currentConfiguration = (Properties)this.configuration.clone();
                    cloned = true;
                }
                catch (Exception ce) {
                    return this.configuration;
                }
            }
            if (AO_PROPERTY_TYPE_LIST.equals(this.configurationTypes.get(propkey)) && this.isListPropertyValid(propkey, syspropval, this.configurationTypes)) {
                currentConfiguration.put(propkey, syspropval);
                String depndntpropkey = (String)this.configurationTypes.get(propkey + "." + syspropval + AO_PROPERTY_LIST_PROPERTY);
                String depndntpropval = (String)this.configurationTypes.get(propkey + "." + syspropval + "." + depndntpropkey);
                String depndntsyspropval = System.getProperty(depndntpropkey);
                propkey = depndntpropkey;
                String string = syspropval = depndntsyspropval != null ? depndntsyspropval : depndntpropval;
            }
            if (!this.isPropertyValid(propkey, syspropval, this.configurationTypes)) continue;
            currentConfiguration.put(propkey, syspropval);
            if (!AO_PROPERTY_TYPE_PROPERTYOWNER.equals(this.configurationTypes.get(propkey))) continue;
            try {
                PropertyOwner propowner = (PropertyOwner)Class.forName(syspropval).newInstance();
                String[] ownedprops = propowner.getPropertyNames();
                for (int i = 0; i < ownedprops.length; ++i) {
                    String ownedsyspropval;
                    String ownedpropkey = ownedprops[i];
                    String ownedpropval = propowner.getPropertyDefault(ownedpropkey);
                    String ownedproptype = propowner.getPropertyType(ownedpropkey);
                    String ownedproplabel = propowner.getPropertyLabel(ownedpropkey);
                    if (ownedpropkey == null || ownedpropval == null || ownedproptype == null || ownedproplabel == null) continue;
                    if (!this.configurationTypes.containsKey(ownedpropkey)) {
                        this.configurationTypes.put(ownedpropkey, ownedproptype);
                    }
                    if (!this.configurationLabels.containsKey(ownedpropkey)) {
                        this.configurationLabels.put(ownedpropkey, ownedproplabel);
                    }
                    if ((ownedsyspropval = System.getProperty(ownedpropkey)) != null && this.isPropertyValid(ownedpropkey, ownedsyspropval, this.configurationTypes)) {
                        currentConfiguration.put(ownedpropkey, ownedsyspropval);
                    }
                    if (this.configuration.containsKey(ownedpropkey)) continue;
                    this.configuration.put(ownedpropkey, ownedpropval);
                }
            }
            catch (Exception ex) {
                currentConfiguration = null;
            }
        }
        return currentConfiguration == null ? this.configuration : currentConfiguration;
    }

    private String _sysPropVal(String propkey) {
        String sysval = null;
        String dsyskey = null;
        String tsysval = null;
        if (propkey != null) {
            dsyskey = (String)deprecatedSysProperties.get(propkey);
            if (dsyskey != null && !dsyskey.equals("")) {
                sysval = System.getProperty(dsyskey);
            }
            if ((tsysval = System.getProperty(propkey)) != null && !tsysval.equals("")) {
                sysval = tsysval;
            }
        }
        return sysval;
    }

    private void initOwnedProperties() {
        Enumeration<Object> e = this.configuration.keys();
        while (e.hasMoreElements()) {
            String propkey = (String)e.nextElement();
            try {
                String proptype = this.getPropertyType(propkey);
                if (!AO_PROPERTY_TYPE_PROPERTYOWNER.equals(proptype)) continue;
                PropertyOwner propowner = (PropertyOwner)Class.forName(this.getProperty(propkey)).newInstance();
                String[] ownedprops = propowner.getPropertyNames();
                for (int i = 0; i < ownedprops.length; ++i) {
                    String ownedpropkey = ownedprops[i];
                    String ownedpropval = propowner.getPropertyDefault(ownedpropkey);
                    String ownedproptype = propowner.getPropertyType(ownedpropkey);
                    String ownedproplabel = propowner.getPropertyLabel(ownedpropkey);
                    if (ownedpropkey == null || ownedpropval == null || ownedproptype == null || ownedproplabel == null) continue;
                    this.configuration.put(ownedpropkey, ownedpropval);
                    this.configurationTypes.put(ownedpropkey, ownedproptype);
                    this.configurationLabels.put(ownedpropkey, ownedproplabel);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private boolean isPropertyValid(String propkey, String propval, Properties configurationTypes) {
        block13: {
            String proptype = (String)configurationTypes.get(propkey);
            if (AO_PROPERTY_TYPE_LIST.equals(proptype)) {
                return this.isListPropertyValid(propkey, propval, configurationTypes);
            }
            try {
                if (AO_PROPERTY_TYPE_PROPERTYOWNER.equals(proptype)) {
                    Class<?> cp = Class.forName(propval);
                    Class<?>[] ca = cp.getInterfaces();
                    for (int i = 0; i < ca.length; ++i) {
                        if (ca[i] != PropertyOwner.class) continue;
                        return true;
                    }
                    break block13;
                }
                if (AO_PROPERTY_TYPE_INTEGER.equals(proptype)) {
                    new Integer(propval);
                    return true;
                }
                if (AO_PROPERTY_TYPE_LONG.equals(proptype)) {
                    new Long(propval);
                    return true;
                }
                if (AO_PROPERTY_TYPE_BOOLEAN.equals(proptype)) {
                    Boolean.valueOf(propval);
                    return true;
                }
                if (!AO_PROPERTY_TYPE_STRING.equals(proptype)) break block13;
                try {
                    Method validatePropertyMethod = this.getClass().getMethod("validate_" + propkey, Class.forName(proptype));
                    return (Boolean)validatePropertyMethod.invoke((Object)this, propval) != false;
                }
                catch (NoSuchMethodException validatePropertyMethod) {
                }
                catch (IllegalArgumentException iae) {
                    return false;
                }
                catch (InvocationTargetException ite) {
                    return false;
                }
                catch (NullPointerException npe) {
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isListPropertyValid(String propkey, String propval, Properties configurationTypes) {
        if (propval.indexOf(AO_PROPERTY_LIST_SEPARATOR) != -1) {
            return false;
        }
        String valid_values = (String)configurationTypes.get(propkey + AO_PROPERTY_LIST_VALUES);
        return valid_values != null && valid_values.indexOf(propval, 0) != -1;
    }

    private void addOwnedProperties(String propval) {
        try {
            PropertyOwner propowner = (PropertyOwner)Class.forName(propval).newInstance();
            String[] ownedprops = propowner.getPropertyNames();
            for (int i = 0; i < ownedprops.length; ++i) {
                String ownedpropkey = ownedprops[i];
                String ownedpropval = propowner.getPropertyDefault(ownedpropkey);
                String ownedproptype = propowner.getPropertyType(ownedpropkey);
                String ownedproplabel = propowner.getPropertyLabel(ownedpropkey);
                if (ownedpropkey == null || ownedpropval == null || ownedproptype == null || ownedproplabel == null) continue;
                this.configurationTypes.put(ownedpropkey, ownedproptype);
                this.configurationLabels.put(ownedpropkey, ownedproplabel);
                if (this.configuration.containsKey(ownedpropkey)) continue;
                this.configuration.put(ownedpropkey, ownedpropval);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        deprecatedSysProperties.put("imqReconnectEnabled", "imqReconnect");
        deprecatedSysProperties.put("imqReconnectAttempts", "imqReconnectRetries");
        deprecatedSysProperties.put("imqReconnectInterval", "imqReconnectDelay");
        deprecatedSysProperties.put("imqConnectionFlowCount", "imqFlowControlCount");
        deprecatedSysProperties.put("imqConnectionFlowLimitEnabled", "imqFlowControlIsLimited");
        deprecatedSysProperties.put("imqConnectionFlowLimit", "imqFlowControlLimit");
        deprecatedProperties.put("imqReconnect", "imqReconnectEnabled");
        deprecatedProperties.put("imqReconnectRetries", "imqReconnectAttempts");
        deprecatedProperties.put("imqReconnectDelay", "imqReconnectInterval");
        deprecatedProperties.put("imqFlowControlCount", "imqConnectionFlowCount");
        deprecatedProperties.put("imqFlowControlIsLimited", "imqConnectionFlowLimitEnabled");
        deprecatedProperties.put("imqFlowControlLimit", "imqConnectionFlowLimit");
        cachedConfigurationMap = Collections.synchronizedMap(new HashMap());
    }
}

