/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.QueueBrowserImpl;
import com.sun.messaging.jmq.jmsclient.QueueReceiverImpl;
import com.sun.messaging.jmq.jmsclient.QueueSenderImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryQueueImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryTopicImpl;
import com.sun.messaging.jmq.jmsclient.TopicPublisherImpl;
import com.sun.messaging.jmq.jmsclient.TopicSubscriberImpl;
import com.sun.messaging.jms.Session;
import com.sun.messaging.jms.ra.api.JMSRAManagedConnection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import java.util.Enumeration;

public class UnifiedSessionImpl
extends SessionImpl
implements Session {
    public UnifiedSessionImpl(ConnectionImpl connection, boolean transacted, int ackMode) throws JMSException {
        super(connection, transacted, ackMode);
    }

    public UnifiedSessionImpl(ConnectionImpl connection, boolean transacted, int ackMode, JMSRAManagedConnection mc) throws JMSException {
        super(connection, transacted, ackMode, mc);
    }

    public UnifiedSessionImpl(ConnectionImpl connection, int ackMode) throws JMSException {
        super(connection, ackMode);
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        this.checkSessionState();
        return new BasicQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueReceiverImpl((SessionImpl)this, queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkSessionState();
        return new QueueReceiverImpl(this, queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueSenderImpl((SessionImpl)this, queue);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueBrowserImpl(this, queue);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkSessionState();
        return new QueueBrowserImpl(this, queue, messageSelector);
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionState();
        return new TemporaryQueueImpl(this.connection);
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        this.checkSessionState();
        return new BasicTopic(topicName);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkSessionState();
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkSessionState();
        return new TopicSubscriberImpl((SessionImpl)this, topic, messageSelector, noLocal);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkSessionState();
        this.checkTemporaryDestination(topic);
        this.checkClientIDWithBroker(true);
        return new TopicSubscriberImpl(this, topic, name, messageSelector, noLocal, false);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkSessionState();
        return new TopicPublisherImpl((SessionImpl)this, topic);
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionState();
        return new TemporaryTopicImpl(this.connection);
    }

    @Override
    public void unsubscribe(String name) throws JMSException {
        MessageConsumerImpl consumer = null;
        boolean deregistered = false;
        this.checkSessionState();
        Enumeration enum2 = this.consumers.elements();
        while (enum2.hasMoreElements()) {
            consumer = (MessageConsumerImpl)enum2.nextElement();
            if (!consumer.getDurable() || !consumer.getDurableName().equals(name)) continue;
            String errorString = AdministeredObject.cr.getKString("C4007", consumer.getDurableName());
            throw new JMSException(errorString, "C4007");
        }
        this.checkClientIDWithBroker(false);
        this.connection.unsubscribe(name);
        deregistered = true;
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination == null) {
            return new MessageProducerImpl(this, destination);
        }
        if (destination instanceof Queue) {
            return this.createSender((Queue)destination);
        }
        if (destination instanceof Topic) {
            return this.createPublisher((Topic)destination);
        }
        String errorString = AdministeredObject.cr.getKString("C4068", destination.getClass().getName());
        throw new JMSException(errorString, "C4068");
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        if (destination == null) {
            String errorString = AdministeredObject.cr.getKString("C4019", "null");
            throw new InvalidDestinationException(errorString, "C4019");
        }
        if (destination instanceof Queue) {
            return this.createReceiver((Queue)destination, messageSelector);
        }
        if (destination instanceof Topic) {
            return this.createSubscriber((Topic)destination, messageSelector, NoLocal);
        }
        String errorString = AdministeredObject.cr.getKString("C4068", destination.getClass().getName());
        throw new JMSException(errorString, "C4068");
    }

    private void checkClientIDWithBroker(boolean clientIDRequired) throws JMSException {
        String clientID = this.connection.getClientID();
        if (clientIDRequired && clientID == null) {
            String errorString = AdministeredObject.cr.getKString("C4053", "\"\"");
            throw new IllegalStateException(errorString, "C4053");
        }
        if (clientID != null && !this.connection.getProtocolHandler().isClientIDsent()) {
            this.connection.getProtocolHandler().setClientID(clientID);
        }
    }

    protected void checkTemporaryDestination(Topic topic) throws JMSException {
        if (topic == null || topic instanceof TemporaryTopic) {
            String errorString = AdministeredObject.cr.getKString("C4050", topic == null ? "" : topic.getTopicName());
            throw new InvalidDestinationException(errorString, "C4050");
        }
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        this.checkSessionState();
        this.checkTemporaryDestination(topic);
        if (sharedSubscriptionName == null || sharedSubscriptionName.trim().length() == 0) {
            String errorString = AdministeredObject.cr.getKString("C4316", "" + sharedSubscriptionName);
            JMSException jmse = new JMSException(errorString, "C4316");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.checkClientIDWithBroker(false);
        return new TopicSubscriberImpl((SessionImpl)this, topic, messageSelector, sharedSubscriptionName);
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name);
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        this.checkSessionState();
        this.checkTemporaryDestination(topic);
        this.checkClientIDWithBroker(false);
        return new TopicSubscriberImpl(this, topic, name, messageSelector, false, true);
    }
}

