/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.jmsclient.XAResourceForMC;
import com.sun.messaging.jmq.jmsclient.XAResourceMap;
import com.sun.messaging.jmq.jmsclient.XAResourceMapForRAMC;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.api.JMSRAOnMessageRunner;
import com.sun.messaging.jms.ra.api.JMSRAResourceAdapter;
import jakarta.jms.JMSException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForRA
implements XAResource,
XAResourceForJMQ {
    private ConnectionImpl epConnection;
    private int transactionTimeout = 0;
    private JMSRAOnMessageRunner omr;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    private boolean setRollback = false;
    private Exception rollbackCause = null;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    private int resourceState = 0;
    private static Hashtable xaTable = new Hashtable();
    public static final Integer XA_START = 0;
    public static final Integer XA_END = 1;
    public static final Integer XA_PREPARE = 2;
    public static final boolean turnOffXATracking = Boolean.getBoolean("imq.ra.turnOffXATracking");
    public static final boolean XATracking = !turnOffXATracking;
    private static final transient String _className = "com.sun.messaging.jmq.jmsclient.XAResourceForRA";
    private static final transient String _lgrName = "com.sun.messaging.jmq.jmsclient.XAResourceForRA";
    private static final transient Logger _logger = Logger.getLogger("com.sun.messaging.jmq.jmsclient.XAResourceForRA");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_XARMC";
    private static final transient String _lgrMID_EET = "MQJMSRA_XARMC1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_XARMC1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_XARMC2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_XARMC3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_XARMC4001: ";

    public XAResourceForRA(JMSRAOnMessageRunner omr, ConnectionImpl epConnection) throws JMSException {
        this.omr = omr;
        this.id = omr.getId();
        this.epConnection = epConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit(Xid foreignXid, boolean onePhase) throws XAException {
        XAException xae;
        Exception rbrollbackex;
        boolean rbrollback;
        JMQXid jmqXid;
        block29: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Commit  " + this.printXid(foreignXid) + " (onePhase=" + onePhase + ")");
            }
            jmqXid = new JMQXid(foreignXid);
            if (onePhase && this.setRollback) {
                Debug.printStackTrace(this.rollbackCause);
                XAException xae2 = new XAException(-7);
                xae2.initCause(this.rollbackCause);
                throw xae2;
            }
            boolean checkrollback = false;
            rbrollback = false;
            rbrollbackex = null;
            try {
                if (!this.epConnection._isClosed()) {
                    if (onePhase) {
                        if (this.epConnection.isConnectedToHABroker()) {
                            this.HAOnePhaseCommit(foreignXid, jmqXid);
                            break block29;
                        }
                        try {
                            this.epConnection.getProtocolHandler().commit(0L, 0x40000000, jmqXid);
                            break block29;
                        }
                        catch (JMSException e) {
                            checkrollback = true;
                            throw e;
                        }
                    }
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HATwoPhaseCommit(jmqXid);
                    } else {
                        this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid);
                    }
                    break block29;
                }
                System.err.println("MQRA:XARFRA:commit:ConnectionClosed:throw XAExc txn:1p=" + onePhase + ":xid=" + jmqXid.toString());
                XAException xae3 = new XAException(-7);
                throw xae3;
            }
            catch (Exception jmse) {
                Exception e1;
                if (jmse instanceof RemoteAcknowledgeException) {
                    RemoteAcknowledgeException rae = (RemoteAcknowledgeException)jmse;
                    XASessionImpl session = (XASessionImpl)this.omr.getEndpointConsumer().getXASession();
                    session.notifyRemoteAcknowledgeException(rae);
                    if (checkrollback) {
                        rbrollbackex = jmse;
                        rbrollback = true;
                    }
                }
                this.epConnection.waitForReconnecting(jmse);
                Debug.printStackTrace(jmse);
                if (!rbrollback && checkrollback && jmse instanceof JMSException && ((JMSException)jmse).getErrorCode().equals("C4036") && (e1 = ((JMSException)jmse).getLinkedException()) != null && e1 instanceof JMSException && !((JMSException)e1).getErrorCode().equals(Status.getString(404))) {
                    SessionImpl.sessionLogger.log(Level.WARNING, "Exception on 1-phase commit transaction " + jmqXid + ", will rollback", jmse);
                    rbrollbackex = jmse;
                    rbrollback = true;
                }
                if (!rbrollback) {
                    XAException xae4 = new XAException(-7);
                    xae4.initCause(jmse);
                    throw xae4;
                }
            }
            finally {
                if (!rbrollback) {
                    boolean throwExceptionIfNotFound = false;
                    JMQXid savedXid = this.jmqXid;
                    XAResourceForJMQ[] resources = XAResourceMapForRAMC.getXAResources(this.jmqXid, throwExceptionIfNotFound);
                    for (int i = 0; i < resources.length; ++i) {
                        XAResourceForJMQ xari = resources[i];
                        try {
                            xari.clearTransactionInfo();
                            continue;
                        }
                        catch (JMSException jmse) {
                            Debug.printStackTrace(jmse);
                            XAException xae5 = new XAException(-7);
                            xae5.initCause(jmse);
                            throw xae5;
                        }
                    }
                    XAResourceMapForRAMC.unregister(savedXid);
                }
            }
        }
        if (!rbrollback) {
            this.removeXid(jmqXid);
            return;
        }
        try {
            this.rollback(foreignXid, XAResourceMap.MAXROLLBACKS, XAResourceMap.DMQ_ON_MAXROLLBACKS);
            xae = new XAException(100);
            xae.initCause(rbrollbackex);
        }
        catch (Exception e) {
            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + jmqXid + " after 1-phase-commit failure", e);
            xae = new XAException(-7);
            xae.initCause(rbrollbackex);
        }
        throw xae;
    }

    @Override
    public synchronized void end(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForRA (" + this.hashCode() + ") End     " + this.printXid(foreignXid) + this.printFlags(flags));
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (this.epConnection._isClosed()) {
            XAException xae = new XAException(-7);
            throw xae;
        }
        this.resourceState = this.isFail(flags) ? 2 : (this.isSuspend(flags) ? 3 : 4);
        if (JMSRAResourceAdapter.isRevert6882044()) {
            this.sendEndToBroker(flags, false, jmqXid);
        } else if (this.resourceState == 4) {
            boolean allComplete = true;
            XAResourceForJMQ[] resources = XAResourceMapForRAMC.getXAResources(jmqXid, true);
            for (int i = 0; i < resources.length; ++i) {
                XAResourceForJMQ xari = resources[i];
                if (xari.isComplete()) continue;
                allComplete = false;
            }
            if (allComplete) {
                this.sendEndToBroker(flags, false, jmqXid);
            } else {
                this.sendEndToBroker(flags, true, jmqXid);
            }
        } else if (this.resourceState == 2) {
            this.sendEndToBroker(flags, false, jmqXid);
        } else if (this.resourceState == 3) {
            // empty if block
        }
        this.started = false;
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XA_END);
        }
    }

    private void sendEndToBroker(int flags, boolean jmqnoop, JMQXid jmqXid) throws XAException {
        try {
            this.epConnection.getProtocolHandler().endTransaction(0L, jmqnoop, flags, jmqXid);
        }
        catch (JMSException jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
    }

    public synchronized void _endLocal() throws XAException {
        try {
            this.epConnection.getProtocolHandler().commit(this.transactionID, 0, null);
        }
        catch (JMSException jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.started = false;
    }

    @Override
    public void forget(Xid foreignXid) throws XAException {
        XidImpl xidToForget = new XidImpl(foreignXid);
        XAResourceMapForRAMC.unregister(xidToForget);
        if (this.jmqXid != null && this.jmqXid.equals(xidToForget)) {
            this.clearTransactionInfo();
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource foreignXaRes) throws XAException {
        if (foreignXaRes instanceof XAResourceForMC || foreignXaRes instanceof XAResourceForRA) {
            return this.isSameJMQRM((XAResourceForJMQ)((Object)foreignXaRes));
        }
        return false;
    }

    @Override
    public boolean isSameJMQRM(XAResourceForJMQ xaResource) {
        boolean result = JMSRAResourceAdapter.isSameRMAllowed() ? this.getBrokerSessionID() != 0L && this.getBrokerSessionID() == xaResource.getBrokerSessionID() : false;
        return result;
    }

    @Override
    public long getBrokerSessionID() {
        return this.epConnection.getBrokerSessionID();
    }

    public synchronized int prepare(Xid foreignXid, boolean onePhase) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForRA (" + this.hashCode() + ") Prepare     " + this.printXid(foreignXid));
        }
        int result = 0;
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (this.setRollback) {
            Debug.printStackTrace(this.rollbackCause);
            XAException xae = new XAException(-7);
            xae.initCause(this.rollbackCause);
            throw xae;
        }
        try {
            if (this.epConnection._isClosed()) {
                XAException xae = new XAException(-7);
                throw xae;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jmqXid, onePhase);
        }
        catch (Exception jmse) {
            if (jmse instanceof RemoteAcknowledgeException) {
                RemoteAcknowledgeException rae = (RemoteAcknowledgeException)jmse;
                ((XASessionImpl)this.omr.getEndpointConsumer().getXASession()).notifyRemoteAcknowledgeException(rae);
            }
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.resourceState = 5;
        return result;
    }

    @Override
    public synchronized int prepare(Xid foreignXid) throws XAException {
        int result = 0;
        try {
            this.prepare(foreignXid, false);
        }
        catch (XAException xae) {
            if (this.epConnection.isConnectedToHABroker) {
                this.checkPrepareStatus(xae, this.jmqXid);
            }
            throw xae;
        }
        if (this.isXATracking()) {
            xaTable.put(this.jmqXid, XA_PREPARE);
        }
        return result;
    }

    private void HAOnePhaseCommit(Xid foreignXid, JMQXid jmqXid) throws JMSException, XAException {
        int tstate = 1;
        try {
            this.prepare(foreignXid, true);
            tstate = 2;
            if (this.isXATracking()) {
                xaTable.put(jmqXid, XA_PREPARE);
            }
            this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid, true);
        }
        catch (Exception jmse) {
            this.checkCommitStatus(jmse, tstate, jmqXid, true);
        }
        this.removeXid(jmqXid);
    }

    private void HATwoPhaseCommit(JMQXid jmqXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer ts = (Integer)xaTable.get(jmqXid);
                if (ts != null && ts == 2) {
                    this.checkCommitStatus(jmse, 2, jmqXid, false);
                }
            }
            throw jmse;
        }
        this.removeXid(jmqXid);
    }

    private void checkPrepareStatus(XAException xae, JMQXid jmqXid) throws XAException {
        if (!this.epConnection.imqReconnect) {
            throw xae;
        }
        try {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw xae;
            }
            this.verifyPrepare(jmqXid);
        }
        catch (XAException xae2) {
            throw xae2;
        }
        catch (Exception e) {
            XAException xae3 = new XAException(-7);
            xae3.initCause(e);
            throw xae3;
        }
    }

    private void verifyPrepare(JMQXid jmqXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jmqXid);
        int state = this.epConnection.protocolHandler.verifyHATransaction(0L, 1, jmqXid);
        switch (state) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + this.transactionID);
                return;
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    private void checkCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(cause, tstate, jmqXid, onePhase);
        }
        catch (Exception ex) {
            if (ex instanceof JMSException) {
                throw (JMSException)ex;
            }
            if (ex instanceof XAException) {
                throw (XAException)ex;
            }
            XAException xae = new XAException(-7);
            xae.initCause(ex);
            throw xae;
        }
    }

    private void doCheckCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws Exception {
        if (!this.epConnection.imqReconnect) {
            throw cause;
        }
        SessionImpl.yield();
        this.epConnection.checkReconnecting(null);
        if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
            throw cause;
        }
        this.verifyTransaction(tstate, jmqXid, onePhase);
    }

    private void verifyTransaction(int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        int state = this.epConnection.protocolHandler.verifyHATransaction(0L, tstate, jmqXid);
        switch (state) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid, onePhase);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jmse) {
                    SessionImpl.yield();
                    this.epConnection.checkReconnecting(null);
                    throw jmse;
                }
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        Xid[] result = null;
        try {
            if (this.epConnection._isClosed()) {
                XAException xae = new XAException(-7);
                throw xae;
            }
            result = this.epConnection.getProtocolHandler().recover(flags);
        }
        catch (Exception jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        return result;
    }

    @Override
    public synchronized void rollback(Xid foreignXid) throws XAException {
        this.rollback(foreignXid, -1, false);
    }

    private synchronized void rollback(Xid foreignXid, int maxRollbacks, boolean dmqOnMaxRollbacks) throws XAException {
        JMQXid jmqXid;
        block14: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Rollback  " + this.printXid(foreignXid) + ")");
            }
            jmqXid = new JMQXid(foreignXid);
            try {
                if (!this.epConnection._isClosed()) {
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HARollback(jmqXid, maxRollbacks, dmqOnMaxRollbacks);
                    } else {
                        this.epConnection.getProtocolHandler().rollbackXA(0L, jmqXid, true, false, maxRollbacks, dmqOnMaxRollbacks);
                    }
                    break block14;
                }
                XAException xae = new XAException(-7);
                throw xae;
            }
            catch (JMSException jmse) {
                Debug.printStackTrace(jmse);
                XAException xae = new XAException(-7);
                xae.initCause(jmse);
                throw xae;
            }
            finally {
                boolean throwExceptionIfNotFound = false;
                JMQXid savedXid = this.jmqXid;
                XAResourceForJMQ[] resources = XAResourceMapForRAMC.getXAResources(this.jmqXid, throwExceptionIfNotFound);
                for (int i = 0; i < resources.length; ++i) {
                    XAResourceForJMQ xari = resources[i];
                    try {
                        xari.clearTransactionInfo();
                        continue;
                    }
                    catch (JMSException jmse) {
                        Debug.printStackTrace(jmse);
                        XAException xae = new XAException(-7);
                        xae.initCause(jmse);
                        throw xae;
                    }
                }
                XAResourceMapForRAMC.unregister(savedXid);
            }
        }
        this.removeXid(jmqXid);
    }

    private void HARollback(JMQXid jmqXid, int maxRollbacks, boolean dmqOnMaxRollbacks) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollbackXA(0L, jmqXid, true, false, maxRollbacks, dmqOnMaxRollbacks);
        }
        catch (JMSException jmse) {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw jmse;
            }
            this.retryRollBack(jmqXid, maxRollbacks, dmqOnMaxRollbacks);
        }
        this.removeXid(jmqXid);
    }

    private void retryRollBack(JMQXid jmqXid, int maxRollbacks, boolean dmqOnMaxRollbacks) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollbackXA(0L, jmqXid, true, true, maxRollbacks, dmqOnMaxRollbacks);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer tstate = (Integer)xaTable.get(jmqXid);
                if (tstate != null && tstate != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jmse.toString());
                }
                throw jmse;
            }
            throw jmse;
        }
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        return false;
    }

    @Override
    public synchronized void start(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForRA (" + this.hashCode() + ") Start   " + this.printXid(foreignXid) + this.printFlags(flags));
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (!this.isResume(flags) || JMSRAResourceAdapter.isRevert6882044()) {
            try {
                if (this.epConnection._isClosed()) {
                    XAException xae = new XAException(-7);
                    throw xae;
                }
                this.transactionID = this.epConnection.getProtocolHandler().startTransaction(this.transactionID, flags, jmqXid);
                this.jmqXid = jmqXid;
            }
            catch (JMSException jmse) {
                Debug.printStackTrace(jmse);
                XAException xae = new XAException(-7);
                xae.initCause(jmse);
                throw xae;
            }
            XAResourceMapForRAMC.register(jmqXid, this, this.isJoin(flags));
        }
        this.started = true;
        this.resourceState = 1;
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XA_START);
        }
    }

    public synchronized void _startLocal() throws XAException {
        try {
            this.transactionID = this.epConnection.protocolHandler.startTransaction(-1L, 0, null);
        }
        catch (JMSException jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.started = true;
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public void setRollback(boolean value, Exception cause) {
        this.setRollback = value;
        this.rollbackCause = cause;
    }

    @Override
    public boolean isComplete() {
        return this.resourceState == 4;
    }

    @Override
    public void clearTransactionInfo() {
        this.resourceState = 0;
    }

    private boolean isXATracking() {
        return this.epConnection.isConnectedToHABroker() && XATracking;
    }

    private void removeXid(JMQXid jmqXid) {
        if (this.isXATracking()) {
            xaTable.remove(jmqXid);
        }
    }

    private boolean isJoin(int flags) {
        return (flags & 0x200000) == 0x200000;
    }

    private boolean isResume(int flags) {
        return (flags & 0x8000000) == 0x8000000;
    }

    private boolean isFail(int flags) {
        return (flags & 0x20000000) == 0x20000000;
    }

    private boolean isSuspend(int flags) {
        return (flags & 0x2000000) == 0x2000000;
    }

    private String printXid(Xid foreignXid) {
        return "(GlobalTransactionID=" + foreignXid.getGlobalTransactionId() + ", BranchQualifier=" + foreignXid.getBranchQualifier() + ") ";
    }

    private String printFlags(int flags) {
        String result = "(Flags: ";
        if (this.isJoin(flags)) {
            result = result + "JOIN ";
        }
        if (this.isNoFlags(flags)) {
            result = result + "TMNOFLAGS ";
        }
        if (this.isFail(flags)) {
            result = result + "TMFAIL ";
        }
        if (this.isOnePhase(flags)) {
            result = result + "TMONEPHASE ";
        }
        if (this.isResume(flags)) {
            result = result + "TMRESUME ";
        }
        if (this.isSuccess(flags)) {
            result = result + "TMSUCCESS ";
        }
        if (this.isSuspend(flags)) {
            result = result + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(flags)) {
            result = result + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(flags)) {
            result = result + "TMSTARTRSCAN ";
        }
        result = result + ")";
        return result;
    }

    private boolean isNoFlags(int flags) {
        return (flags & 0) == 0;
    }

    private boolean isOnePhase(int flags) {
        return (flags & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int flags) {
        return (flags & 0x4000000) == 0x4000000;
    }

    private boolean isTMENDRSCAN(int flags) {
        return (flags & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int flags) {
        return (flags & 0x1000000) == 0x1000000;
    }
}

