/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public abstract class MultiColumnPrinter
implements Serializable {
    private static final long serialVersionUID = -8013528725857861640L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    private static final boolean DEFAULT_SORT = true;
    private static final int DEFAULT_NUMCOL = 2;
    private static final int DEFAULT_GAP = 4;
    private int numCol = 2;
    private int gap = 4;
    private int align = 1;
    private int titleAlign = 1;
    private String border = null;
    private int indent = 0;
    private Vector<Object[]> table = new Vector();
    private Vector<String[]> titleTable = new Vector();
    private Vector<int[]> titleSpanTable = new Vector();
    private int[] curLength;
    private boolean sortNeeded = true;
    private int[] keyCriteria = null;

    public MultiColumnPrinter() {
        this(2, 4);
    }

    public MultiColumnPrinter(int numCol, int gap, String border, int align, boolean sort) {
        this.curLength = new int[numCol];
        this.numCol = numCol;
        this.gap = gap;
        this.border = border;
        this.align = align;
        this.titleAlign = 0;
        this.sortNeeded = sort;
    }

    public MultiColumnPrinter(int numCol, int gap, String border, int align) {
        this(numCol, gap, border, align, true);
    }

    public MultiColumnPrinter(int numCol, int gap, String border) {
        this(numCol, gap, border, 0);
    }

    public MultiColumnPrinter(int numCol, int gap) {
        this(numCol, gap, null, 0);
    }

    public void setNumCol(int n) {
        this.numCol = n;
        this.curLength = new int[this.numCol];
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public void setBorder(String b) {
        this.border = b;
    }

    public void copy(MultiColumnPrinter mcp) {
        this.numCol = mcp.numCol;
        this.gap = mcp.gap;
        this.align = mcp.align;
        this.titleAlign = mcp.titleAlign;
        this.border = mcp.border;
        this.indent = mcp.indent;
        this.table = mcp.table;
        this.titleTable = mcp.titleTable;
        this.titleSpanTable = mcp.titleSpanTable;
        this.curLength = mcp.curLength;
        this.sortNeeded = mcp.sortNeeded;
        this.keyCriteria = mcp.keyCriteria;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setSortNeeded(boolean sortNeeded) {
        this.sortNeeded = sortNeeded;
    }

    public void addTitle(String[] row) {
        if (row == null) {
            return;
        }
        int[] span = new int[row.length];
        for (int i = 0; i < row.length; ++i) {
            span[i] = 1;
        }
        this.addTitle(row, span);
    }

    public void addTitle(String[] row, int[] span) {
        String[] rowInstance = new String[row.length];
        System.arraycopy(row, 0, rowInstance, 0, row.length);
        this.titleTable.addElement(rowInstance);
        this.titleSpanTable.addElement(span);
    }

    public void setTitleAlign(int titleAlign) {
        this.titleAlign = titleAlign;
    }

    public void add(Object[] row) {
        Object[] rowInstance = new Object[row.length];
        System.arraycopy(row, 0, rowInstance, 0, row.length);
        this.table.addElement(rowInstance);
    }

    public void clearTitle() {
        this.titleTable.clear();
        this.titleSpanTable.clear();
    }

    public void clear() {
        this.table.clear();
        if (this.curLength != null) {
            for (int i = 0; i < this.curLength.length; ++i) {
                this.curLength[i] = 0;
            }
        }
    }

    public void print() {
        this.print(true);
    }

    public void print(boolean printTitle) {
        Object[] row;
        int i;
        Enumeration<String[]> e = this.titleTable.elements();
        Enumeration<int[]> spanEnum = this.titleSpanTable.elements();
        int rowNum = 0;
        while (e.hasMoreElements()) {
            String[] row2 = e.nextElement();
            int[] curSpan = spanEnum.nextElement();
            for (i = 0; i < this.numCol; ++i) {
                if (row2[i] == null) {
                    row2[i] = "-";
                }
                int len = this.getItemLength(row2[i]);
                int span = curSpan[i];
                int rem = 0;
                if (span > 1) {
                    rem = len % span;
                    len /= span;
                }
                if (this.curLength[i] >= len) continue;
                this.curLength[i] = len;
                if (span <= 1 || i + span > this.numCol) continue;
                for (int j = i + 1; j < i + span; ++j) {
                    this.curLength[j] = len;
                }
                int n = i + span - 1;
                this.curLength[n] = this.curLength[n] + rem;
            }
            ++rowNum;
        }
        Enumeration<Object[]> rows = this.table.elements();
        while (rows.hasMoreElements()) {
            row = rows.nextElement();
            for (i = 0; i < this.numCol; ++i) {
                int itemLen;
                if (row[i] == null) {
                    row[i] = "-";
                }
                if (this.curLength[i] >= (itemLen = this.getItemLength(row[i]))) continue;
                this.curLength[i] = itemLen;
            }
        }
        if (printTitle) {
            this.printBorder();
            e = this.titleTable.elements();
            spanEnum = this.titleSpanTable.elements();
            this.printSpaces(this.indent);
            while (e.hasMoreElements()) {
                row = e.nextElement();
                int[] curSpan = spanEnum.nextElement();
                for (int i2 = 0; i2 < this.numCol; ++i2) {
                    int availableSpace = 0;
                    int span = curSpan[i2];
                    int itemLen = this.getItemLength(row[i2]);
                    if (span == 0) continue;
                    availableSpace = this.curLength[i2];
                    if (span > 1 && i2 + span <= this.numCol) {
                        for (int j = i2 + 1; j < i2 + span; ++j) {
                            availableSpace += this.gap;
                            availableSpace += this.curLength[j];
                        }
                    }
                    if (this.titleAlign == 1) {
                        int space_before = (availableSpace - itemLen) / 2;
                        int space_after = availableSpace - itemLen - space_before;
                        this.printSpaces(space_before);
                        this.doPrint(this.getItemString(row[i2]));
                        this.printSpaces(space_after);
                        if (i2 >= this.numCol - 1) continue;
                        this.printSpaces(this.gap);
                        continue;
                    }
                    this.doPrint(this.getItemString(row[i2]));
                    if (i2 >= this.numCol - 1) continue;
                    this.printSpaces(availableSpace - itemLen + this.gap);
                }
                this.doPrintln("");
            }
            this.printBorder();
        }
        if (this.sortNeeded) {
            this.printSortedTable();
        } else {
            this.printUnsortedTable();
        }
    }

    private void printSortedTable() {
        TreeMap<Object, Object[]> sortedTable = new TreeMap<Object, Object[]>();
        Enumeration<Object[]> e = this.table.elements();
        while (e.hasMoreElements()) {
            Object[] row = e.nextElement();
            if (this.keyCriteria != null && this.keyCriteria.length > 0) {
                String key = this.getKey(row);
                if (key != null) {
                    sortedTable.put(key, row);
                    continue;
                }
                sortedTable.put(row[0], row);
                continue;
            }
            sortedTable.put(row[0], row);
        }
        for (Map.Entry entry : sortedTable.entrySet()) {
            this.printRow((Object[])entry.getValue());
        }
    }

    private String getKey(Object[] row) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < this.keyCriteria.length; ++i) {
            int content = this.keyCriteria[i];
            try {
                key.append(this.getItemString(row[content]));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                return null;
            }
        }
        return key.toString();
    }

    private void printUnsortedTable() {
        Enumeration<Object[]> e = this.table.elements();
        while (e.hasMoreElements()) {
            Object[] row = e.nextElement();
            this.printRow(row);
        }
    }

    private void printRow(Object[] row) {
        int itemOffset = 0;
        this.printSpaces(this.indent);
        itemOffset += this.indent;
        boolean needLineFeed = true;
        for (int i = 0; i < this.numCol; ++i) {
            int itemLen = this.getItemLength(row[i]);
            if (this.align == 1) {
                int space1 = (this.curLength[i] - itemLen) / 2;
                int space2 = this.curLength[i] - itemLen - space1;
                this.printSpaces(space1);
                needLineFeed = this.printObject(row[i], itemOffset += space1);
                itemOffset += itemLen;
                this.printSpaces(space2);
                itemOffset += space2;
                if (i >= this.numCol - 1) continue;
                this.printSpaces(this.gap);
                itemOffset += this.gap;
                continue;
            }
            needLineFeed = this.printObject(row[i], itemOffset);
            itemOffset += itemLen;
            if (i >= this.numCol - 1) continue;
            this.printSpaces(this.curLength[i] - itemLen + this.gap);
            itemOffset += this.curLength[i] - itemLen + this.gap;
        }
        if (needLineFeed) {
            this.doPrintln("");
        }
    }

    public void println() {
        this.print();
        this.doPrintln("");
    }

    private void printSpaces(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(" ");
        }
        this.doPrint(sb.toString());
    }

    private void printBorder() {
        int j;
        int i;
        if (this.border == null) {
            return;
        }
        this.printSpaces(this.indent);
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.numCol; ++i) {
            for (j = 0; j < this.curLength[i]; ++j) {
                sb.append(this.border);
            }
        }
        this.doPrint(sb.toString());
        sb.setLength(0);
        for (i = 0; i < this.numCol - 1; ++i) {
            for (j = 0; j < this.gap; ++j) {
                sb.append(this.border);
            }
        }
        this.doPrintln(sb.toString());
    }

    private String getItemString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        String tmp = obj.getClass().getName();
        return tmp;
    }

    private int getItemLength(Object obj) {
        int len = 0;
        if (obj instanceof String) {
            len = ((String)obj).length();
        } else {
            String tmp = obj.getClass().getName();
            len = tmp.length();
        }
        return len;
    }

    public boolean printObject(Object obj, int indent) {
        if (obj instanceof String) {
            this.doPrint((String)obj);
        } else {
            String className = obj.getClass().getName();
            this.doPrintln(className);
            this.printSpaces(indent);
            this.doPrint(obj.toString());
        }
        return true;
    }

    public void setKeyCriteria(int[] criteria) {
        this.keyCriteria = criteria;
    }

    public abstract void doPrint(String var1);

    public abstract void doPrintln(String var1);
}

