/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandlerImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public class AsyncStompOutputHandler
implements StompOutputHandler {
    private Logger _logger = null;
    private FilterChainContext _context = null;
    private StompProtocolHandler _sph = null;
    private StompBridgeResources _sbr = null;

    @Deprecated
    public AsyncStompOutputHandler(FilterChainContext ctx, StompProtocolHandlerImpl sph, BridgeContext bc) {
        this(ctx, sph);
    }

    public AsyncStompOutputHandler(FilterChainContext ctx, StompProtocolHandlerImpl sph) {
        this._context = ctx;
        this._sbr = sph.getStompBridgeResources();
        this._logger = sph.getLogger();
        this._sph = sph;
    }

    @Override
    public void sendToClient(StompFrameMessage msg, StompProtocolHandler sph, Object ctx) throws Exception {
        throw new UnsupportedOperationException("sendToClient(msg, ctx, sph)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToClient(StompFrameMessage msg) throws Exception {
        boolean closechannel = false;
        if (msg.getCommand() == StompFrameMessage.Command.ERROR && msg.isFatalERROR()) {
            closechannel = true;
        }
        try {
            this._context.write((Object)msg, true);
        }
        catch (Exception e) {
            if (e instanceof ClosedChannelException || e.getCause() instanceof ClosedChannelException) {
                StompBridgeResources stompBridgeResources = StompServer.getStompBridgeResources();
                StompServer.getStompBridgeResources();
                this._logger.log(Level.WARNING, stompBridgeResources.getKString("BSS2000", msg.toString(), e.toString()));
                this._sph.close(true);
                throw e;
            }
        }
        finally {
            if (closechannel) {
                GrizzlyFuture<Closeable> f = this._context.getConnection().close();
                try {
                    f.get();
                }
                catch (Exception ee) {
                    this._logger.log(Level.WARNING, ee.getMessage(), ee);
                }
            }
        }
    }
}

