/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class ClusterTransferFileStartInfo {
    private static boolean DEBUG = false;
    private GPacket pkt = null;
    private String uuid = null;
    private String module = null;
    private String brokerID = null;
    private String filename = null;
    private long filesize = 0L;
    private long lastmodtime = 0L;

    private ClusterTransferFileStartInfo(String uuid, String module, String brokerID, String filename, long filesize, long lastmodtime) {
        this.uuid = uuid;
        this.brokerID = brokerID;
        this.module = module;
        this.filename = filename;
        this.filesize = filesize;
        this.lastmodtime = lastmodtime;
    }

    private ClusterTransferFileStartInfo(GPacket pkt) {
        assert (pkt.getType() == 67);
        this.pkt = pkt;
    }

    public static ClusterTransferFileStartInfo newInstance(String uuid, String module, String brokerID, String filename, long filesize, long lastmodtime) {
        return new ClusterTransferFileStartInfo(uuid, module, brokerID, filename, filesize, lastmodtime);
    }

    public static ClusterTransferFileStartInfo newInstance(GPacket pkt) {
        return new ClusterTransferFileStartInfo(pkt);
    }

    public GPacket getGPacket() throws BrokerException {
        if (this.pkt != null) {
            return this.pkt;
        }
        GPacket gp = GPacket.getInstance();
        gp.putProp("uuid", this.uuid);
        gp.putProp("module", this.module);
        gp.putProp("brokerID", this.brokerID);
        gp.putProp("filename", this.filename);
        gp.putProp("filesize", this.filesize);
        gp.putProp("lastModifiedTime", this.lastmodtime);
        gp.setType((short)67);
        gp.setBit(1, false);
        return gp;
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("uuid");
    }

    public String getModule() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("module");
    }

    public String getBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("brokerID");
    }

    public String getFileName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("filename");
    }

    public long getFileSize() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("filesize");
    }

    public long getLastModifiedTime() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("lastModifiedTime");
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        if (this.pkt != null) {
            return "[brokerID=" + this.getBrokerID() + ", file=" + this.getFileName() + "]" + this.getUUID() + (verbose ? "(" + this.getModule() + ")" : "");
        }
        return "[brokerID=" + this.brokerID + ", file=" + this.filename + "]" + this.uuid + (verbose ? "(" + this.module + ")" : "");
    }
}

