/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.disk.VRFileRAF;
import com.sun.messaging.jmq.io.disk.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkFactory;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.PreparedTxnStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;

class TransactionWorkInfo {
    static final short PENDING = -1;
    static final short DONE = 0;
    private static final int BYTE_SIZE = 1;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int ENTRY_SIZE = 12;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private BaseTransaction msg;
    private TransactionUID tid;
    private int txnDataSize;
    private PreparedTxnStore parent = null;
    private VRecordRAF vrecord = null;

    @Deprecated
    TransactionWorkInfo(PreparedTxnStore p, byte[] data, byte[] ilist) throws IOException {
        this(p, data);
    }

    TransactionWorkInfo(PreparedTxnStore p, byte[] data) throws IOException {
        this.parent = p;
        try {
            BaseTransaction txnWork;
            this.msg = txnWork = TransactionWorkFactory.readFromBytes(data);
            this.tid = txnWork.getTid();
        }
        catch (BrokerException be) {
            be.printStackTrace();
            throw new IOException(be.getMessage());
        }
        catch (IOException e) {
            this.logger.log(32, this.parent.storeName + ":failed to parse message from byte array", e);
            throw e;
        }
    }

    TransactionWorkInfo(PreparedTxnStore p, VRecordRAF r) throws IOException {
        this.parent = p;
        this.vrecord = r;
        try {
            BaseTransaction txnWork;
            this.msg = txnWork = this.parseTransactionWork(r);
            this.tid = txnWork.getTid();
        }
        catch (IOException e) {
            this.parent.getVRFile().free(this.vrecord);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionWorkInfo(PreparedTxnStore p, VRFileRAF vrfile, BaseTransaction txnWork, byte[] databuf, boolean sync) throws IOException {
        VRFileRAF vRFileRAF;
        this.parent = p;
        this.tid = txnWork.getTid();
        this.txnDataSize = databuf.length;
        int bufsize = 4 + this.txnDataSize + 4;
        if (sync && Store.getDEBUG_SYNC()) {
            String msg = "TransactionWorkInfor sync() " + this.tid;
            this.logger.log(4, msg);
        }
        if (!Globals.isMinimumWritesFileStore()) {
            vRFileRAF = vrfile;
            synchronized (vRFileRAF) {
                this.vrecord = (VRecordRAF)vrfile.allocate(bufsize);
                this.vrecord.setCookie((short)-1);
                this.vrecord.writeInt(this.txnDataSize);
                this.vrecord.write(databuf);
                this.vrecord.setCookie((short)0);
                if (sync) {
                    this.vrecord.force();
                }
            }
        }
        vRFileRAF = vrfile;
        synchronized (vRFileRAF) {
            ByteBuffer bbuf = ByteBuffer.allocate(bufsize + 4);
            bbuf.putShort((short)2);
            bbuf.putShort((short)0);
            bbuf.putInt(this.txnDataSize);
            bbuf.put(databuf);
            byte[] data = bbuf.array();
            this.vrecord = (VRecordRAF)vrfile.allocateAndWrite(bufsize, data);
            if (sync) {
                this.vrecord.force();
            }
        }
    }

    TransactionWorkInfo(PreparedTxnStore p, BaseTransaction txnWork, byte[] databuf, boolean sync) throws IOException {
        this.parent = p;
        this.tid = txnWork.getTid();
        if (databuf != null) {
            this.txnDataSize = databuf.length;
        }
        this.parent.writeData(this.tid, databuf, null, sync);
    }

    synchronized BaseTransaction getMessage() throws IOException {
        if (this.msg == null) {
            if (this.vrecord != null) {
                try {
                    return this.parseTransactionWork(this.vrecord);
                }
                catch (IOException e) {
                    this.logger.log(32, this.parent.storeName + ":failed to parse message from vrecord(" + this.vrecord + ")", e);
                    throw e;
                }
            }
            try {
                byte[] data = this.parent.loadData(this.tid);
                return this.parseTransactionWork(data);
            }
            catch (IOException e) {
                this.logger.log(32, this.parent.storeName + ":failed to parse message from byte array", e);
                throw e;
            }
        }
        BaseTransaction pkt = this.msg;
        this.msg = null;
        return pkt;
    }

    int getSize() {
        return this.txnDataSize;
    }

    TransactionUID getID() {
        return this.tid;
    }

    synchronized void free(boolean sync) throws IOException {
        if (sync && Store.getDEBUG_SYNC()) {
            String msg = "TransactionWorkInfo free sync() " + this.getID();
            this.logger.log(4, msg);
        }
        if (this.vrecord != null) {
            this.parent.getVRFile().free(this.vrecord);
            if (sync) {
                this.parent.getVRFile().force();
            }
            this.vrecord = null;
        } else {
            this.parent.removeData(this.tid, sync);
        }
        this.tid = null;
    }

    private BaseTransaction parseTransactionWork(byte[] data) throws IOException {
        try {
            BaseTransaction txnWork = TransactionWorkFactory.readFromBytes(data);
            return txnWork;
        }
        catch (Throwable t) {
            this.logger.log(32, this.parent.storeName + ":failed to parse message(size=" + this.txnDataSize + ") ", t);
            IOException e = new IOException(t.toString());
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
    }

    private BaseTransaction parseTransactionWork(VRecordRAF r) throws IOException {
        try {
            r.rewind();
            this.txnDataSize = r.readInt();
            byte[] data = new byte[this.txnDataSize];
            r.read(data);
            BaseTransaction txnWork = TransactionWorkFactory.readFromBytes(data);
            return txnWork;
        }
        catch (Throwable t) {
            this.logger.log(32, this.parent.storeName + ":failed to parse message(size=" + this.txnDataSize + ") from vrecord(" + r + ")", t);
            IOException e = new IOException(t.toString());
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
    }

    synchronized void updateState(int state, boolean sync) throws IOException, BrokerException {
        long valOffset = 9L;
        this.writeIntAtOffset(valOffset, state, sync);
    }

    synchronized void updateCompletion(int completionVal, boolean sync) throws IOException, BrokerException {
        long valOffset = 13L;
        this.writeIntAtOffset(valOffset, completionVal, sync);
    }

    void writeIntAtOffset(long valOffset, int val, boolean sync) throws IOException, BrokerException {
        if (sync && Store.getDEBUG_SYNC()) {
            String msg = "TransactionWorkInfo sync() " + this.tid;
            this.logger.log(4, msg);
        }
        if (this.vrecord != null) {
            long offset = 4L + valOffset;
            this.vrecord.writeInt((int)offset, val);
            if (sync) {
                this.vrecord.force();
            }
        } else if (!this.parent.writeAttachmentData(this.tid, valOffset, true, val, sync)) {
            String emsg = this.br.getKString("B3016", this.tid) + ": " + this.parent.storeName;
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }
}

