/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.JMSServiceImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.JMSService;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

public class IMQDirectService
extends IMQService {
    private ConnectionManager connectionList = Globals.getConnectionManager();
    private AuthCacheData authCacheData = new AuthCacheData();
    private JMSServiceImpl jmsservice = new JMSServiceImpl(this, Globals.getProtocol());

    @Deprecated
    public IMQDirectService(String name, int type, int min, int max, boolean acc) {
        this(name, type);
    }

    public IMQDirectService(String name, int type) {
        super(name, type);
    }

    public JMSService getJMSService() {
        return this.jmsservice;
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("JMSService", this.jmsservice.getDebugState());
        return ht;
    }

    @Override
    public synchronized void startService(boolean startPaused) {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] args = new String[]{this.getName(), "", String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", args);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), this.getName());
        }
        catch (BrokerException e) {
            this.logger.log(16, "B2135", (Object)this.getName(), e.getMessage());
        }
        if (startPaused) {
            this.setServiceRunning(false);
            this.setState(4);
            try {
                Globals.getPortMapper().updateServicePort(this.name, 0);
            }
            catch (Exception ex) {
                this.logger.logStack(16, "B3100", "starting paused service " + this, (Throwable)ex);
            }
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean all) {
        int i;
        Connection con;
        List<Connection> cons;
        IMQDirectService iMQDirectService = this;
        synchronized (iMQDirectService) {
            if (this.isShuttingDown()) {
                return;
            }
            Object[] strings = new String[]{this.getName(), ""};
            if (all) {
                this.logger.log(8, "B1007", strings);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", strings);
            }
            this.setShuttingDown(true);
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.stopConnection();
            }
        }
        cons = this;
        synchronized (cons) {
            this.setState(5);
            this.notifyAll();
        }
        if (!all) {
            return;
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = cons.get(i);
                con.destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        iMQDirectService = this;
        synchronized (iMQDirectService) {
            this.setState(6);
            this.notifyAll();
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0}", this.getName());
        }
    }

    @Override
    public void pauseService(boolean all) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to pause service " + this.name + ", already paused.");
            return;
        }
        Object[] strings = new String[]{this.getName(), ""};
        this.logger.log(4, "B1005", strings);
        try {
            this.stopNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setState(4);
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to resume service " + this.name + ", already running.");
            return;
        }
        Object[] strings = new String[]{this.getName(), ""};
        this.logger.log(4, "B1006", strings);
        try {
            this.startNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setServiceRunning(true);
        IMQDirectService iMQDirectService = this;
        synchronized (iMQDirectService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    @Override
    public void updateService(int port, int min, int max) throws IOException, PropertyUpdateException, BrokerException {
        Globals.getPortMapper().updateServicePort(this.name, 0);
        Globals.getPortMapper().removeService(this.name);
        Globals.getPortMapper().addService(this.name, "none", Globals.getConfig().getProperty("imq." + this.name + ".servicetype"), 0, this.getServiceProperties());
    }

    @Override
    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    @Override
    public void removeConnection(ConnectionUID uid, int reason, String str) {
        this.jmsservice.removeConnection(uid, reason, str);
    }

    @Override
    public boolean isDirect() {
        return true;
    }
}

