/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.json;

import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocketServiceApp;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.STOMPWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompFrameMessageImpl;
import com.sun.messaging.jmq.util.BASE64Decoder;
import com.sun.messaging.jmq.util.BASE64Encoder;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Map;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class JSONWebSocket
extends STOMPWebSocket {
    private Class base64Class = null;

    public JSONWebSocket(MQWebSocketServiceApp app, ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) {
        super(app, protocolHandler, request, listeners);
        this.base64Class = app.getBase64Class();
    }

    @Override
    protected void processData(byte[] data) throws Exception {
        Object[] args = new String[]{this.getClass().getSimpleName() + ".processData(byte[]): unexpected call"};
        throw new IOException(this.getLogString() + this.br.getKTString("B3100", args));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processData(String text) throws Exception {
        if (DEBUG) {
            logger.log(8, this.toString() + ".processData(text=" + text + ")");
        }
        Object joreply = null;
        try {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(text));
            JsonObject jo = jsonReader.readObject();
            String command = jo.getString("command");
            JsonObject headers = jo.getJsonObject("headers");
            JsonObject body = jo.getJsonObject("body");
            StompFrameMessage frame = StompFrameMessageImpl.getFactory().newStompFrameMessage(StompFrameMessage.Command.valueOf(command), logger);
            for (String key : headers.keySet()) {
                String val = headers.getString(key);
                if (val == null) continue;
                frame.addHeader(key, val);
            }
            if (body != null) {
                JsonString btype = body.getJsonString("type");
                if (btype == null || btype.getString().equals("text")) {
                    JsonString msg = body.getJsonString("text");
                    if (msg != null) {
                        frame.setBody(msg.getString().getBytes("UTF-8"));
                    }
                } else {
                    if (!btype.getString().equals("bytes")) throw new IOException("body type:" + btype + " not supported");
                    JsonString enc = body.getJsonString("encoder");
                    if (enc != null && !enc.getString().equals("base64")) throw new IOException("encoder " + enc + " not supported");
                    JsonString msg = body.getJsonString("text");
                    if (msg != null) {
                        byte[] bytes = null;
                        if (this.base64Class == null) {
                            BASE64Decoder decoder = new BASE64Decoder();
                            bytes = decoder.decodeBuffer(msg.getString());
                        } else {
                            Method gm = this.base64Class.getMethod("getDecoder", new Class[0]);
                            Object o = gm.invoke(null, new Object[0]);
                            Method dm = o.getClass().getMethod("decode", String.class);
                            bytes = (byte[])dm.invoke(o, msg.getString());
                        }
                        frame.setBody(bytes);
                        frame.addHeader("content-length", String.valueOf(bytes.length));
                    }
                }
            }
            this.dispatchMessage((StompFrameMessageImpl)frame);
            return;
        }
        catch (Exception e) {
            logger.logStack(32, e.getMessage(), e);
            this.sendFatalError(e);
        }
    }

    @Override
    protected void doSend(StompFrameMessage frame) throws Exception {
        Object body;
        JsonBuilderFactory jsonfactory = Json.createBuilderFactory(null);
        JsonObjectBuilder obuilder = jsonfactory.createObjectBuilder();
        JsonObjectBuilder hbuilder = jsonfactory.createObjectBuilder();
        JsonObjectBuilder bbuilder = jsonfactory.createObjectBuilder();
        obuilder = obuilder.add("command", frame.getCommand().toString());
        for (Map.Entry<String, String> pair : frame.getHeaders().entrySet()) {
            String key = pair.getKey();
            String val = pair.getValue();
            hbuilder.add(key, val);
        }
        obuilder.add("headers", (JsonValue)hbuilder.build());
        if (frame.getCommand().equals((Object)StompFrameMessage.Command.MESSAGE)) {
            if (frame.isTextMessage()) {
                body = frame.getBodyText();
                bbuilder.add("type", "text");
                if (body != null) {
                    bbuilder.add("text", (String)body);
                } else {
                    bbuilder.add("text", "");
                }
            } else {
                body = frame.getBody();
                bbuilder.add("type", "bytes");
                bbuilder.add("encoder", "base64");
                String textbody = "";
                if (body != null) {
                    if (this.base64Class == null) {
                        BASE64Encoder encoder = new BASE64Encoder();
                        textbody = encoder.encode((byte[])body);
                    } else {
                        Method gm = this.base64Class.getMethod("getEncoder", new Class[0]);
                        Object o = gm.invoke(null, new Object[0]);
                        Method em = o.getClass().getMethod("encodeToString", byte[].class);
                        textbody = (String)em.invoke(o, body);
                    }
                }
                bbuilder.add("text", textbody);
            }
        } else {
            body = frame.getBody();
            bbuilder.add("type", "text");
            if (body != null) {
                bbuilder.add("text", new String((byte[])body, "UTF-8"));
            } else {
                bbuilder.add("text", "");
            }
        }
        JsonObject jo = obuilder.add("body", (JsonValue)bbuilder.build()).build();
        this.send(jo.toString());
        if (DEBUG) {
            logger.log(8, this.toString() + " SENT JsonObject[" + jo + "]");
        }
    }
}

