/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.servlet;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.ServerLinkTable;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class HttpTunnelServlet
extends HttpServlet
implements HttpTunnelDefaults {
    private static final long serialVersionUID = 4398262071227918600L;
    private int serviceCounter = 0;
    private Object serviceLock = new Object();
    private boolean servletShuttingDown = false;
    protected String servletName = null;
    protected boolean inService = false;
    protected ServletContext servletContext;
    protected Date startTime = null;
    protected ServerLinkTable linkTable = null;
    protected Throwable initException = null;

    public void init() throws ServletException {
        this.serviceCounter = 0;
        this.servletShuttingDown = false;
        this.servletContext = this.getServletContext();
        this.startTime = new Date();
        this.servletName = "HttpTunnelServlet";
        try {
            this.linkTable = new ServerLinkTable(this.getServletConfig());
            this.inService = true;
        }
        catch (Exception e) {
            this.initException = e;
            this.servletContext.log(this.servletName + ": initialization failed, " + e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/octet-stream");
        if (this.servletShuttingDown) {
            return;
        }
        String qs = request.getQueryString();
        if (qs == null) {
            this.handleTest(request, response);
            return;
        }
        if (!this.inService) {
            return;
        }
        Hashtable ht = HttpUtils.parseQueryString((String)qs);
        String[] tmp1 = (String[])ht.get("Type");
        String requestType = tmp1[0];
        if (requestType == null) {
            this.handleTest(request, response);
            return;
        }
        String serverName = null;
        String[] tmp2 = (String[])ht.get("ServerName");
        if (tmp2 != null) {
            serverName = tmp2[0];
        }
        if (requestType.equals("push")) {
            this.handlePush(request, response, serverName);
        } else if (requestType.equals("pull")) {
            tmp2 = (String[])ht.get("ConnId");
            String connIdStr = tmp2[0];
            this.handlePull(request, response, connIdStr, serverName);
        } else if (requestType.equals("connect")) {
            this.handleConnect(request, response, serverName);
        } else {
            this.handleTest(request, response);
        }
    }

    public void handleTest(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html; charset=UTF-8 ");
            PrintWriter pw = response.getWriter();
            pw.println("<HTML>");
            pw.println("<HEAD>");
            pw.println("<TITLE> JMQ HTTP Tunneling Servlet </TITLE>");
            pw.println("</HEAD>");
            pw.println("<BODY>");
            if (this.inService) {
                pw.println("HTTP tunneling servlet ready.<BR>");
                pw.println("Servlet Start Time : " + this.startTime + " <BR>");
                pw.println("Accepting TCP connections from brokers on port : " + this.linkTable.getServletPort() + " <P>");
                Vector slist = this.linkTable.getServerList();
                pw.println("Total available brokers = " + slist.size() + "<BR>");
                pw.println("Broker List : <BR>");
                pw.println("<BLOCKQUOTE><PRE>");
                for (int i = 0; i < slist.size(); ++i) {
                    pw.println((String)slist.elementAt(i));
                }
                pw.println("</PRE></BLOCKQUOTE>");
            } else {
                pw.println(new Date() + "<br>");
                pw.println("HTTP Tunneling servlet cannot be started.<br>");
                if (this.initException != null) {
                    pw.println("    " + this.initException);
                }
            }
            pw.println("</BODY>");
            pw.println("</HTML>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendNoOp(HttpServletResponse response) {
        try {
            ServletOutputStream sos = response.getOutputStream();
            HttpTunnelPacket p = new HttpTunnelPacket();
            p.setPacketType(12);
            p.setConnId(0);
            p.setSequence(0);
            p.setWinsize(0);
            p.setChecksum(0);
            p.setPacketBody(null);
            p.writePacket((OutputStream)sos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handlePull(HttpServletRequest request, HttpServletResponse response, String connIdStr, String serverName) {
        Vector v = this.linkTable.waitForPackets(connIdStr, serverName);
        if (v == null || v.size() == 0) {
            this.sendNoOp(response);
            return;
        }
        try {
            ServletOutputStream sos = response.getOutputStream();
            for (int i = 0; i < v.size(); ++i) {
                HttpTunnelPacket p = (HttpTunnelPacket)v.elementAt(i);
                p.writePacket((OutputStream)sos);
            }
        }
        catch (Exception e) {
            this.linkTable.retrySendPackets(v, connIdStr, serverName);
        }
    }

    public void handlePush(HttpServletRequest request, HttpServletResponse response, String serverName) {
        int length = request.getContentLength();
        if (length > 0) {
            try {
                ServletInputStream sis = request.getInputStream();
                HttpTunnelPacket p = new HttpTunnelPacket();
                p.readPacket((InputStream)sis);
                this.linkTable.sendPacket(p, serverName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sendNoOp(response);
    }

    public void handleConnect(HttpServletRequest request, HttpServletResponse response, String serverName) {
        int length = request.getContentLength();
        if (length > 0) {
            HttpTunnelPacket p = null;
            try {
                ServletInputStream sis = request.getInputStream();
                p = new HttpTunnelPacket();
                p.readPacket((InputStream)sis);
            }
            catch (Exception e) {
                return;
            }
            if (serverName == null) {
                serverName = this.linkTable.getDefaultServer();
            }
            if (serverName == null) {
                return;
            }
            if (!this.linkTable.getListenState(serverName)) {
                return;
            }
            int connId = this.linkTable.createNewConn(serverName);
            if (connId == -1) {
                return;
            }
            p.setConnId(connId);
            try {
                p.setPacketBody(("ServerName=" + serverName).getBytes("UTF8"));
                ServletOutputStream sos = response.getOutputStream();
                p.writePacket((OutputStream)sos);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeUTF("ServerName=" + serverName);
                dos.writeUTF(request.getRemoteAddr());
                dos.flush();
                bos.flush();
                p.setPacketBody(bos.toByteArray());
                this.linkTable.sendPacket(p, serverName);
            }
            catch (Exception e) {
                this.servletContext.log(this.servletName + ": client connect: " + e.getMessage(), (Throwable)e);
                this.linkTable.destroyConn(connId, serverName);
            }
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.enteringServiceMethod();
        try {
            super.service(req, resp);
        }
        finally {
            this.leavingServiceMethod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enteringServiceMethod() {
        Object object = this.serviceLock;
        synchronized (object) {
            ++this.serviceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leavingServiceMethod() {
        Object object = this.serviceLock;
        synchronized (object) {
            --this.serviceCounter;
            if (this.serviceCounter == 0 && this.servletShuttingDown) {
                this.serviceLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numServices() {
        Object object = this.serviceLock;
        synchronized (object) {
            return this.serviceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.serviceLock;
        synchronized (object) {
            this.servletShuttingDown = true;
            if (this.linkTable != null) {
                this.linkTable.close();
            }
        }
        this.servletContext.log(this.servletName + ": destroy() ...");
        try {
            if (!this.inService) {
                return;
            }
            this.linkTable.shuttingDown();
            object = this.serviceLock;
            synchronized (object) {
                while (this.numServices() > 0) {
                    try {
                        this.serviceLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.linkTable.destroy();
            }
            this.servletContext.log(this.servletName + ": destroy() done");
        }
        finally {
            super.destroy();
        }
    }
}

