/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.Output;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.PasswdDB;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserInfo;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrException;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrOptions;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrProperties;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrUtils;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserPrinter;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.PassfileObfuscatorImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;

public class CmdRunner
implements UserMgrOptions {
    private static BrokerResources br = Globals.getBrokerResources();
    private UserMgrProperties userMgrProps;
    private PasswdDB pwDB;

    public CmdRunner(UserMgrProperties props) {
        this.userMgrProps = props;
    }

    public int runCommands() {
        int exitcode = 0;
        String cmd = this.userMgrProps.getCommand();
        this.pwDB = new PasswdDB();
        PasswdDB.setPasswordFileName(this.userMgrProps.getPasswordFile());
        if (cmd.equals("add")) {
            exitcode = this.runAdd(this.userMgrProps);
        } else if (cmd.equals("delete")) {
            exitcode = this.runDelete(this.userMgrProps);
        } else if (cmd.equals("list")) {
            exitcode = this.runList(this.userMgrProps);
        } else if (cmd.equals("update")) {
            exitcode = this.runUpdate(this.userMgrProps);
        } else if (cmd.equals(".exists")) {
            exitcode = this.runExists(this.userMgrProps);
        } else if (cmd.equals(".getgroup")) {
            exitcode = this.runGetGroup(this.userMgrProps);
        } else if (cmd.equals(".getgroupsize")) {
            exitcode = this.runGetGroupSize(this.userMgrProps);
        } else if (cmd.equals("encode")) {
            exitcode = this.runEncode(this.userMgrProps);
        } else if (cmd.equals("decode")) {
            exitcode = this.runDecode(this.userMgrProps);
        }
        return exitcode;
    }

    private int runAdd(UserMgrProperties userMgrProps) {
        String username = userMgrProps.getUserName();
        String role = userMgrProps.getRole();
        if (role == null) {
            role = "user";
        }
        Output.stdOutPrintln(br.getString("B1120", userMgrProps.getInstance()));
        try {
            if (username.equals("guest") && !role.equals("anonymous")) {
                Output.stdErrPrintln(br.getString("B2023"));
            }
            String passwd = this.getPasswordFromFileOrCmdLine(userMgrProps);
            this.pwDB.addUser(username, passwd, role);
        }
        catch (UserMgrException ume) {
            this.handleUserMgrExceptions(ume);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1025"));
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1017", username));
        return 0;
    }

    private int runDelete(UserMgrProperties userMgrProps) {
        String username = userMgrProps.getUserName();
        boolean force = userMgrProps.forceModeSet();
        Output.stdOutPrintln(br.getString("B1120", userMgrProps.getInstance()));
        try {
            int count;
            UserInfo uInfo;
            if (!force) {
                String noShort = br.getString("B0027");
                String yesShort = br.getString("B0026");
                String input = UserMgrUtils.getUserInput(null, br.getString("B1023", username), noShort);
                if (!yesShort.equalsIgnoreCase(input)) {
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1020", username));
                    return 0;
                }
            }
            if ((uInfo = this.pwDB.getUserInfo(username)) != null && uInfo.getRole().equals("admin") && (count = this.pwDB.getUserCount("admin")) == 1) {
                Output.stdErrPrintln(br.getString("B2022", username));
            }
            this.pwDB.deleteUser(username);
        }
        catch (UserMgrException ume) {
            this.handleUserMgrExceptions(ume);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1026"));
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1019", username));
        return 0;
    }

    private int runList(UserMgrProperties userMgrProps) {
        String username = userMgrProps.getUserName();
        UserPrinter up = new UserPrinter(3, 4, "-");
        Object[] oneRow = new String[3];
        try {
            Output.stdOutPrintln(br.getString("B1120", userMgrProps.getInstance()));
            oneRow[0] = br.getString("B1036");
            oneRow[1] = br.getString("B1037");
            oneRow[2] = br.getString("B1038");
            up.addTitle((String[])oneRow);
            if (username == null) {
                Enumeration e = this.pwDB.getUsers();
                while (e.hasMoreElements()) {
                    UserInfo oneUser = (UserInfo)e.nextElement();
                    oneRow[0] = oneUser.getUser();
                    oneRow[1] = oneUser.getRole();
                    oneRow[2] = String.valueOf(oneUser.isActive());
                    up.add(oneRow);
                }
            } else {
                UserInfo oneUser = this.pwDB.getUserInfo(username);
                if (oneUser == null) {
                    Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3048", username));
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1028"));
                    return 1;
                }
                oneRow[0] = oneUser.getUser();
                oneRow[1] = oneUser.getRole();
                oneRow[2] = String.valueOf(oneUser.isActive());
                up.add(oneRow);
            }
        }
        catch (UserMgrException ume) {
            this.handleUserMgrExceptions(ume);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1028"));
            return 1;
        }
        up.println();
        return 0;
    }

    private int runExists(UserMgrProperties userMgrProps) {
        int retValue;
        String username = userMgrProps.getUserName();
        try {
            UserInfo oneUser = this.pwDB.getUserInfo(username);
            if (oneUser == null) {
                Output.stdOutPrintln(Boolean.FALSE.toString());
                retValue = 0;
            } else {
                Output.stdOutPrintln(Boolean.TRUE.toString());
                retValue = 0;
            }
        }
        catch (UserMgrException ume) {
            this.handleUserMgrExceptions(ume);
            Output.stdErrPrintln("");
            Output.stdErrPrintln("Checking if a user exist failed.");
            return 1;
        }
        return retValue;
    }

    private int runGetGroup(UserMgrProperties userMgrProps) {
        int retValue;
        block6: {
            String username = userMgrProps.getUserName();
            try {
                UserInfo oneUser = this.pwDB.getUserInfo(username);
                if (oneUser == null) {
                    Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3048", username));
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln("Getting a user's group failed.");
                    return 1;
                }
                String group = oneUser.getRole();
                if (group.equals("admin")) {
                    Output.stdOutPrintln("admin");
                    retValue = 0;
                    break block6;
                }
                if (group.equals("user")) {
                    Output.stdOutPrintln("user");
                    retValue = 0;
                    break block6;
                }
                if (group.equals("anonymous")) {
                    Output.stdOutPrintln("anonymous");
                    retValue = 0;
                    break block6;
                }
                Output.stdErrPrintln("");
                Output.stdErrPrintln("User " + username + " is in unknown group: " + group);
                return 1;
            }
            catch (UserMgrException ume) {
                this.handleUserMgrExceptions(ume);
                Output.stdErrPrintln("");
                Output.stdErrPrintln("Getting a user's group failed.");
                return 1;
            }
        }
        return retValue;
    }

    private int runGetGroupSize(UserMgrProperties userMgrProps) {
        String role = userMgrProps.getRole();
        int nEntries = 0;
        try {
            nEntries = this.pwDB.getUserCount(role);
            Output.stdOutPrintln(Integer.toString(nEntries));
        }
        catch (UserMgrException ume) {
            this.handleUserMgrExceptions(ume);
            Output.stdErrPrintln("");
            Output.stdErrPrintln("Getting a group's size failed.");
            return 1;
        }
        return 0;
    }

    private int runEncode(UserMgrProperties userMgrProps) {
        String srcFile = userMgrProps.getSrc();
        String targetFile = userMgrProps.getTarget();
        boolean force = userMgrProps.forceModeSet();
        if (targetFile == null) {
            targetFile = srcFile + ".encode";
        }
        Output.stdOutPrintln(br.getString("B1490"));
        this.printSrcTarget(srcFile, targetFile);
        try {
            if (!force) {
                String noShort = br.getString("B0027");
                String input = UserMgrUtils.getUserInput(null, br.getString("B1491"), noShort);
                if (noShort.equalsIgnoreCase(input)) {
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1492"));
                    return 0;
                }
            }
            PassfileObfuscatorImpl po = new PassfileObfuscatorImpl();
            po.obfuscateFile(srcFile, targetFile, "imq");
        }
        catch (Exception e) {
            Output.stdErrPrintln("");
            Output.stdErrPrintln("Encode operation failed.\n" + e.toString());
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1493"));
        return 0;
    }

    private int runDecode(UserMgrProperties userMgrProps) {
        String srcFile = userMgrProps.getSrc();
        String targetFile = userMgrProps.getTarget();
        boolean force = userMgrProps.forceModeSet();
        if (targetFile == null) {
            targetFile = srcFile + ".decode";
        }
        Output.stdOutPrintln(br.getString("B1494"));
        this.printSrcTarget(srcFile, targetFile);
        try {
            if (!force) {
                String noShort = br.getString("B0027");
                String input = UserMgrUtils.getUserInput(null, br.getString("B1495"), noShort);
                if (noShort.equalsIgnoreCase(input)) {
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1496"));
                    return 0;
                }
            }
            PassfileObfuscatorImpl po = new PassfileObfuscatorImpl();
            po.deobfuscateFile(srcFile, targetFile, "imq");
        }
        catch (Exception e) {
            Output.stdErrPrintln("");
            Output.stdErrPrintln("Decode operation failed.\n" + e.toString());
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1497"));
        return 0;
    }

    private void printSrcTarget(String srcFile, String targetFile) {
        UserPrinter up = new UserPrinter(2, 4);
        Object[] row = new String[2];
        row[0] = br.getString("B1501");
        row[1] = srcFile;
        up.add(row);
        row[0] = br.getString("B1502");
        row[1] = targetFile;
        up.add(row);
        up.println();
    }

    private int runUpdate(UserMgrProperties userMgrProps) {
        String username = userMgrProps.getUserName();
        Boolean isActive = userMgrProps.isActive();
        boolean force = userMgrProps.forceModeSet();
        Output.stdOutPrintln(br.getString("B1120", userMgrProps.getInstance()));
        try {
            if (!force) {
                String noShort = br.getString("B0027");
                String yesShort = br.getString("B0026");
                String input = UserMgrUtils.getUserInput(null, br.getString("B1024", username), noShort);
                if (!yesShort.equalsIgnoreCase(input)) {
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1022", username));
                    return 0;
                }
            }
            String newPasswd = this.getPasswordFromFileOrCmdLine(userMgrProps);
            this.pwDB.updateUser(username, newPasswd, isActive);
        }
        catch (UserMgrException ume) {
            this.handleUserMgrExceptions(ume);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1027"));
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1021", username));
        return 0;
    }

    private void handleUserMgrExceptions(UserMgrException ume) {
        Exception ex = ume.getLinkedException();
        String pwFile = ume.getPasswordFile();
        String userName = ume.getUserName();
        int type = ume.getType();
        switch (type) {
            case 7: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3046", pwFile));
                break;
            }
            case 8: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3047", pwFile));
                break;
            }
            case 9: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3048", userName));
                break;
            }
            case 10: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3050", userName));
                break;
            }
            case 11: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3049"));
                break;
            }
            case 12: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3051", pwFile, ex));
                break;
            }
            case 13: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3052", pwFile, ex));
                break;
            }
            case 14: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3053"));
                break;
            }
            case 18: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3090"));
                break;
            }
            case 20: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3118", ex));
                break;
            }
            case 22: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3158", ex));
                break;
            }
            default: {
                Output.stdErrPrintln(br.getString("B3044"), ume.toString());
            }
        }
    }

    private String getPasswordFromFileOrCmdLine(UserMgrProperties userMgrProps) throws UserMgrException {
        String passwd = userMgrProps.getPassword();
        String passfile = userMgrProps.getPassfile();
        if (passwd != null) {
            return passwd;
        }
        if (passfile == null) {
            return null;
        }
        String ret = null;
        File f = new File(passfile);
        try (FileReader fr = new FileReader(f);
             BufferedReader bfr = new BufferedReader(fr);){
            ret = bfr.readLine();
        }
        catch (Exception e) {
            UserMgrException ume = new UserMgrException(22);
            ume.setProperties(userMgrProps);
            ume.setLinkedException(e);
            throw ume;
        }
        return ret;
    }
}

