/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.api.ha;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.util.List;
import java.util.Map;

public final class TakingoverTracker {
    public static final int BEFORE_GET_LOCK = 0;
    public static final int AFTER_GET_LOCK = 1;
    public static final int BEFORE_TAKE_STORE = 2;
    public static final int BEFORE_DB_SWITCH_OWNER = 3;
    public static final int AFTER_DB_SWITCH_OWNER = 4;
    public static final int AFTER_TAKE_STORE = 5;
    public static final int BEFORE_PROCESSING = 6;
    public static final int AFTER_PROCESSING = 7;
    private String targetName = null;
    private UID storeSession = null;
    private Thread runner = null;
    private Map msgMap = null;
    private int stage = -1;
    private int substage = -1;
    private UID brokerSession = null;
    private UID downStoreSession = null;
    private long lastHeartbeat = 0L;
    private List<Long> takeoverStoreSessions = null;

    public TakingoverTracker(String targetName, Thread runnerThread) {
        this.targetName = targetName;
        this.runner = runnerThread;
    }

    public void setStoreSession(long sid) {
        this.storeSession = new UID(sid);
    }

    public UID getStoreSessionUID() {
        return this.storeSession;
    }

    public void setBrokerSessionUID(UID bss) {
        this.brokerSession = bss;
    }

    public UID getBrokerSessionUID() {
        return this.brokerSession;
    }

    public void setDownStoreSessionUID(UID ss) {
        this.downStoreSession = ss;
    }

    public UID getDownStoreSessionUID() {
        return this.downStoreSession;
    }

    public void setLastHeartbeat(long ts) {
        this.lastHeartbeat = ts;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setTakeoverStoreSessionList(List<Long> l) {
        this.takeoverStoreSessions = l;
    }

    public List<Long> getTakeoverStoreSessionList() {
        return this.takeoverStoreSessions;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Thread getTakeoverRunner() {
        return this.runner;
    }

    public int getStage() {
        if (this.substage != -1) {
            return this.substage;
        }
        return this.stage;
    }

    public void setMessageMap(Map mMap) throws BrokerException {
        if (Thread.currentThread() != this.runner) {
            throw new BrokerException("Internal Error: TakingoverTracker.setMessageMap() not runner thread");
        }
        if (this.stage < 1 || this.stage > 3) {
            throw new BrokerException("Internal Error: TakingoverTracker.setMessageMap() unexpected stage " + this.stage + "(" + this.substage + ")");
        }
        this.msgMap = mMap;
    }

    public boolean containDestination(Destination d) {
        if (this.msgMap == null) {
            return false;
        }
        return this.msgMap.containsValue(d.getDestinationUID().toString());
    }

    public boolean containMessage(Packet m) {
        if (this.msgMap == null) {
            return false;
        }
        return this.msgMap.containsKey(m.getSysMessageID().toString());
    }

    public boolean containStoreSession(Long ss) {
        if (this.takeoverStoreSessions == null) {
            return false;
        }
        return this.takeoverStoreSessions.contains(ss);
    }

    public void setStage_BEFORE_GET_LOCK() {
        this.stage = 0;
    }

    public void setStage_AFTER_GET_LOCK() {
        this.stage = 1;
    }

    public void setStage_BEFORE_TAKE_STORE() {
        this.stage = 2;
    }

    public void setStage_BEFORE_DB_SWITCH_OWNER() {
        this.substage = 3;
    }

    public void setStage_AFTER_DB_SWITCH_OWNER() {
        this.substage = 4;
    }

    public void setStage_AFTER_TAKE_STORE() {
        this.stage = 5;
    }

    public void setStage_BEFORE_PROCESSING() {
        this.stage = 6;
    }

    public void setStage_AFTER_PROCESSING() {
        this.stage = 7;
    }

    public String toString() {
        return this.getTargetName() + "[StoreSession:" + (this.getStoreSessionUID() == null ? "" : this.getStoreSessionUID()) + "], " + (this.getBrokerSessionUID() == null ? "" : this.getBrokerSessionUID()) + ", " + this.lastHeartbeat + ", (" + this.getStage() + ")";
    }
}

