/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl")
@Singleton
public class ClusterManagerImpl
implements ClusterManager,
ConfigListener {
    private static final String DEBUG_ALL_PROP = "imq.cluster.debug.all";
    private static final boolean debug_CLUSTER_ALL;
    private static boolean DEBUG_CLUSTER_ALL;
    private static final String DEBUG_LOCK_PROP = "imq.cluster.debug.lock";
    private static final boolean debug_CLUSTER_LOCK;
    private static boolean DEBUG_CLUSTER_LOCK;
    private static final String DEBUG_TXN_PROP = "imq.cluster.debug.txn";
    private static final boolean debug_CLUSTER_TXN;
    private static boolean DEBUG_CLUSTER_TXN;
    private static final String DEBUG_TAKEOVER_PROP = "imq.cluster.debug.takeover";
    private static final boolean debug_CLUSTER_TAKEOVER;
    private static boolean DEBUG_CLUSTER_TAKEOVER;
    private static final String DEBUG_MSG_PROP = "imq.cluster.debug.msg";
    private static final boolean debug_CLUSTER_MSG;
    private static boolean DEBUG_CLUSTER_MSG;
    private static final String DEBUG_CONN_PROP = "imq.cluster.debug.conn";
    private static final boolean debug_CLUSTER_CONN;
    private static boolean DEBUG_CLUSTER_CONN;
    private static final String DEBUG_PING_PROP = "imq.cluster.debug.ping";
    private static final boolean debug_CLUSTER_PING;
    private static boolean DEBUG_CLUSTER_PING;
    private static final String DEBUG_PKT_PROP = "imq.cluster.debug.packet";
    private static final boolean debug_CLUSTER_PACKET;
    private static boolean DEBUG_CLUSTER_PACKET;
    private static boolean DEBUG;
    protected BrokerConfig config = Globals.getConfig();
    protected Logger logger = Globals.getLogger();
    protected Set listeners = null;
    protected String transport = null;
    protected String clusterhost = null;
    protected int clusterport = 0;
    protected boolean initialized = false;
    protected String localBroker = null;
    protected String masterBroker = null;
    protected Map allBrokers = null;
    protected static final String MANUAL_AUTOCONNECT_PROPERTY = "imq.cluster.brokerlist.manual";
    protected static final String MAX_OLD_SESSIONS_PROP = "imq.cluster.maxTakeoverSessions";
    protected static final String MAX_RETAITION_TIME_PROP = "imq.cluster.maxTakeoverSessionRetaintionTime";
    protected static final long MAX_RETAITION_TIME_DEFAULT = 1800L;
    protected int maxTakeoverSessions = Globals.getConfig().getIntProperty("imq.cluster.maxTakeoverSessions", 10);
    protected long maxTakeoverRetaintionTime = ClusterManagerImpl.getMAX_RETAITION_TIME();
    protected LinkedHashMap<UID, Long> supportedSessionMap = new LinkedHashMap();
    private String clusterid = Globals.getClusterID();
    private BrokerResources br = Globals.getBrokerResources();
    private MQAddress brokerNextToMe = null;
    private Object brokerNextToMeLock = new Object();
    private int clusterPingInterval = 60;
    private boolean brokerChangedProcessing = false;
    LinkedList brokerChangedEntryList = new LinkedList();
    int brokerindx = 0;

    public static boolean isDEBUG_CLUSTER_ALL() {
        return DEBUG_CLUSTER_ALL;
    }

    public static boolean isDEBUG_CLUSTER_LOCK() {
        return DEBUG_CLUSTER_LOCK;
    }

    public static boolean isDEBUG_CLUSTER_TXN() {
        return DEBUG_CLUSTER_TXN;
    }

    public static boolean isDEBUG_CLUSTER_TAKEOVER() {
        return DEBUG_CLUSTER_TAKEOVER;
    }

    public static boolean isDEBUG_CLUSTER_MSG() {
        return DEBUG_CLUSTER_MSG;
    }

    public static boolean isDEBUG_CLUSTER_CONN() {
        return DEBUG_CLUSTER_CONN;
    }

    public static boolean isDEBUG_CLUSTER_PING() {
        return DEBUG_CLUSTER_PING;
    }

    public static boolean isDEBUG_CLUSTER_PACKET() {
        return DEBUG_CLUSTER_PACKET;
    }

    private static long getMAX_RETAITION_TIME() {
        long t = Globals.getConfig().getLongProperty(MAX_RETAITION_TIME_PROP, 1800L);
        if (t < 1800L) {
            t = 1800L;
        }
        return t * 1000L;
    }

    public ClusterManagerImpl() {
        this.listeners = new LinkedHashSet();
    }

    @Override
    public int getClusterPingInterval() {
        return this.clusterPingInterval;
    }

    @Override
    public String getClusterId() {
        return this.clusterid;
    }

    protected Map initAllBrokers(MQAddress myaddr) throws BrokerException {
        return new HashMap();
    }

    @Override
    public void setMQAddress(MQAddress address) throws Exception {
        if (!this.initialized) {
            this.initialize(address);
        } else {
            this.mqAddressChanged(address);
        }
    }

    @Override
    public MQAddress getMQAddress() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.getLocalBroker().getBrokerURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(ClusterListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEventListener(ClusterListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            return this.listeners.remove(listener);
        }
    }

    @Override
    public ClusteredBroker getLocalBroker() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.getBroker(this.localBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getKnownBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            return this.allBrokers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConfigBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        int cnt = 0;
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker cb : this.allBrokers.values()) {
                if (!cb.isConfigBroker()) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        int cnt = 0;
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker cb : this.allBrokers.values()) {
                if (!BrokerStatus.getBrokerLinkIsUp(cb.getStatus())) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getKnownBrokers(boolean refresh) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet brokers = null;
        Map map = this.allBrokers;
        synchronized (map) {
            brokers = new HashSet(this.allBrokers.values());
        }
        return brokers.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getConfigBrokers() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet brokers = null;
        Map map = this.allBrokers;
        synchronized (map) {
            brokers = new HashSet(this.allBrokers.values());
            return new ConfigInterator(brokers.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getActiveBrokers() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet brokers = null;
        Map map = this.allBrokers;
        synchronized (map) {
            brokers = new HashSet(this.allBrokers.values());
            return new ActiveInterator(brokers.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusteredBroker getBroker(String brokerid) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            return (ClusteredBroker)this.allBrokers.get(brokerid);
        }
    }

    @Override
    public String activateBroker(MQAddress URL2, UID uid, String instName, Object userData) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String brokerid = this.lookupBrokerID(URL2);
        if (brokerid == null) {
            brokerid = this.addBroker(URL2, false, false, uid);
        }
        return this.activateBroker(brokerid, uid, instName, userData);
    }

    @Override
    public String activateBroker(String brokerid, UID uid, String instName, Object userData) throws NoSuchElementException, BrokerException {
        ClusteredBroker cb = this.getBroker(brokerid);
        if (cb == null) {
            throw new BrokerException("Unknown broker " + brokerid);
        }
        cb.setInstanceName(instName);
        if (uid != null) {
            cb.setBrokerSessionUID(uid);
        }
        cb = this.updateBrokerOnActivation(cb, userData);
        cb.setStatus(257, userData);
        return brokerid;
    }

    protected ClusteredBroker updateBrokerOnActivation(ClusteredBroker broker, Object userData) {
        return broker;
    }

    protected ClusteredBroker updateBrokerOnDeactivation(ClusteredBroker broker, Object userData) {
        broker.setInstanceName(null);
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addBroker(MQAddress URL2, boolean isLocal, boolean config, UID sid) throws NoSuchElementException, BrokerException {
        ClusteredBroker cb = this.newClusteredBroker(URL2, isLocal, sid);
        ((ClusteredBrokerImpl)cb).setConfigBroker(config);
        Map map = this.allBrokers;
        synchronized (map) {
            this.allBrokers.put(cb.getBrokerName(), cb);
        }
        this.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, sid, null);
        return cb.getBrokerName();
    }

    public ClusteredBroker newClusteredBroker(MQAddress URL2, boolean isLocal, UID sid) throws BrokerException {
        return new ClusteredBrokerImpl(this, URL2, isLocal, sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromAllBrokers(String brokerName) {
        Map map = this.allBrokers;
        synchronized (map) {
            this.allBrokers.remove(brokerName);
        }
    }

    @Override
    public void deactivateBroker(MQAddress URL2, Object userData) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String brokerid = this.lookupBrokerID(URL2);
        if (brokerid == null) {
            throw new NoSuchElementException("Unknown URL " + URL2);
        }
        this.deactivateBroker(brokerid, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateBroker(String brokerid, Object userData) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ClusteredBroker cb = null;
        boolean removed = false;
        Map map = this.allBrokers;
        synchronized (map) {
            cb = (ClusteredBroker)this.allBrokers.get(brokerid);
            if (cb == null) {
                throw new NoSuchElementException("Unknown Broker" + brokerid);
            }
            if (!cb.isConfigBroker()) {
                this.allBrokers.remove(brokerid);
                removed = true;
            }
            this.updateBrokerOnDeactivation(cb, null);
        }
        cb.setStatus(BrokerStatus.setBrokerLinkIsDown(cb.getStatus()), userData);
        if (removed) {
            this.brokerChanged(ClusterReason.REMOVED, cb.getBrokerName(), cb, null, cb.getBrokerSessionUID(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupBrokerID(MQAddress broker) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker cb : this.allBrokers.values()) {
                MQAddress addr = cb.getBrokerURL();
                if (!addr.equals(broker)) continue;
                return cb.getBrokerName();
            }
        }
        return null;
    }

    @Override
    public String lookupStoreSessionOwner(UID uid) {
        return null;
    }

    @Override
    public String getStoreSessionCreator(UID uid) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupBrokerSessionUID(UID uid) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker cb : this.allBrokers.values()) {
                UID buid = cb.getBrokerSessionUID();
                if (!buid.equals(uid)) continue;
                return cb.getBrokerName();
            }
        }
        return null;
    }

    protected boolean allowMasterBroker() {
        return true;
    }

    @Override
    public ClusteredBroker getMasterBroker() {
        if (this.masterBroker == null) {
            return null;
        }
        return this.getBroker(this.masterBroker);
    }

    @Override
    public String getTransport() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.transport;
    }

    @Override
    public int getClusterPort() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.clusterport;
    }

    @Override
    public String getClusterHost() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.clusterhost;
    }

    @Override
    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return false;
    }

    @Override
    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] props = new String[]{"imq.cluster.url", "imq.cluster.brokerlist"};
        this.config.reloadProps(Globals.getConfigName(), props, false);
    }

    protected void setupListeners() {
        this.config.addListener("imq.cluster.transport", this);
        this.config.addListener("imq.cluster.hostname", this);
        this.config.addListener("imq.cluster.port", this);
        this.config.addListener("imq.cluster.brokerlist", this);
        this.config.addListener("imq.cluster.masterbroker", this);
        this.config.addListener("imq.cluster.ping.interval", this);
    }

    @Override
    public String initialize(MQAddress address) throws BrokerException {
        this.initialized = true;
        this.allBrokers = this.initAllBrokers(address);
        this.setupListeners();
        this.config.addListener(DEBUG_ALL_PROP, this);
        this.config.addListener(DEBUG_LOCK_PROP, this);
        this.config.addListener(DEBUG_TXN_PROP, this);
        this.config.addListener(DEBUG_TAKEOVER_PROP, this);
        this.config.addListener(DEBUG_MSG_PROP, this);
        this.config.addListener(DEBUG_CONN_PROP, this);
        this.config.addListener(DEBUG_PING_PROP, this);
        this.config.addListener(DEBUG_PKT_PROP, this);
        this.transport = this.config.getProperty("imq.cluster.transport");
        if (this.transport == null) {
            this.transport = "tcp";
        }
        this.clusterhost = this.config.getProperty("imq.cluster.hostname");
        if (this.clusterhost == null) {
            this.clusterhost = Globals.getHostname();
            if (this.clusterhost != null && this.clusterhost.equals("*")) {
                this.clusterhost = null;
            }
        }
        this.clusterport = this.config.getIntProperty("imq.cluster.port", 0);
        this.clusterPingInterval = this.config.getIntProperty("imq.cluster.ping.interval", 60);
        if (this.clusterPingInterval <= 0) {
            this.clusterPingInterval = 60;
        }
        LinkedHashSet s = null;
        try {
            s = this.parseBrokerList();
        }
        catch (Exception ex) {
            this.logger.logStack(32, Globals.getBrokerResources().getKString("B4315", ex.toString()), ex);
            throw new BrokerException(ex.getMessage(), ex);
        }
        this.localBroker = this.addBroker(address, true, s.remove(address), new UID());
        this.getLocalBroker().setStatus(257, null);
        this.setBrokerNextToMe(s);
        for (MQAddress addr : s) {
            try {
                ClusteredBroker lcb = this.getLocalBroker();
                if (addr.equals(this.getMQAddress())) {
                    if (!(lcb instanceof ClusteredBrokerImpl)) continue;
                    ((ClusteredBrokerImpl)lcb).setConfigBroker(true);
                    continue;
                }
                this.addBroker(addr, false, true, null);
            }
            catch (NoSuchElementException ex) {
                this.logger.logStack(32, ex.getMessage() + ": bad address in the broker list ", ex);
            }
        }
        String mbroker = this.config.getProperty("imq.cluster.masterbroker");
        if (!this.allowMasterBroker()) {
            if (DEBUG || this.logger.getLevel() <= 4) {
                this.logger.log(8, "This broker does not allow imq.cluster.masterbroker to be configured." + (mbroker == null ? "" : " Ignore imq.cluster.masterbroker=" + mbroker));
            }
            mbroker = null;
        } else if (Globals.useSharedConfigRecord()) {
            if (mbroker == null) {
                this.logger.log(8, this.br.getKString("B1359"));
            } else {
                this.logger.log(16, this.br.getKString("B1360", "imq.cluster.masterbroker=" + mbroker));
            }
            mbroker = null;
        }
        if (mbroker != null) {
            BrokerMQAddress addr = null;
            try {
                addr = BrokerMQAddress.createAddress(mbroker);
            }
            catch (Exception ex) {
                this.logger.logStack(32, "B3100", "bad address while parsing the broker list ", (Throwable)ex);
            }
            this.masterBroker = this.lookupBrokerID(addr);
            if (this.masterBroker == null) {
                this.logger.log(16, "B2132", ((MQAddress)addr).toString());
                this.masterBroker = this.addBroker(addr, false, true, null);
            }
            this.masterBroker = this.lookupBrokerID(addr);
        }
        if (DEBUG) {
            this.logger.log(4, "Cluster is:" + this.toString());
        }
        return this.localBroker;
    }

    protected LinkedHashSet parseBrokerList() throws MalformedURLException, UnknownHostException {
        String propfileSetting = this.config.getProperty("imq.cluster.brokerlist");
        String cmdlineSetting = this.config.getProperty(MANUAL_AUTOCONNECT_PROPERTY);
        String values = null;
        if (propfileSetting == null && cmdlineSetting == null) {
            return new LinkedHashSet();
        }
        values = propfileSetting == null ? cmdlineSetting : (cmdlineSetting == null ? propfileSetting : cmdlineSetting + "," + propfileSetting);
        return this.parseBrokerList(values);
    }

    @Override
    public LinkedHashSet parseBrokerList(String values) throws MalformedURLException, UnknownHostException {
        LinkedHashMap<String, BrokerMQAddress> tmpMap = new LinkedHashMap<String, BrokerMQAddress>();
        StringTokenizer st = new StringTokenizer(values, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            BrokerMQAddress address = BrokerMQAddress.createAddress(s);
            tmpMap.put(((MQAddress)address).toString(), address);
        }
        return new LinkedHashSet(((HashMap)tmpMap).values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBrokerNextToMe(LinkedHashSet list) {
        Object object = this.brokerNextToMeLock;
        synchronized (object) {
            Iterator itr = list.iterator();
            MQAddress addr = null;
            MQAddress next = null;
            boolean foundlocal = false;
            boolean i = false;
            while (itr.hasNext()) {
                addr = (MQAddress)itr.next();
                if (!i && !addr.equals(this.getMQAddress())) {
                    next = addr;
                }
                if (foundlocal) {
                    next = addr;
                    break;
                }
                if (!addr.equals(this.getMQAddress())) continue;
                foundlocal = true;
            }
            this.brokerNextToMe = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MQAddress getBrokerNextToMe() {
        Object object = this.brokerNextToMeLock;
        synchronized (object) {
            return this.brokerNextToMe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterManager: [local=").append(this.localBroker).append(", master = ").append(this.masterBroker).append("]\n");
        Map map = this.allBrokers;
        synchronized (map) {
            Iterator itr = this.allBrokers.values().iterator();
            while (itr.hasNext()) {
                str.append('\t').append(itr.next()).append('\n');
            }
        }
        return str.toString();
    }

    @Override
    public synchronized UID getStoreSessionUID() {
        return null;
    }

    @Override
    public synchronized UID getBrokerSessionUID() {
        return this.getLocalBroker().getBrokerSessionUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSupportedStoreSessionUID(UID uid) {
        LinkedHashMap<UID, Long> linkedHashMap = this.supportedSessionMap;
        synchronized (linkedHashMap) {
            this.supportedSessionMap.put(uid, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getSupportedStoreSessionUIDs() {
        HashSet<UID> s = null;
        LinkedHashMap<UID, Long> linkedHashMap = this.supportedSessionMap;
        synchronized (linkedHashMap) {
            s = new HashSet<UID>(this.supportedSessionMap.keySet());
        }
        if (this.getStoreSessionUID() != null) {
            s.add(this.getStoreSessionUID());
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void brokerListChanged() throws BrokerException {
        Iterator<Object> itr;
        LinkedHashSet s = null;
        try {
            s = this.parseBrokerList();
            this.setBrokerNextToMe(s);
            if (DEBUG) {
                this.logger.log(8, "ClusterManagerImpl.parseBrokerList:" + s);
            }
        }
        catch (Exception ex) {
            this.logger.logStack(32, "B3100", "bad address in brokerListChanged ", (Throwable)ex);
            s = new LinkedHashSet();
        }
        for (MQAddress addr : s) {
            if (this.lookupBrokerID(addr) != null) continue;
            this.addBroker(addr, false, true, null);
        }
        ArrayList<ClusteredBroker> oldBrokers = new ArrayList<ClusteredBroker>();
        Map map = this.allBrokers;
        synchronized (map) {
            itr = this.allBrokers.values().iterator();
            while (itr.hasNext()) {
                ClusteredBroker cb = (ClusteredBroker)itr.next();
                ((ClusteredBrokerImpl)cb).setConfigBroker(true);
                MQAddress addr = cb.getBrokerURL();
                if (s.contains(addr)) {
                    s.remove(addr);
                    continue;
                }
                if (cb.isLocalBroker()) continue;
                oldBrokers.add(cb);
                itr.remove();
            }
        }
        itr = oldBrokers.iterator();
        while (itr.hasNext()) {
            ClusteredBroker cb = (ClusteredBroker)itr.next();
            this.brokerChanged(ClusterReason.REMOVED, cb.getBrokerName(), cb, null, cb.getBrokerSessionUID(), null);
            itr.remove();
        }
        itr = s.iterator();
        while (itr.hasNext()) {
            this.addBroker((MQAddress)itr.next(), false, true, null);
        }
    }

    protected void masterBrokerChanged(String mbroker) throws BrokerException {
        ClusteredBroker oldMaster = this.getMasterBroker();
        this.masterBroker = null;
        if (mbroker != null) {
            BrokerMQAddress addr = null;
            try {
                addr = BrokerMQAddress.createAddress(mbroker);
            }
            catch (Exception ex) {
                this.logger.log(32, "B2133", (Object)mbroker, (Throwable)ex);
            }
            this.masterBroker = this.lookupBrokerID(addr);
            if (this.masterBroker == null) {
                this.masterBroker = this.addBroker(addr, false, true, null);
            }
        }
        ClusteredBroker newMaster = this.getMasterBroker();
        this.brokerChanged(ClusterReason.MASTER_BROKER_CHANGED, null, oldMaster, newMaster, null, null);
    }

    protected void mqAddressChanged(MQAddress address) throws Exception {
        ClusteredBroker cb = this.getLocalBroker();
        MQAddress oldAddress = cb.getBrokerURL();
        cb.setBrokerURL(address);
        this.brokerChanged(ClusterReason.ADDRESS_CHANGED, cb.getBrokerName(), oldAddress, address, null, null);
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
        block12: {
            if (name.equals("imq.cluster.transport")) {
                throw new PropertyUpdateException(this.br.getString("B4028", name));
            }
            if (name.equals("imq.cluster.hostname")) {
                throw new PropertyUpdateException(this.br.getString("B4028", name));
            }
            if (name.equals("imq.cluster.port")) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new PropertyUpdateException("imq.cluster.port should be set to an int not " + value);
                }
            }
            if (name.equals("imq.cluster.ping.interval")) {
                try {
                    int v = Integer.parseInt(value);
                    if (v <= 0) {
                        throw new NumberFormatException("" + value);
                    }
                    break block12;
                }
                catch (NumberFormatException ex) {
                    throw new PropertyUpdateException("imq.cluster.ping.interval should be set to a positive int not " + value);
                }
            }
            if (!name.equals("imq.cluster.brokerlist") && name.equals("imq.cluster.masterbroker")) {
                try {
                    BrokerMQAddress.createAddress(value);
                }
                catch (Exception e) {
                    throw new PropertyUpdateException(this.br.getString("B4028", value) + ": " + e.getMessage());
                }
            }
        }
    }

    @Override
    public boolean update(String name, String value) {
        if (name.equals("imq.cluster.transport")) {
            this.transport = value;
            if (this.transport == null || this.transport.length() == 0) {
                this.transport = "tcp";
            }
            this.clusterPropertyChanged(name, value);
        } else if (name.equals("imq.cluster.hostname")) {
            this.clusterPropertyChanged(name, value);
        } else if (name.equals("imq.cluster.port")) {
            this.clusterPropertyChanged(name, value);
        } else if (name.equals("imq.cluster.ping.interval")) {
            this.clusterPropertyChanged(name, value);
        } else if (name.equals("imq.cluster.brokerlist")) {
            if (DEBUG) {
                this.logger.log(8, "ClusterManagerImpl.update(" + name + "=" + value + ")");
            }
            try {
                this.brokerListChanged();
            }
            catch (Exception ex) {
                this.logger.log(8, "INTERNAL ERROR", ex);
            }
        } else if (name.equals("imq.cluster.masterbroker")) {
            try {
                this.masterBrokerChanged(value);
            }
            catch (Exception ex) {
                this.logger.log(8, "INTERNAL ERROR", ex);
            }
        } else if (name.equals(DEBUG_ALL_PROP)) {
            DEBUG_CLUSTER_ALL = Boolean.valueOf(value);
            DEBUG_CLUSTER_LOCK = Boolean.valueOf(value);
            DEBUG_CLUSTER_TXN = Boolean.valueOf(value);
            DEBUG_CLUSTER_TAKEOVER = Boolean.valueOf(value);
            DEBUG_CLUSTER_MSG = Boolean.valueOf(value);
            DEBUG_CLUSTER_CONN = Boolean.valueOf(value);
            DEBUG_CLUSTER_PING = Boolean.valueOf(value);
            DEBUG_CLUSTER_PACKET = Boolean.valueOf(value);
        } else if (name.equals(DEBUG_LOCK_PROP)) {
            DEBUG_CLUSTER_LOCK = Boolean.valueOf(value);
        } else if (name.equals(DEBUG_TXN_PROP)) {
            DEBUG_CLUSTER_TXN = Boolean.valueOf(value);
        } else if (name.equals(DEBUG_TAKEOVER_PROP)) {
            DEBUG_CLUSTER_TAKEOVER = Boolean.valueOf(value);
        } else if (name.equals(DEBUG_MSG_PROP)) {
            DEBUG_CLUSTER_MSG = Boolean.valueOf(value);
        } else if (name.equals(DEBUG_CONN_PROP)) {
            DEBUG_CLUSTER_CONN = Boolean.valueOf(value);
        } else if (name.equals(DEBUG_PING_PROP)) {
            DEBUG_CLUSTER_PING = Boolean.valueOf(value);
        } else if (name.equals(DEBUG_PKT_PROP)) {
            DEBUG_CLUSTER_PACKET = Boolean.valueOf(value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterPropertyChanged(String name, String value) {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.size() == 0) {
                return;
            }
            for (ClusterListener listen : this.listeners) {
                listen.clusterPropertyChanged(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brokerChanged(ClusterReason reason, String brokerid, Object oldvalue, Object newvalue, UID suid, Object userData) {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.size() == 0) {
                return;
            }
        }
        BrokerChangedEntry bce = new BrokerChangedEntry(reason, brokerid, oldvalue, newvalue, suid, userData);
        LinkedList linkedList = this.brokerChangedEntryList;
        synchronized (linkedList) {
            this.brokerChangedEntryList.add(bce);
            if (this.brokerChangedProcessing) {
                return;
            }
            this.brokerChangedProcessing = true;
        }
        try {
            BrokerChangedEntry process = null;
            block24: while (true) {
                ClusterListener[] alisteners = null;
                Set set2 = this.listeners;
                synchronized (set2) {
                    LinkedList linkedList2 = this.brokerChangedEntryList;
                    synchronized (linkedList2) {
                        if (this.listeners.size() == 0 || this.brokerChangedEntryList.isEmpty()) {
                            this.brokerChangedProcessing = false;
                            break;
                        }
                        process = (BrokerChangedEntry)this.brokerChangedEntryList.removeFirst();
                    }
                    alisteners = this.listeners.toArray(new ClusterListener[this.listeners.size()]);
                }
                int i = 0;
                while (true) {
                    block44: {
                        if (i >= alisteners.length) continue block24;
                        ClusterListener listen = alisteners[i];
                        Set set3 = this.listeners;
                        synchronized (set3) {
                            if (!this.listeners.contains(listen)) {
                                break block44;
                            }
                        }
                        if (process.reason == ClusterReason.ADDED) {
                            listen.brokerAdded((ClusteredBroker)process.newValue, process.brokerSession);
                        } else if (process.reason == ClusterReason.REMOVED) {
                            listen.brokerRemoved((ClusteredBroker)process.oldValue, process.brokerSession);
                        } else if (process.reason == ClusterReason.STATUS_CHANGED) {
                            listen.brokerStatusChanged(process.brokerid, (Integer)process.oldValue, (Integer)process.newValue, process.brokerSession, process.userData);
                        } else if (process.reason == ClusterReason.STATE_CHANGED) {
                            listen.brokerStateChanged(process.brokerid, (BrokerState)process.oldValue, (BrokerState)process.newValue);
                        } else if (process.reason == ClusterReason.VERSION_CHANGED) {
                            listen.brokerVersionChanged(process.brokerid, (Integer)process.oldValue, (Integer)process.newValue);
                        } else if (process.reason == ClusterReason.ADDRESS_CHANGED) {
                            listen.brokerURLChanged(process.brokerid, (MQAddress)process.oldValue, (MQAddress)process.newValue);
                        } else if (process.reason == ClusterReason.MASTER_BROKER_CHANGED) {
                            listen.masterBrokerChanged((ClusteredBroker)process.oldValue, (ClusteredBroker)process.newValue);
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            linkedList = this.brokerChangedEntryList;
            synchronized (linkedList) {
                this.brokerChangedProcessing = false;
            }
        }
    }

    @Override
    public ClusteredBroker getBrokerByNodeName(String nodeName) throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getbrokerByNodeName()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionAdded(UID partitionID, Object source) {
        LinkedHashMap<UID, Long> linkedHashMap = this.supportedSessionMap;
        synchronized (linkedHashMap) {
            if (source instanceof DestinationList) {
                this.supportedSessionMap.put(partitionID, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionRemoved(UID partitionID, Object source, Object destinedTo) {
        LinkedHashMap<UID, Long> linkedHashMap = this.supportedSessionMap;
        synchronized (linkedHashMap) {
            Long v;
            Globals.getDestinationList();
            if (DestinationList.isPartitionMode()) {
                if (partitionID != null) {
                    this.supportedSessionMap.remove(partitionID);
                }
                return;
            }
            if (partitionID != null && (v = this.supportedSessionMap.get(partitionID)) != null) {
                this.supportedSessionMap.put(partitionID, 0L);
            }
            if (this.supportedSessionMap.size() > this.maxTakeoverSessions) {
                Iterator<Map.Entry<UID, Long>> itr = this.supportedSessionMap.entrySet().iterator();
                long currtime = System.currentTimeMillis();
                while (itr.hasNext()) {
                    Long v2 = itr.next().getValue();
                    if (v2 != 0L && currtime - v2 <= this.maxTakeoverRetaintionTime) continue;
                    itr.remove();
                    break;
                }
            }
        }
    }

    static {
        DEBUG_CLUSTER_ALL = debug_CLUSTER_ALL = Globals.getConfig().getBooleanProperty(DEBUG_ALL_PROP);
        DEBUG_CLUSTER_LOCK = debug_CLUSTER_LOCK = Globals.getConfig().getBooleanProperty(DEBUG_LOCK_PROP);
        DEBUG_CLUSTER_TXN = debug_CLUSTER_TXN = Globals.getConfig().getBooleanProperty(DEBUG_TXN_PROP);
        DEBUG_CLUSTER_TAKEOVER = debug_CLUSTER_TAKEOVER = Globals.getConfig().getBooleanProperty(DEBUG_TAKEOVER_PROP);
        DEBUG_CLUSTER_MSG = debug_CLUSTER_MSG = Globals.getConfig().getBooleanProperty(DEBUG_MSG_PROP);
        DEBUG_CLUSTER_CONN = debug_CLUSTER_CONN = Globals.getConfig().getBooleanProperty(DEBUG_CONN_PROP);
        DEBUG_CLUSTER_PING = debug_CLUSTER_PING = Globals.getConfig().getBooleanProperty(DEBUG_PING_PROP);
        DEBUG_CLUSTER_PACKET = debug_CLUSTER_PACKET = Globals.getConfig().getBooleanProperty(DEBUG_PKT_PROP);
        DEBUG = false;
    }

    private static class BrokerChangedEntry {
        ClusterReason reason = null;
        String brokerid = null;
        Object oldValue = null;
        Object newValue = null;
        Object userData = null;
        UID brokerSession = null;

        public BrokerChangedEntry(ClusterReason reason, String brokerid, Object oldValue, Object newValue, UID bs, Object userData) {
            this.reason = reason;
            this.brokerid = brokerid;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.userData = userData;
            this.brokerSession = bs;
        }
    }

    static class ActiveInterator
    implements Iterator {
        Object nextObj = null;
        Iterator parent = null;

        public ActiveInterator(Iterator parentItr) {
            this.parent = parentItr;
        }

        @Override
        public boolean hasNext() {
            if (this.nextObj != null) {
                return true;
            }
            if (!this.parent.hasNext()) {
                return false;
            }
            while (this.nextObj == null && this.parent.hasNext()) {
                this.nextObj = this.parent.next();
                ClusteredBroker cb = (ClusteredBroker)this.nextObj;
                if (!BrokerStatus.getBrokerLinkIsDown(cb.getStatus())) continue;
                this.parent.remove();
                this.nextObj = null;
            }
            return this.nextObj != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more");
            }
            Object ret = this.nextObj;
            this.nextObj = null;
            return ret;
        }

        @Override
        public void remove() {
            this.parent.remove();
        }
    }

    static class ConfigInterator
    implements Iterator {
        Object nextObj = null;
        Iterator parent = null;

        public ConfigInterator(Iterator parentItr) {
            this.parent = parentItr;
        }

        @Override
        public boolean hasNext() {
            if (this.nextObj != null) {
                return true;
            }
            if (!this.parent.hasNext()) {
                return false;
            }
            while (this.nextObj == null && this.parent.hasNext()) {
                this.nextObj = this.parent.next();
                ClusteredBroker cb = (ClusteredBroker)this.nextObj;
                if (cb.isConfigBroker()) continue;
                this.parent.remove();
                this.nextObj = null;
            }
            return this.nextObj != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more");
            }
            Object ret = this.nextObj;
            this.nextObj = null;
            return ret;
        }

        @Override
        public void remove() {
            this.parent.remove();
        }
    }
}

