/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.sharecc.ShareConfigChangeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigChangeDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAOFactory;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.synchronizer.CloseInProgressCallback;
import com.sun.messaging.jmq.util.synchronizer.CloseInProgressSynchronizer;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.JDBCShareConfigChangeStore")
@Singleton
public class JDBCShareConfigChangeStore
extends ShareConfigChangeStore
implements CloseInProgressCallback {
    private static boolean DEBUG = JDBCShareConfigChangeStore.getDEBUG();
    public static final int VERSION_450 = 450;
    public static final int VERSION_500 = 500;
    public static final int VERSION = 500;
    public static final String SCHEMA_VERSION = "50";
    public static final String SCHEMA_VERSION_45 = "45";
    private static final String CLOSEWAIT_TIMEOUT_PROP = "imq.cluster.sharecc.persistCloseWaitTimeoutInSeconds";
    private static final int CLOSEWAIT_TIMEOUT_PROP_DEFAULT = 30;
    private boolean createStore = false;
    private final Logger logger = Globals.getLogger();
    private final BrokerResources br = Globals.getBrokerResources();
    private final BrokerConfig config = Globals.getConfig();
    private ShareConfigChangeDBManager dbmgr = null;
    private ShareConfigRecordDAOFactory daoFactory = null;
    private final CloseInProgressSynchronizer inprogresser = new CloseInProgressSynchronizer(this.logger);
    private int closeWaitTimeout = 30;

    public JDBCShareConfigChangeStore() throws BrokerException {
        Object[] args;
        String user;
        this.inprogresser.reset();
        this.closeWaitTimeout = this.config.getIntProperty(CLOSEWAIT_TIMEOUT_PROP, 30);
        this.dbmgr = ShareConfigChangeDBManager.getDBManager();
        this.daoFactory = this.dbmgr.getDAOFactory();
        String url = this.dbmgr.getOpenDBURL();
        if (url == null) {
            url = "not specified";
        }
        if ((user = this.dbmgr.getUser()) == null) {
            user = "not specified";
        }
        this.createStore = this.config.getBooleanProperty("imq.cluster.sharecc.persistCreate", false);
        if (this.createStore) {
            args = new String[]{this.br.getString("B1352"), String.valueOf(SCHEMA_VERSION), this.dbmgr.getClusterID(), url, user};
            this.logger.logToAll(8, this.br.getKString("B1351", args));
        } else {
            args = new String[]{this.br.getString("B1353"), String.valueOf(SCHEMA_VERSION), this.dbmgr.getClusterID(), url, user};
            this.logger.logToAll(8, this.br.getKString("B1351", args));
        }
        Connection conn = null;
        Exception myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            this.checkStore(conn);
        }
        catch (Exception e) {
            myex = e;
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(e.getMessage(), e);
        }
        finally {
            this.dbmgr.closeSQLObjects(null, null, conn, myex);
        }
        this.dbmgr.setStoreInited(true);
        if (DEBUG) {
            this.logger.log(4, "JDBCShareConfigChangeStore instantiated.");
        }
    }

    private void checkStore(Connection conn) throws BrokerException {
        int ret;
        boolean hasOldTable = false;
        boolean oldTableEmpty = false;
        String oldtable = this.dbmgr.getTableName("MQSHARECC45");
        String sql = "SELECT SEQ FROM " + oldtable;
        if (this.hasOldStoreTable(conn, this.dbmgr.getTableName(oldtable), sql)) {
            hasOldTable = true;
            sql = "SELECT SEQ FROM " + oldtable + " WHERE " + "TYPE" + " <> " + 31;
            oldTableEmpty = this.isOldStoreTableEmpty(conn, this.dbmgr.getTableName(oldtable), sql);
        }
        if ((ret = this.dbmgr.checkStoreExists(conn)) == -1) {
            this.logger.log(32, "B3246");
            throw new BrokerException(this.br.getKString("B3246"));
        }
        if (ret == 0) {
            if (!this.createStore && !hasOldTable) {
                this.logger.log(32, "B3247");
                throw new BrokerException(this.br.getKString("B3132"));
            }
            this.logger.logToAll(8, this.br.getKString("B1354", this.br.getString("B1355")));
            try {
                DBTool.createTables(conn, false, this.dbmgr);
            }
            catch (Exception e) {
                String url = this.dbmgr.getCreateDBURL();
                if (url == null || url.length() == 0) {
                    url = this.dbmgr.getOpenDBURL();
                }
                String emsg = this.br.getKString("B3248", this.br.getString("B1355"));
                this.logger.logToAll(32, emsg + "-" + url, e);
                throw new BrokerException(emsg, e);
            }
        }
        if (!hasOldTable || oldTableEmpty) {
            return;
        }
        this.migrateOldTableData(conn, oldtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasOldStoreTable(Connection conn, String table, String sql) throws BrokerException {
        boolean bl;
        Statement stmt = null;
        ResultSet rs = null;
        SQLException myex = null;
        try {
            stmt = conn.createStatement();
            rs = ShareConfigChangeDBManager.executeQueryStatement(stmt, sql);
            bl = true;
        }
        catch (SQLException e) {
            try {
                try {
                    myex = e;
                    this.logger.log(4, "Assume old schema sharecc table does not exist because: " + e.toString());
                }
                catch (Throwable throwable) {
                    Util.close(rs, stmt, null, myex);
                    throw throwable;
                }
                Util.close(rs, stmt, null, myex);
                return false;
            }
            catch (Exception e2) {
                String emsg = this.br.getKString("B4413", table, e2.toString());
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        Util.close(rs, stmt, null, myex);
        return bl;
    }

    private boolean isOldStoreTableEmpty(Connection conn, String table, String sql) throws BrokerException {
        boolean bl;
        ResultSet rs;
        Statement stmt;
        Exception myex;
        block6: {
            myex = null;
            stmt = null;
            rs = null;
            stmt = conn.createStatement();
            rs = ShareConfigChangeDBManager.executeQueryStatement(stmt, sql);
            if (!rs.next()) break block6;
            boolean bl2 = false;
            Util.close(rs, stmt, null, myex);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            try {
                myex = e;
                Exception ex = e;
                if (e instanceof SQLException) {
                    ex = ShareConfigChangeDBManager.wrapSQLException("[" + sql + "]", (SQLException)e);
                }
                throw new BrokerException(this.br.getKString("B4414", table, ex.getMessage()), ex);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateOldTableData(Connection conn, String oldTable) throws BrokerException {
        ShareConfigRecordDAO dao = this.dbmgr.getDAOFactory().getShareConfigRecordDAO();
        long totalwait = 30000L;
        ChangeRecordInfo resetcri = ChangeRecord.makeResetRecord(true);
        while (true) {
            try {
                this.dbmgr.lockTables(conn, true, resetcri);
            }
            catch (BrokerException e) {
                String ecode = e.getErrorCode();
                if (ecode != null) {
                    if (ecode.equals("B3303")) {
                        if (!this.dbmgr.getIsClosing() && totalwait > 0L) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            totalwait -= 5000L;
                            continue;
                        }
                        throw e;
                    }
                }
                if (ecode != null) {
                    if (ecode.equals("B3266")) {
                        return;
                    }
                }
                throw e;
            }
            break;
        }
        Object[] logargs = new Object[]{"", oldTable, dao.getTableName()};
        this.logger.log(8, this.br.getKString("B1458", logargs));
        ArrayList<ChangeRecordInfo> newcris = new ArrayList<ChangeRecordInfo>();
        try {
            String sql = "SELECT * FROM " + oldTable;
            List<ChangeRecordInfo> cris = dao.getAllRecords(conn, sql);
            ArrayList<ChangeRecord> records = ChangeRecord.compressRecords(cris);
            ChangeRecordInfo newcri = null;
            ChangeRecord rec2 = null;
            for (ChangeRecord rec2 : records) {
                if (rec2.isDiscard()) continue;
                newcri = new ChangeRecordInfo(null, rec2.getUUID(), rec2.getBytes(), rec2.getOperation(), rec2.getUniqueKey(), System.currentTimeMillis());
                newcri.setDuraAdd(rec2.isDuraAdd());
                newcri.setResetUUID(resetcri.getUUID());
                newcris.add(newcri);
            }
            Object[] args = new Object[]{newcris.size() + "(" + cris.size() + ")", oldTable, dao.getTableName()};
            this.logger.log(8, this.br.getKString("B1458", args));
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4419", oldTable);
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        dao.insertAll(newcris, oldTable);
        this.logger.log(8, this.br.getKString("B1459", oldTable, dao.getTableName()));
        try {
            String[] olds = new String[]{oldTable};
            DBTool.dropTables(conn, olds, true, true, this.dbmgr);
            this.logger.log(8, this.br.getKString("B1460", oldTable));
        }
        catch (Exception e) {
            this.logger.log(16, e.getMessage(), e);
        }
        finally {
            try {
                this.dbmgr.lockTables(conn, false);
            }
            catch (Exception e) {
                String emsg = this.br.getKString("B4418", e.getMessage());
                this.logger.logStack(32, emsg, e);
                throw new BrokerException(emsg, e);
            }
        }
    }

    @Override
    public Properties getStoreShareProperties() {
        if (this.dbmgr == null) {
            throw new RuntimeException("JDBShareConfigChangeStore not initialized");
        }
        Properties p = new Properties();
        p.setProperty(this.dbmgr.getOpenDBUrlProp(), this.dbmgr.getOpenDBUrl());
        return p;
    }

    @Override
    public String getVendorPropertySetting() {
        return this.dbmgr.getVendorProp() + "=" + this.dbmgr.getVendor();
    }

    public final String getStoreVersion() {
        return SCHEMA_VERSION;
    }

    private void checkClosedAndSetInProgress() throws BrokerException {
        try {
            this.inprogresser.checkClosedAndSetInProgressWithWait(this.closeWaitTimeout, this.br.getKString("B1357"));
        }
        catch (IllegalStateException e) {
            this.logger.log(32, "B3102");
            throw new BrokerException(this.br.getKString("B3102"));
        }
        catch (TimeoutException e) {
            String msg = this.br.getKString("B2237", this.closeWaitTimeout);
            this.logger.log(32, msg);
            throw new BrokerException(msg);
        }
        catch (Exception e) {
            String msg = this.br.getKString("B3249", e.toString());
            this.logger.log(32, msg);
            throw new BrokerException(msg);
        }
    }

    @Override
    public ChangeRecordInfo storeChangeRecord(ChangeRecordInfo rec, boolean sync) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCShareCCStore.storeChangeRecord called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    ChangeRecordInfo changeRecordInfo = this.daoFactory.getShareConfigRecordDAO().insert(null, rec);
                    return changeRecordInfo;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.inprogresser.setInProgress(false);
        }
    }

    @Override
    public void storeResetRecord(ChangeRecordInfo rec, boolean canExist, boolean sync) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "JDBCShareCCStore.storeResetRecord called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getShareConfigRecordDAO().insertResetRecord(null, rec, null);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.inprogresser.setInProgress(false);
        }
    }

    @Override
    public List<ChangeRecordInfo> getChangeRecordsSince(Long seq, String resetUUID, boolean canReset) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCShareCCStore.getChangeRecordsSince(" + seq + ", " + resetUUID + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    List<ChangeRecordInfo> list = this.daoFactory.getShareConfigRecordDAO().getRecords(null, seq, resetUUID, canReset);
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.inprogresser.setInProgress(false);
        }
    }

    @Override
    public List<ChangeRecordInfo> getAllChangeRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "JDBCShareCCStore.getAllChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    List<ChangeRecordInfo> list = this.daoFactory.getShareConfigRecordDAO().getRecords(null, null, null, true);
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.inprogresser.setInProgress(false);
        }
    }

    @Override
    public void clearAllChangeRecords(boolean sync) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCShareCCStore.clearAllChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getShareConfigRecordDAO().deleteAll(null);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.inprogresser.setInProgress(false);
        }
    }

    @Override
    public void beforeWaitAfterSetClosed() {
        if (this.dbmgr != null) {
            this.dbmgr.setIsClosing();
        }
    }

    @Override
    public void close() {
        try {
            this.inprogresser.setClosedAndWaitWithTimeout(this, this.closeWaitTimeout, this.br.getKString("B1356"));
        }
        catch (Exception e) {
            this.logger.log(16, this.br.getKString("B2238", e.toString()));
        }
        this.dbmgr.close();
        this.dbmgr.setStoreInited(false);
        if (DEBUG) {
            this.logger.log(4, "JDBCShareConfigChangeStore.close done.");
        }
    }

    public String getStoreType() {
        return "jdbc";
    }

    public Hashtable getDebugState() throws BrokerException {
        Hashtable<String, Object> t = new Hashtable<String, Object>();
        t.put("JDBCSharedConfigChangeStore", "version:" + String.valueOf(SCHEMA_VERSION));
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            Iterator itr = this.daoFactory.getAllDAOs().iterator();
            while (itr.hasNext()) {
                t.putAll(((BaseDAO)itr.next()).getDebugInfo(conn));
            }
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            this.dbmgr.closeSQLObjects(null, null, conn, myex);
        }
        t.put("DBManager", this.dbmgr.getDebugState());
        return t;
    }
}

