/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.xml;

import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.xml.messaging.JAXMException;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class MessageTransformer {
    private MessageTransformer() {
    }

    public static Message SOAPMessageIntoJMSMessage(SOAPMessage soapMessage, Session session) throws JAXMException {
        try {
            BytesMessage bmessage = session.createBytesMessage();
            soapMessage.saveChanges();
            MessageTransformer.writeMimeHeaders(soapMessage, bmessage);
            MessageTransformer.writeSOAPBody(soapMessage, bmessage);
            return bmessage;
        }
        catch (JAXMException JAXMe) {
            throw JAXMe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JAXMException(e);
        }
    }

    public static SOAPMessage SOAPMessageFromJMSMessage(Message message, MessageFactory messageFactory) throws JAXMException {
        SOAPMessage soapMessage = null;
        BytesMessage bmessage = (BytesMessage)message;
        try {
            int mimeLength = bmessage.readInt();
            byte[] mbuf = new byte[mimeLength];
            bmessage.readBytes(mbuf, mimeLength);
            ByteArrayInputStream mbin = new ByteArrayInputStream(mbuf);
            FilteringObjectInputStream oi = new FilteringObjectInputStream((InputStream)mbin);
            Hashtable ht = (Hashtable)oi.readObject();
            MimeHeaders mimeHeaders = MessageTransformer.hashtableToMime(ht);
            int bodyLength = bmessage.readInt();
            byte[] buf = new byte[bodyLength];
            bmessage.readBytes(buf, bodyLength);
            ByteArrayInputStream bin = new ByteArrayInputStream(buf);
            if (messageFactory == null) {
                messageFactory = MessageTransformer.getMessageFactory();
            }
            soapMessage = messageFactory.createMessage(mimeHeaders, (InputStream)bin);
        }
        catch (Exception e) {
            throw new JAXMException(e);
        }
        return soapMessage;
    }

    private static void writeMimeHeaders(SOAPMessage soapMessage, BytesMessage bmessage) throws Exception {
        MimeHeaders mimeHeaders = soapMessage.getMimeHeaders();
        Hashtable hashtable = MessageTransformer.MimeToHashtable(mimeHeaders);
        ByteArrayOutputStream mimeOut = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(mimeOut);
        oo.writeObject(hashtable);
        oo.flush();
        oo.close();
        byte[] mimebuf = mimeOut.toByteArray();
        bmessage.writeInt(mimebuf.length);
        bmessage.writeBytes(mimebuf);
        mimeOut.close();
    }

    private static void writeSOAPBody(SOAPMessage soapMessage, BytesMessage bmessage) throws Exception {
        ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)bodyOut);
        byte[] buf = bodyOut.toByteArray();
        bmessage.writeInt(buf.length);
        bmessage.writeBytes(buf);
        bodyOut.close();
    }

    private static Hashtable MimeToHashtable(MimeHeaders mimeHeaders) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator it = mimeHeaders.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader mh = (MimeHeader)it.next();
            hashtable.put(mh.getName(), mh.getValue());
        }
        return hashtable;
    }

    private static MimeHeaders hashtableToMime(Hashtable hashtable) {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Enumeration enm = hashtable.keys();
        while (enm.hasMoreElements()) {
            Object key = enm.nextElement();
            mimeHeaders.addHeader((String)key, (String)hashtable.get(key));
        }
        return mimeHeaders;
    }

    private static MessageFactory getMessageFactory() throws SOAPException {
        return MessageFactory.newInstance();
    }
}

