/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.bridgemgr;

import com.sun.messaging.bridge.admin.bridgemgr.BridgeAdmin;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrException;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrOptions;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrPrinter;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrProperties;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrStatusEvent;
import com.sun.messaging.bridge.admin.bridgemgr.Globals;
import com.sun.messaging.bridge.admin.bridgemgr.resources.BridgeAdminResources;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdException;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdRunnerUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;

public class CmdRunner
implements BridgeMgrOptions,
AdminEventListener {
    private BridgeAdminResources ar = Globals.getBridgeAdminResources();
    private BridgeMgrProperties bridgeMgrProps;

    public CmdRunner(BridgeMgrProperties props) {
        this.bridgeMgrProps = props;
    }

    public int runCommand() {
        int exitcode = 0;
        String cmd = this.bridgeMgrProps.getCommand();
        if (cmd.equals("list")) {
            exitcode = this.runCommand(this.bridgeMgrProps);
        } else if (cmd.equals("pause")) {
            exitcode = this.runCommand(this.bridgeMgrProps);
        } else if (cmd.equals("resume")) {
            exitcode = this.runCommand(this.bridgeMgrProps);
        } else if (cmd.equals("start")) {
            exitcode = this.runCommand(this.bridgeMgrProps);
        } else if (cmd.equals("stop")) {
            exitcode = this.runCommand(this.bridgeMgrProps);
        } else if (this.bridgeMgrProps.debugModeSet() && cmd.equals("debug")) {
            exitcode = this.runCommand(this.bridgeMgrProps);
        }
        return exitcode;
    }

    /*
     * Unable to fully structure code
     */
    private int runCommand(BridgeMgrProperties bridgeMgrProps) {
        input = null;
        yes = this.ar.getString("BA5004");
        yesShort = this.ar.getString("BA5003");
        no = this.ar.getString("BA5006");
        noShort = this.ar.getString("BA5005");
        broker = this.init();
        force = bridgeMgrProps.forceModeSet();
        cmd = bridgeMgrProps.getCommand();
        commandArg = bridgeMgrProps.getCommandArg();
        bn = bridgeMgrProps.getBridgeName();
        bt = bridgeMgrProps.getBridgeType();
        ln = bridgeMgrProps.getLinkName();
        debugMode = bridgeMgrProps.debugModeSet();
        if (debugMode && cmd.equals("debug")) {
            if (broker == null) {
                Globals.stdErrPrintln("Problem connecting to the broker");
                return 1;
            }
            if (!force) {
                broker = (BridgeAdmin)CommonCmdRunnerUtil.promptForAuthentication(broker);
            }
            target = bridgeMgrProps.getTargetName();
            optionalProps = bridgeMgrProps.getTargetAttrs();
            Globals.stdOutPrintln("Sending the following DEBUG message:");
            if (target != null) {
                bmp = new BridgeMgrPrinter(2, 4, null, 0, false);
                row = new String[]{commandArg, target};
                bmp.add(row);
                bmp.println();
            } else {
                bmp = new BridgeMgrPrinter(1, 4, null, 0, false);
                row = new String[]{commandArg};
                bmp.add(row);
                bmp.println();
            }
            if (optionalProps != null && optionalProps.size() > 0) {
                Globals.stdOutPrintln("Optional properties:");
                CommonCmdRunnerUtil.printAttrs(optionalProps, true, new BridgeMgrPrinter());
            }
            Globals.stdOutPrintln("To the broker specified by:");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendDebugMessage(commandArg, target, optionalProps);
                debugHash = broker.receiveDebugReplyMessage();
                if (debugHash != null && debugHash.size() > 0) {
                    Globals.stdOutPrintln("Data received back from broker:");
                    CommonCmdRunnerUtil.printDebugHash(debugHash);
                } else {
                    Globals.stdOutPrintln("No additional data received back from broker.\n");
                }
                Globals.stdOutPrintln("DEBUG message sent successfully.");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                return 1;
            }
        }
        if (!"bridge".equals(commandArg)) ** GOTO lbl170
        if (broker == null) {
            Globals.stdErrPrintln(this.ar.getString("BA1068", this.getLocalizedCmd(cmd)));
            return 1;
        }
        if (!force) {
            broker = (BridgeAdmin)CommonCmdRunnerUtil.promptForAuthentication(broker);
        }
        single = false;
        startRet = true;
        if (bn == null || bn.trim().equals("")) {
            if (bt == null || bt.trim().equals("")) {
                Globals.stdOutPrintln(this.ar.getString("BA1060", this.getLocalizedCmd(cmd)));
            } else {
                Globals.stdOutPrintln(this.ar.getString("BA1061", this.getLocalizedCmd(cmd)));
                this.printBridgeInfo(false);
                Globals.stdOutPrintln(this.ar.getString("BA1062"));
            }
        } else {
            Globals.stdOutPrintln(this.ar.getString("BA1063", this.getLocalizedCmd(cmd)));
            this.printBridgeInfo();
            Globals.stdOutPrintln(this.ar.getString("BA1062"));
            single = true;
        }
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            if (single) {
                Globals.stdErrPrintln(this.ar.getString("BA1068", this.getLocalizedCmd(cmd)));
            } else {
                Globals.stdErrPrintln(this.ar.getString("BA1066", this.getLocalizedCmd(cmd)));
            }
            return 1;
        }
        if (cmd.equals("list")) {
            force = true;
        }
        if (!force) {
            input = this.getUserInput(this.ar.getString("BA5001", this.getLocalizedCmd(cmd)), noShort);
            Globals.stdOutPrintln("");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            try {
                if (cmd.equals("list")) {
                    broker.sendCommandMessage(cmd, bn, bt, null, 18, "LIST", 5001, 19, "LIST_REPLY", debugMode);
                    data = broker.receiveListReplyMessage();
                    itr = data.iterator();
                    bcp = null;
                    reply = null;
                    while (itr.hasNext()) {
                        reply = itr.next();
                        bcp = new BridgeMgrPrinter();
                        bcp.copy(reply);
                        bcp.println();
                        Globals.stdOutPrintln("");
                    }
                } else if (cmd.equals("start")) {
                    broker.sendCommandMessage(cmd, bn, bt, null, 24, "START", 5002, 25, "START_REPLY");
                    startRet = broker.receiveCommandReplyMessage(cmd, 25, "START_REPLY");
                } else if (cmd.equals("stop")) {
                    broker.sendCommandMessage(cmd, bn, bt, null, 26, "STOP", 5003, 27, "STOP_REPLY");
                    broker.receiveCommandReplyMessage(cmd, 27, "STOP_REPLY");
                } else if (cmd.equals("resume")) {
                    broker.sendCommandMessage(cmd, bn, bt, null, 22, "RESUME", 5004, 23, "RESUME_REPLY");
                    broker.receiveCommandReplyMessage(cmd, 23, "RESUME_REPLY");
                } else if (cmd.equals("pause")) {
                    broker.sendCommandMessage(cmd, bn, bt, null, 20, "PAUSE", 5005, 21, "PAUSE_REPLY");
                    broker.receiveCommandReplyMessage(cmd, 21, "PAUSE_REPLY");
                } else {
                    return 1;
                }
                if (single) {
                    if (cmd.equals("start") && !startRet) {
                        Globals.stdOutPrintln(this.ar.getString("BA1084"));
                    }
                    Globals.stdOutPrintln(this.ar.getString("BA1065", this.getLocalizedCmd(cmd)));
                }
                if (cmd.equals("start") && !startRet) {
                    Globals.stdOutPrintln(this.ar.getString("BA1085"));
                }
                Globals.stdOutPrintln(this.ar.getString("BA1064", this.getLocalizedCmd(cmd)));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (single) {
                    Globals.stdErrPrintln(this.ar.getString("BA1068", this.getLocalizedCmd(cmd)));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("BA1066", this.getLocalizedCmd(cmd)));
                }
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                if (single) {
                    Globals.stdOutPrintln(this.ar.getString("BA1069", this.getLocalizedCmd(cmd)));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("BA1067", this.getLocalizedCmd(cmd)));
                }
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("BA1079", input));
            Globals.stdOutPrintln("");
            if (single) {
                Globals.stdOutPrintln(this.ar.getString("BA1069", this.getLocalizedCmd(cmd)));
            } else {
                Globals.stdOutPrintln(this.ar.getString("BA1067", this.getLocalizedCmd(cmd)));
            }
            return 1;
lbl170:
            // 1 sources

            if ("link".equals(commandArg)) {
                if (broker == null) {
                    Globals.stdErrPrintln(this.ar.getString("BA1072", this.getLocalizedCmd(cmd)));
                    return 1;
                }
                if (!force) {
                    broker = (BridgeAdmin)CommonCmdRunnerUtil.promptForAuthentication(broker);
                }
                Globals.stdOutPrintln(this.ar.getString("BA1070", this.getLocalizedCmd(cmd)));
                this.printLinkInfo();
                Globals.stdOutPrintln(this.ar.getString("BA1062"));
                this.printBrokerInfo(broker);
                try {
                    this.connectToBroker(broker);
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("BA1072", this.getLocalizedCmd(cmd)));
                    return 1;
                }
                if (cmd.equals("list")) {
                    force = true;
                }
                if (!force) {
                    input = this.getUserInput(this.ar.getString("BA5002", this.getLocalizedCmd(cmd)), noShort);
                    Globals.stdOutPrintln("");
                }
                startRet = true;
                if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                    try {
                        if (cmd.equals("list")) {
                            broker.sendCommandMessage(cmd, bn, bt, ln, 18, "LIST", 5001, 19, "LIST_REPLY", debugMode);
                            data = broker.receiveListReplyMessage();
                            itr = data.iterator();
                            bcp = null;
                            reply = null;
                            while (itr.hasNext()) {
                                reply = itr.next();
                                bcp = new BridgeMgrPrinter();
                                bcp.copy(reply);
                                bcp.println();
                            }
                        } else if (cmd.equals("start")) {
                            broker.sendCommandMessage(cmd, bn, bt, ln, 24, "START", 5002, 25, "START_REPLY");
                            startRet = broker.receiveCommandReplyMessage(cmd, 25, "START_REPLY");
                        } else if (cmd.equals("stop")) {
                            broker.sendCommandMessage(cmd, bn, bt, ln, 26, "STOP", 5003, 27, "STOP_REPLY");
                            broker.receiveCommandReplyMessage(cmd, 27, "STOP_REPLY");
                        } else if (cmd.equals("resume")) {
                            broker.sendCommandMessage(cmd, bn, bt, ln, 22, "RESUME", 5004, 23, "RESUME_REPLY");
                            broker.receiveCommandReplyMessage(cmd, 23, "RESUME_REPLY");
                        } else if (cmd.equals("pause")) {
                            broker.sendCommandMessage(cmd, bn, bt, ln, 20, "PAUSE", 5005, 21, "PAUSE_REPLY");
                            broker.receiveCommandReplyMessage(cmd, 21, "PAUSE_REPLY");
                        } else {
                            return 1;
                        }
                        if (cmd.equals("start") && !startRet) {
                            Globals.stdOutPrintln(this.ar.getString("BA1086"));
                        }
                        Globals.stdOutPrintln(this.ar.getString("BA1071", this.getLocalizedCmd(cmd)));
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        Globals.stdErrPrintln(this.ar.getString("BA1072", this.getLocalizedCmd(cmd)));
                        return 1;
                    }
                } else {
                    if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                        Globals.stdOutPrintln(this.ar.getString("BA1073", this.getLocalizedCmd(cmd)));
                        return 0;
                    }
                    Globals.stdOutPrintln(this.ar.getString("BA1079", input));
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("BA1073", this.getLocalizedCmd(cmd)));
                    return 1;
                }
            }
        }
        broker.close();
        return 0;
    }

    private BridgeAdmin init() {
        BridgeAdmin broker;
        String brokerHostPort = this.bridgeMgrProps.getBrokerHostPort();
        String adminUser = this.bridgeMgrProps.getAdminUserId();
        int numRetries = this.bridgeMgrProps.getNumRetries();
        int receiveTimeout = this.bridgeMgrProps.getReceiveTimeout();
        boolean useSSL = this.bridgeMgrProps.useSSLTransportSet();
        if (this.bridgeMgrProps.adminDebugModeSet()) {
            BridgeAdmin.setDebug(true);
        }
        try {
            String adminPasswd = this.getPasswordFromFileOrCmdLine(this.bridgeMgrProps);
            broker = new BridgeAdmin(brokerHostPort, adminUser, adminPasswd, receiveTimeout * 1000, useSSL);
            if (useSSL) {
                broker.setSSLTransportUsed(true);
            }
            if (numRetries > 0) {
                broker.setNumRetries(numRetries);
            }
        }
        catch (BridgeMgrException bce) {
            this.handleBridgeMgrException(bce);
            return null;
        }
        catch (CommonCmdException cce) {
            this.handleBridgeMgrException(cce);
            return null;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return null;
        }
        broker.setCheckShutdownReply(false);
        broker.addAdminEventListener(this);
        return broker;
    }

    private void connectToBroker(BridgeAdmin broker) throws BrokerAdminException {
        broker.connect();
        broker.sendHelloMessage();
        broker.receiveHelloReplyMessage();
    }

    private void handleBrokerAdminException(BrokerAdminException bae) {
        CommonCmdRunnerUtil.printBrokerAdminException(bae, "-b", this.bridgeMgrProps.debugModeSet());
    }

    private void handleBridgeMgrException(CommonCmdException bce) {
        CommonCmdRunnerUtil.printCommonCmdException(bce);
    }

    private String getUserInput(String question, String defaultResponse) {
        return CommonCmdRunnerUtil.getUserInput(question, defaultResponse);
    }

    private void printBrokerInfo(BridgeAdmin broker) {
        CommonCmdRunnerUtil.printBrokerInfo(broker, new BridgeMgrPrinter());
    }

    private void printBridgeInfo() {
        this.printBridgeInfo(true);
    }

    private void printBridgeInfo(boolean printName) {
        String value;
        String title;
        BridgeMgrPrinter bcp = new BridgeMgrPrinter(1, 4, "-");
        Object[] row = new String[1];
        if (printName) {
            title = this.ar.getString("BA1081");
            value = this.bridgeMgrProps.getBridgeName();
        } else {
            title = this.ar.getString("BA1082");
            value = this.bridgeMgrProps.getBridgeType();
        }
        row[0] = title;
        bcp.addTitle((String[])row);
        row[0] = value;
        bcp.add(row);
        bcp.println();
    }

    private void printLinkInfo() {
        BridgeMgrPrinter bcp = new BridgeMgrPrinter(2, 4, "-");
        Object[] row = new String[2];
        String ln = this.bridgeMgrProps.getLinkName();
        String bn = this.bridgeMgrProps.getBridgeName();
        row[0] = this.ar.getString("BA1081");
        row[1] = this.ar.getString("BA1083");
        bcp.addTitle((String[])row);
        row[0] = bn;
        row[1] = ln;
        bcp.add(row);
        bcp.println();
    }

    private String getPasswordFromFileOrCmdLine(BridgeMgrProperties bridgeMgrProps) throws CommonCmdException {
        String passwd = bridgeMgrProps.getAdminPasswd();
        String passfile = bridgeMgrProps.getAdminPassfile();
        if (passwd != null) {
            return passwd;
        }
        return CommonCmdRunnerUtil.getPasswordFromFile(passfile, "imq.imqbridgemgr.password", bridgeMgrProps);
    }

    @Override
    public void adminEventDispatched(AdminEvent e) {
        BridgeMgrStatusEvent be;
        int type;
        if (e instanceof BridgeMgrStatusEvent && (type = (be = (BridgeMgrStatusEvent)e).getType()) == 10000) {
            CommonCmdRunnerUtil.printBrokerBusyEvent(be);
        }
    }

    private String getLocalizedCmd(String cmd) {
        if (cmd.equals("list")) {
            return this.ar.getString("BA1074");
        }
        if (cmd.equals("pause")) {
            return this.ar.getString("BA1078");
        }
        if (cmd.equals("resume")) {
            return this.ar.getString("BA1077");
        }
        if (cmd.equals("start")) {
            return this.ar.getString("BA1075");
        }
        if (cmd.equals("stop")) {
            return this.ar.getString("BA1076");
        }
        return cmd;
    }
}

